/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.qe.LiteMorph;
import com.sun.xmlsearch.qe.LiteMorph_en;
import com.sun.xmlsearch.util.Configuration;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.util.LineInput;
import com.sun.xmlsearch.util.SimpleTokenizer;
import com.sun.xmlsearch.util.Tokenizer;
import com.sun.xmlsearch.xml.XmlIndex;
import com.sun.xmlsearch.xml.qe.Query;
import com.sun.xmlsearch.xml.qe.QueryProcessor;
import com.sun.xmlsearch.xml.qe.QueryResults;
import com.sun.xmlsearch.xml.qe.QueryStatement;
import com.sun.xmlsearch.xml.qe.Search;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public final class QueryProcessorImpl
implements QueryProcessor {
    private static double INFLpenalty = 0.5;
    private XmlIndex _env;
    private LiteMorph _morph = LiteMorph_en.getMorph();
    private Tokenizer _tokenizer = new SimpleTokenizer();
    private String[] _prefixTranslations;
    private String _defaultSearchUnit;
    private String _collectionName;
    private String _collectionClassification;
    private String _docType;
    private String _indexLocation;
    private Element _configuration;
    private String[] _ignoredElements;

    public String getName() {
        return this.getCollectionName();
    }

    public String getCollectionName() {
        return this._collectionName;
    }

    public String getClassification() {
        return this._collectionClassification;
    }

    public String getDocumentType() {
        return this._docType;
    }

    public boolean init(String string) throws Exception {
        this._env = new XmlIndex(string, false);
        return this._env.init();
    }

    public boolean init(Element element) throws Exception {
        if (element.getTagName().equals("XmlSearchEngine")) {
            this._configuration = element;
            this._collectionName = element.getAttribute("name");
            System.out.println("collection name: " + this._collectionName);
            this._collectionClassification = element.getAttribute("category");
            this._indexLocation = element.getAttribute("indexLocation");
            System.out.println("index location: " + this._indexLocation);
            this._defaultSearchUnit = element.getAttribute("defaultSearchUnit");
            System.out.println("default search unit: " + this._defaultSearchUnit);
            this._docType = element.getAttribute("documentType");
            System.out.println("document type: " + this._docType);
            this._prefixTranslations = Configuration.processPrefixTranslations(element);
            StringTokenizer stringTokenizer = new StringTokenizer(element.getAttribute("ignoredElements"));
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                this._ignoredElements = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    this._ignoredElements[n2] = stringTokenizer.nextToken();
                    System.out.println("ignore " + this._ignoredElements[n2]);
                    ++n2;
                }
            }
            this._env = new XmlIndex(this._indexLocation, false);
            return this._env.init();
        }
        throw new Exception("inappropriate element in init QueryProcessor");
    }

    public QueryResults processQuery(QueryStatement queryStatement) throws RemoteException {
        try {
            Search search = this.makeSearch();
            queryStatement.defaultSearchUnit(this._defaultSearchUnit);
            Query query = this.processQuery(search, queryStatement);
            query.setIgnoredElements(this._ignoredElements);
            search.startSearch();
            return this.makeQueryResults(query, queryStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RemoteException("nested exception", exception);
        }
    }

    public QueryResults makeQueryResults(Query query, QueryStatement queryStatement) throws Exception {
        return new QueryResults(this._prefixTranslations, this._docType, query.getHits(queryStatement.getRequestedNumberOfHits()));
    }

    public synchronized Query processQuery(Search search, QueryStatement queryStatement) throws Exception {
        queryStatement.defaultSearchUnit(this._defaultSearchUnit);
        System.out.println("QueryProcessor.processQuery(\"" + queryStatement + "\")");
        StringTokenizer stringTokenizer = new StringTokenizer(queryStatement.getTerms());
        int n = stringTokenizer.countTokens();
        IntegerArray[] integerArrayArray = new IntegerArray[n];
        IntegerArray integerArray = new IntegerArray(n);
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = queryStatement.getScope();
        double d = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("%")) {
                System.err.println("+ not implemented");
                continue;
            }
            ++n4;
            String string3 = string2.toLowerCase();
            int n5 = 0;
            IntegerArray integerArray2 = new IntegerArray();
            if (string3.startsWith("\"")) {
                n5 = this._env.fetch(string3.substring(1, string3.length() - 1));
            } else if (string3.endsWith("*")) {
                integerArray2 = this._env.withPrefix(string3.substring(0, string3.length() - 1));
                d = 0.0;
            } else {
                n5 = this._env.fetch(string3);
                String[] stringArray = this._morph.variantsOf(string3);
                int n6 = 0;
                while (n6 < stringArray.length) {
                    int n7 = this._env.fetch(stringArray[n6]);
                    if (n7 > 0 && n7 != n5) {
                        integerArray2.add(n7);
                    }
                    ++n6;
                }
                d = INFLpenalty;
            }
            if (integerArray2.cardinality() > 0 || n5 > 0) {
                integerArrayArray[n2] = integerArray2;
                nArray[n2] = n5;
                ++n2;
                continue;
            }
            ++n3;
            integerArray.add(n4 - 1);
        }
        return search.addQuery(string, n2, n3, queryStatement.getRequestedNumberOfHits(), nArray, integerArrayArray, d);
    }

    public void close() throws Exception {
        this._env.close();
    }

    public Search makeSearch() {
        return new Search(this._env);
    }

    public static void main(String[] stringArray) {
        try {
            QueryProcessorImpl queryProcessorImpl = new QueryProcessorImpl();
            if (queryProcessorImpl.init(stringArray[0])) {
                if (stringArray.length > 1 && stringArray[1].equals("list")) {
                    Search search = queryProcessorImpl.makeSearch();
                    search.listPositions();
                } else if (stringArray.length > 1 && stringArray[1].equals("words")) {
                    Search search = queryProcessorImpl.makeSearch();
                    search.listConcepts(0, 379, 402);
                } else {
                    String string;
                    LineInput lineInput = new LineInput(System.in);
                    System.out.println("initialized; enter query");
                    while (!(string = lineInput.readLine()).equals(".")) {
                        long l = System.currentTimeMillis();
                        Search search = queryProcessorImpl.makeSearch();
                        Query query = queryProcessorImpl.processQuery(search, new QueryStatement(string, "PARA[2]", 25));
                        search.startSearch();
                        System.out.println(query.getHitsInXml(25));
                        System.out.println(System.currentTimeMillis() - l + " msec search");
                        System.out.println("enter next query or . to quit");
                    }
                }
                queryProcessorImpl.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

