/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.db.Block;
import com.sun.xmlsearch.db.BlockFactory;
import com.sun.xmlsearch.db.BlockManager;
import com.sun.xmlsearch.db.BlockProcessor;
import com.sun.xmlsearch.db.BtreeDictParameters;
import com.sun.xmlsearch.db.EntryProcessor;
import com.sun.xmlsearch.util.IntegerArray;

public class BtreeDict {
    protected static final int ENTHEADERLEN = 6;
    protected static final int BLOCKSIZE = 2048;
    protected static final int DATALEN = 2040;
    protected static final int MaxKeyLength = 255;
    protected static final int lastPtrIndex = 508;
    protected BlockManager blockManager;
    protected int root;
    protected int[] blocks;
    private boolean debug = true;

    protected BtreeDict() {
    }

    public BtreeDict(BtreeDictParameters btreeDictParameters) throws Exception {
        this.init(btreeDictParameters, false, new BlockFactory(){

            public Block makeBlock() {
                return new DictBlock();
            }
        });
        this.blocks = new int[btreeDictParameters.getFreeID()];
        this.setBlocks(this.blocks);
    }

    public int fetch(String string) throws Exception {
        int n = string.length();
        byte[] byArray = new byte[n + 1];
        System.arraycopy(string.getBytes(), 0, byArray, 0, n);
        byArray[n] = 0;
        return this.find(this.accessBlock(this.root), byArray);
    }

    public String fetch(int n) throws Exception {
        return this.findID(this.blocks[n], n);
    }

    public IntegerArray withPrefix(String string) throws Exception {
        IntegerArray integerArray = new IntegerArray();
        this.accessBlock(this.root).withPrefix(this, string, string.length(), integerArray);
        return integerArray;
    }

    public void close() throws Exception {
        this.blockManager.close();
    }

    protected void init(BtreeDictParameters btreeDictParameters, boolean bl, BlockFactory blockFactory) throws Exception {
        this.blockManager = new BlockManager(btreeDictParameters, bl, blockFactory);
        this.root = btreeDictParameters.getRootPosition();
    }

    protected void lock(Block block) {
        this.blockManager.lockBlock(block._number);
    }

    protected void unlock(Block block) {
        this.blockManager.unlockBlock(block._number);
    }

    protected DictBlock accessBlock(int n) throws Exception {
        return (DictBlock)this.blockManager.accessBlock(n);
    }

    protected DictBlock child(DictBlock dictBlock, int n) throws Exception {
        return this.accessBlock(dictBlock.getChildIdx(n));
    }

    private String findID(int n, int n2) throws Exception {
        return this.accessBlock(n).findID(n2);
    }

    private int find(DictBlock dictBlock, byte[] byArray, int n) throws Exception {
        return dictBlock._isLeaf ? 0 : this.find(this.child(dictBlock, n), byArray);
    }

    private int find(DictBlock dictBlock, byte[] byArray) throws Exception {
        int n = byArray.length - 1;
        int n2 = dictBlock.firstEntry();
        int n3 = dictBlock.free();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n2 != n3) {
            if (n5 == n4) {
                int n7 = dictBlock.entryKeyLength(n2);
                int n8 = dictBlock.entryKey(n2);
                int n9 = 0;
                while (n9 < n7 && byArray[n4] == dictBlock._data[n8 + n9]) {
                    ++n4;
                    ++n9;
                }
                if (n9 == n7) {
                    if (n4 == n) {
                        return dictBlock.entryID(n2);
                    }
                } else if ((byArray[n4] & 0xFF) < (dictBlock._data[n8 + n9] & 0xFF)) {
                    return this.find(dictBlock, byArray, n6);
                }
            } else if (n5 < n4) {
                return this.find(dictBlock, byArray, n2 == n3 ? dictBlock.numberOfEntries() : n6);
            }
            do {
                n2 = dictBlock.nextEntry(n2);
                ++n6;
            } while (dictBlock.entryCompression(n2) > n4);
            n5 = dictBlock.entryCompression(n2);
        }
        return this.find(dictBlock, byArray, dictBlock.numberOfEntries());
    }

    protected void setBlocks(final int[] nArray) throws Exception {
        long l = System.currentTimeMillis();
        this.blockManager.mapBlocks(new BlockProcessor(){

            public void process(Block block) {
                ((DictBlock)block).setBlockNumbers(nArray);
            }
        });
        this.debug(System.currentTimeMillis() - l + " msec; DICTIONARY");
    }

    public void map(EntryProcessor entryProcessor) throws Exception {
        this.accessBlock(this.root).doMap(this, entryProcessor);
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("BtreeDict: " + string);
        }
    }

    public void test() throws Exception {
        this.accessBlock(651).listBlock();
    }

    protected class DictBlock
    extends Block {
        public DictBlock() {
            super(2048);
        }

        public final int free() {
            return this._free + this.firstEntry();
        }

        public final int numberOfEntries() {
            return this.integerAt(0);
        }

        public final int nthPointer(int n) {
            return this.integerAt(4 * (n + 1));
        }

        public final int getChildIdx(int n) {
            return this.nthPointer(508 - n);
        }

        public final int entryKeyLength(int n) {
            return this._data[n] & 0xFF;
        }

        public final int entryCompression(int n) {
            return this._data[n + 1] & 0xFF;
        }

        public final int entryID(int n) {
            return this.integerAt(n + 2);
        }

        public final int entryLength(int n) {
            return 6 + this.entryKeyLength(n);
        }

        public final int entryKey(int n) {
            return n + 6;
        }

        public final int firstEntry() {
            return 4;
        }

        public final int nextEntry(int n) {
            return n + this.entryLength(n);
        }

        public final void restoreKeyInBuffer(int n, byte[] byArray) {
            int n2 = this.entryKeyLength(n);
            int n3 = this.entryCompression(n);
            int n4 = this.entryKey(n);
            while (n2-- > 0) {
                byArray[n3++] = this._data[n4++];
            }
        }

        public final String restoreKey(int n, byte[] byArray) {
            int n2 = this.entryKeyLength(n);
            int n3 = this.entryCompression(n);
            int n4 = this.entryKey(n);
            while (n2-- > 0) {
                byArray[n3++] = this._data[n4++];
            }
            return new String(byArray, 0, n3);
        }

        public final String findID(int n) throws Exception {
            byte[] byArray = new byte[255];
            int n2 = this.free();
            int n3 = this.firstEntry();
            while (n3 < n2) {
                if (this.entryID(n3) == n) {
                    return this.restoreKey(n3, byArray);
                }
                this.restoreKeyInBuffer(n3, byArray);
                n3 = this.nextEntry(n3);
            }
            throw new Exception("ID not found in block");
        }

        protected void setBlockNumbers(int[] nArray) {
            int n = this.firstEntry();
            while (n < this._free) {
                nArray[this.entryID((int)n)] = this._number;
                n = this.nextEntry(n);
            }
        }

        public void listBlock() {
            byte[] byArray = new byte[255];
            int n = this.free();
            int n2 = this.firstEntry();
            if (this._isLeaf) {
                while (n2 < n) {
                    System.out.println(this.restoreKey(n2, byArray) + " " + this.entryID(n2));
                    n2 = this.nextEntry(n2);
                }
            } else {
                System.out.println("not leaf");
            }
        }

        protected void doMap(BtreeDict btreeDict, EntryProcessor entryProcessor) throws Exception {
            byte[] byArray = new byte[255];
            int n = this.free();
            int n2 = this.firstEntry();
            if (this._isLeaf) {
                while (n2 < n) {
                    entryProcessor.processEntry(this.restoreKey(n2, byArray), this.entryID(n2));
                    n2 = this.nextEntry(n2);
                }
            } else {
                btreeDict.lock(this);
                int n3 = 0;
                while (n2 < n) {
                    btreeDict.accessBlock(this.getChildIdx(n3)).doMap(btreeDict, entryProcessor);
                    entryProcessor.processEntry(this.restoreKey(n2, byArray), this.entryID(n2));
                    n2 = this.nextEntry(n2);
                    ++n3;
                }
                btreeDict.accessBlock(this.getChildIdx(n3)).doMap(btreeDict, entryProcessor);
                btreeDict.unlock(this);
            }
        }

        public void withPrefix(BtreeDict btreeDict, String string, int n, IntegerArray integerArray) throws Exception {
            byte[] byArray = new byte[255];
            int n2 = this.free();
            int n3 = this.firstEntry();
            if (this._isLeaf) {
                while (n3 < n2) {
                    if (this.restoreKey(n3, byArray).startsWith(string)) {
                        integerArray.add(this.entryID(n3));
                    }
                    n3 = this.nextEntry(n3);
                }
            } else {
                btreeDict.lock(this);
                int n4 = 0;
                while (n3 < n2) {
                    int n5;
                    String string2 = this.restoreKey(n3, byArray);
                    if (string2.length() > n) {
                        string2 = string2.substring(0, n);
                    }
                    if ((n5 = string2.compareTo(string)) < 0) {
                        n3 = this.nextEntry(n3);
                        ++n4;
                        continue;
                    }
                    if (n5 == 0) {
                        integerArray.add(this.entryID(n3));
                        btreeDict.accessBlock(this.getChildIdx(n4)).withPrefix(btreeDict, string, n, integerArray);
                        n3 = this.nextEntry(n3);
                        ++n4;
                        continue;
                    }
                    btreeDict.unlock(this);
                    btreeDict.accessBlock(this.getChildIdx(n4)).withPrefix(btreeDict, string, n, integerArray);
                    return;
                }
                btreeDict.unlock(this);
                btreeDict.accessBlock(this.getChildIdx(this.numberOfEntries())).withPrefix(btreeDict, string, n, integerArray);
            }
        }
    }
}

