/*************************************************************************
 *
 *  $RCSfile: dlgctrl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/06/14 16:07:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_DLG_CTRL_HXX
#define _SVX_DLG_CTRL_HXX

// include ---------------------------------------------------------------

#ifndef _CTRLBOX_HXX //autogen
#include <svtools/ctrlbox.hxx>
#endif
#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _SVX_RECTENUM_HXX //autogen
#include <svx/rectenum.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _XTABLE_HXX
class XBitmapEntry;
class XBitmapList;
class XColorEntry;
class XColorTable;
class XDash;
class XDashEntry;
class XDashList;
class XGradient;
class XGradientEntry;
class XGradientList;
class XHatch;
class XHatchEntry;
class XHatchList;
class XLineEndEntry;
class XLineEndList;
class XFillAttrSetItem;
#endif

class XOBitmap;
class XOutputDevice;
class XOutdevItemPool;

/*************************************************************************
|*
|* Von SfxTabPage abgeleitet, um vom Control ueber virtuelle Methode
|* benachrichtigt werden zu koennen.
|*
\************************************************************************/
class SvxTabPage : public SfxTabPage
{

public:
	SvxTabPage( Window* pParent, ResId Id, const SfxItemSet& rInAttrs  ) :
		SfxTabPage( pParent, Id, rInAttrs ) {}

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP ) = 0;
};

/*************************************************************************
|*
|*	Control zur Darstellung und Auswahl der Eckpunkte (und Mittelpunkt)
|*	eines Objekts
|*
\************************************************************************/
typedef UINT16 CTL_STATE;
#define CS_NOHORZ	1		// no horizontal input information is used
#define CS_NOVERT	2		// no vertikal input information is used

class SvxRectCtl : public Control
{
private:
	void				InitSettings( BOOL bForeground, BOOL bBackground );

protected:
	USHORT		nBorderWidth;
	USHORT		nRadius;
	Size		aSize;
	Point		aPtLT, aPtMT, aPtRT;
	Point		aPtLM, aPtMM, aPtRM;
	Point		aPtLB, aPtMB, aPtRB;
	Point		aPtNew;
	RECT_POINT	eRP, eDefRP;
	CTL_STYLE	eCS;
	Bitmap*		pBitmap;
	CTL_STATE	m_nState;

	RECT_POINT			GetRPFromPoint( Point ) const;
	Point				GetPointFromRP( RECT_POINT ) const;

public:
	SvxRectCtl( Window* pParent, const ResId& rResId, RECT_POINT eRpt = RP_MM,
				USHORT nBorder = 200, USHORT nCircle = 80, CTL_STYLE eStyle = CS_RECT );
	virtual ~SvxRectCtl();

	virtual void 		Paint( const Rectangle& rRect );
	virtual void 		MouseButtonDown( const MouseEvent& rMEvt );
    virtual void        KeyInput( const KeyEvent& rKeyEvt );
	virtual void		StateChanged( StateChangedType nStateChange );
	virtual void		DataChanged( const DataChangedEvent& rDCEvt );

	void				Reset();
	RECT_POINT			GetActualRP() const;
	void				SetActualRP( RECT_POINT eNewRP );

	void				SetState( CTL_STATE nState );
};

/*************************************************************************
|*
|*	Control zur Darstellung und Auswahl des Winkels der Eckpunkte
|*	eines Objekts
|*
\************************************************************************/
class SvxAngleCtl : public SvxRectCtl
{
private:
	void	Initialize();

protected:
	Font	aFont;
	Size	aFontSize;
	BOOL	bPositive;

public:
			SvxAngleCtl( Window* pParent, const ResId& rResId );
			SvxAngleCtl( Window* pParent, const ResId& rResId, Size aSize );

	void	ChangeMetric()
				{ bPositive = !bPositive; }
	virtual void Paint( const Rectangle& rRect );
};

/*************************************************************************
|*
|*	Preview-Control zur Darstellung von Bitmaps
|*
\************************************************************************/

class SvxBitmapCtl
{
protected:
	Size			aSize;
	USHORT			nLines;
	Color			aPixelColor, aBackgroundColor;
	const USHORT*	pBmpArray;

public:
			SvxBitmapCtl( Window* pParent, const Size& rSize );
			~SvxBitmapCtl();

	XOBitmap	GetXBitmap();

	void	SetBmpArray( const USHORT* pPixel ) { pBmpArray = pPixel; }
	void	SetLines( USHORT nLns ) { nLines = nLns; }
	void	SetPixelColor( Color aColor ) { aPixelColor = aColor; }
	void	SetBackgroundColor( Color aColor ) { aBackgroundColor = aColor; }
};

/*************************************************************************
|*
|*	Control zum Editieren von Bitmaps
|*
\************************************************************************/
class SvxPixelCtl : public Control
{
protected:
	USHORT		nLines, nSquares;
	Color		aPixelColor;
	Color		aBackgroundColor;
	Color		aLineColor;
	Size		aRectSize;
	USHORT* 	pPixel;
	BOOL		bPaintable;

	void	ChangePixel( USHORT nPixel );

public:
			SvxPixelCtl( Window* pParent, const ResId& rResId,
						USHORT nNumber = 8 );
			~SvxPixelCtl();

	virtual void Paint( const Rectangle& rRect );
	virtual void MouseButtonDown( const MouseEvent& rMEvt );

	void	SetXBitmap( const XOBitmap& rXOBitmap );

	void	SetPixelColor( const Color& rCol ) { aPixelColor = rCol; }
	void	SetBackgroundColor( const Color& rCol ) { aBackgroundColor = rCol; }
	void	SetLineColor( const Color& rCol ) { aLineColor = rCol; }

	USHORT	GetLineCount() const { return nLines; }
	Color	GetPixelColor() const { return aPixelColor; }
	Color	GetBackgroundColor() const { return aBackgroundColor; }

	USHORT	GetPixel( const USHORT nPixelNumber );
	USHORT* GetPixelPtr() { return pPixel; }

	void	SetPaintable( BOOL bTmp ) { bPaintable = bTmp; }
	void	Reset();
};

/*************************************************************************
|*
|* ColorLB kann mit Farben und Namen gefuellt werden
|*
\************************************************************************/
class ColorLB : public ColorListBox
{

public:
		 ColorLB( Window* pParent, ResId Id ) : ColorListBox( pParent, Id ) {}
		 ColorLB( Window* pParent, WinBits aWB ) : ColorListBox( pParent, aWB ) {}

	virtual void Fill( const XColorTable* pTab );

	void Append( XColorEntry* pEntry, Bitmap* pBmp = NULL );
	void Modify( XColorEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
};

/*************************************************************************
|*
|* HatchingLB
|*
\************************************************************************/
class HatchingLB : public ListBox
{

public:
		 HatchingLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );
		 HatchingLB( Window* pParent, WinBits aWB, BOOL bUserDraw = TRUE );

	virtual void Fill( const XHatchList* pList );
	virtual void UserDraw( const UserDrawEvent& rUDEvt );

	void	Append( XHatchEntry* pEntry, Bitmap* pBmp = NULL );
	void	Modify( XHatchEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
	void	SelectEntryByList( const XHatchList* pList, const String& rStr,
						const XHatch& rXHatch, USHORT nDist = 0 );

private:
	XHatchList*		mpList;
	BOOL			mbUserDraw;
};

/*************************************************************************
|*
|* GradientLB
|*
\************************************************************************/
class GradientLB : public ListBox
{
public:
	GradientLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );
	GradientLB( Window* pParent, WinBits aWB, BOOL bUserDraw = TRUE );

	virtual void Fill( const XGradientList* pList );
	virtual void UserDraw( const UserDrawEvent& rUDEvt );

	void	Append( XGradientEntry* pEntry, Bitmap* pBmp = NULL );
	void	Modify( XGradientEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
	void	SelectEntryByList( const XGradientList* pList, const String& rStr,
						const XGradient& rXGradient, USHORT nDist = 0 );

private:
	XGradientList* mpList;
	BOOL			mbUserDraw;
};

/*************************************************************************
|*
|* BitmapLB
|*
\************************************************************************/
class BitmapLB : public ListBox
{
public:
		 BitmapLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );

	virtual void Fill( const XBitmapList* pList );
	virtual void UserDraw( const UserDrawEvent& rUDEvt );

	void	Append( XBitmapEntry* pEntry, Bitmap* pBmp = NULL );
	void	Modify( XBitmapEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
	void	SelectEntryByList( const XBitmapList* pList, const String& rStr,
						const Bitmap& rBmp);

private:
	VirtualDevice	aVD;
	Bitmap			aBitmap;

	XBitmapList*	mpList;
	BOOL			mbUserDraw;

	void SetVirtualDevice();
};

/*************************************************************************
|*
|* FillAttrLB vereint alle Fuellattribute in einer ListBox
|*
\************************************************************************/
class FillAttrLB : public ColorListBox
{
private:
	VirtualDevice	aVD;
	Bitmap			aBitmap;

	void SetVirtualDevice();

public:
		 FillAttrLB( Window* pParent, ResId Id );
		 FillAttrLB( Window* pParent, WinBits aWB );

	virtual void Fill( const XColorTable* pTab );
	virtual void Fill( const XHatchList* pList );
	virtual void Fill( const XGradientList* pList );
	virtual void Fill( const XBitmapList* pList );

	void	SelectEntryByList( const XBitmapList* pList, const String& rStr,
						const Bitmap& rBmp);
};

/*************************************************************************
|*
|* FillTypeLB
|*
\************************************************************************/
class FillTypeLB : public ListBox
{

public:
		 FillTypeLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
		 FillTypeLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}

	virtual void Fill();
};

/*************************************************************************
|*
|* LineLB
|*
\************************************************************************/
class LineLB : public ListBox
{

public:
		 LineLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
		 LineLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}

	virtual void Fill( const XDashList* pList );

	void Append( XDashEntry* pEntry, Bitmap* pBmp = NULL );
	void Modify( XDashEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
	void SelectEntryByList( const XDashList* pList, const String& rStr,
							const XDash& rDash, USHORT nDist = 0 );
};

/*************************************************************************
|*
|* LineEndsLB
|*
\************************************************************************/
class LineEndLB : public ListBox
{

public:
		 LineEndLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
		 LineEndLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}

	virtual void Fill( const XLineEndList* pList, BOOL bStart = TRUE );

	void	Append( XLineEndEntry* pEntry, Bitmap* pBmp = NULL,
					BOOL bStart = TRUE );
	void	Modify( XLineEndEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL,
					BOOL bStart = TRUE );
};

/*************************************************************************
|*
|* SvxLinePreview
|*
\************************************************************************/
class SvxXLinePreview : public Control
{
private:
	Point			aPtA, aPtB;
	XOutputDevice*	pXOutDev;

	//#58425# Symbole auf einer Linie (z.B. StarChart)
	Graphic *pGraphic;
	BOOL bWithSymbol;
	Size aSymbolSize;

	void			InitSettings( BOOL bForeground, BOOL bBackground );

public:
	SvxXLinePreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut );

	void 			ShowSymbol( BOOL b ) { bWithSymbol = b; };
	void			SetSymbol( Graphic* p, const Size& s );
	void			ResizeSymbol( const Size& s );

	virtual void	Paint( const Rectangle& rRect );
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

/*************************************************************************
|*
|* SvxXRectPreview
|*
\************************************************************************/
class SvxXRectPreview : public Control
{
private:
	Rectangle		aRect;
	XOutputDevice*	pXOutDev;

	void			InitSettings( BOOL bForeground, BOOL bBackground );

public:
	SvxXRectPreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut );

	virtual void	Paint( const Rectangle& rRect );
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

/*************************************************************************
|*
|* SvxXShadowPreview
|*
\************************************************************************/
class SvxXShadowPreview : public Control
{
private:
	XOutputDevice*		pXOutDev;
	XOutdevItemPool*	pXPool;
	Rectangle			aRect;
	Rectangle			aShadow;
	XFillAttrSetItem*	pRectItem;
	XFillAttrSetItem*	pShadowItem;
	Point				aShadowPos;

	void				InitSettings( BOOL bForeground, BOOL bBackground );

public:
	SvxXShadowPreview( Window* pParent, const ResId& rResId,
					   XOutputDevice* pXOut, XOutdevItemPool* pXInPool );
	~SvxXShadowPreview();

	void			SetRect( const Rectangle& rRect ) { aRect = rRect; }
	void			SetRectAttr( XFillAttrSetItem* pSetItem );
	void			SetShadow( const Rectangle& rShadow ) { aShadow = rShadow; }
	void			SetShadowAttr( XFillAttrSetItem* pSetItem );
	void			SetShadowPos( Point aPos ) { aShadowPos = aPos; }

	virtual void	Paint( const Rectangle& rRect );
	virtual void	StateChanged( StateChangedType nStateChange );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

#endif // _SVX_DLG_CTRL_HXX

