/*************************************************************************
 *
 *  $RCSfile: viewfrm.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: mba $ $Date: 2001/06/11 09:42:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXVIEWFRM_HXX
#define _SFXVIEWFRM_HXX

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <sfx2/module.hxx>
#endif
#include <sfx2/frame.hxx>
#include <sfx2/shell.hxx>

class SvBorder;
class SfxDispatcher;
class SfxObjectShell;
class SfxBindings;
class SfxProgress;
class SvData;
class SfxViewShell;
class SvPseudoObject;
class SfxCancelManager;
#ifdef ENABLE_INIMANAGER//MUSTINI
class SfxIniManager;
#endif
class SystemWindow;
class Fraction;
class Point;
class Size;
class SfxInPlaceFrame;
class SfxChildWindow;

namespace so3 {
class SvLinkSource;
};

#ifndef SFX_DECL_OBJECTSHELL_DEFINED
#define SFX_DECL_OBJECTSHELL_DEFINED
SV_DECL_REF(SfxObjectShell)
SV_DECL_LOCK(SfxObjectShell)
#endif

//========================================================================
class SfxImageManager;
class SfxViewFrame: public SfxShell, public SfxListener
{
	struct SfxViewFrame_Impl*	pImp;

	SfxObjectShellRef			xObjSh;
	SfxDispatcher*				pDispatcher;
	SfxBindings*				pBindings;
	USHORT						nAdjustPosPixelLock;

private:
#ifndef _SFX_HXX
	void					Construct_Impl( SfxObjectShell *pObjSh=NULL );
#endif

protected:
	virtual void            SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );

	void					SetWindow_Impl( Window *pWin );

#ifndef _SFX_HXX
	BOOL					SwitchToViewShell_Impl( USHORT nNo, BOOL bIsIndex = FALSE );
	void                    KillDispatcher_Impl();
#endif

	virtual                 ~SfxViewFrame();

public:
							TYPEINFO();
							SFX_DECL_INTERFACE(SFX_INTERFACE_SFXVIEWFRM);

							SfxViewFrame( SfxBindings&, SfxFrame*, SfxObjectShell *pDoc=0, ULONG nType = 0 );
							SfxViewFrame(SfxObjectShell&, SfxBindings&, SfxFrame*p=0, ULONG nType = 0);
							SfxViewFrame(
								const SfxViewFrame &, SfxBindings &, SfxFrame *pFrame);

	static SfxViewFrame*	SearchViewFrame( SfxViewFrame*, const String& );

	static SfxViewFrame*    Current();
	static SfxViewFrame*	GetFirst( const SfxObjectShell* pDoc = 0,
								   TypeId aType = 0,
								   BOOL bOnlyVisible = TRUE );
	static SfxViewFrame*    GetNext( const SfxViewFrame& rPrev,
									const SfxObjectShell* pDoc = 0,
									TypeId aType = 0 ,
									BOOL bOnlyVisible = TRUE );
	static USHORT           Count(TypeId = 0);

			void            DoActivate(BOOL bMDI, SfxViewFrame *pOld=NULL);
			void            DoDeactivate(BOOL bMDI, SfxViewFrame *pOld=NULL);

	SfxViewFrame*			GetParentViewFrame() const;

	SfxDispatcher*          GetDispatcher() { return pDispatcher; }
	SfxBindings&            GetBindings() { return *pBindings; }
	const SfxBindings&      GetBindings() const  { return *pBindings; }
	Window&         		GetWindow() const;
	virtual void            SetZoomFactor( const Fraction &rZoomX,
										   const Fraction &rZoomY ) = 0;

	SfxProgress*            GetProgress() const;
#ifdef ENABLE_INIMANAGER//MUSTINI
	SfxIniManager*          GetIniManager() const;
#endif

#if SUPD<604
    SfxViewShell*           GetViewShell() const;
#endif
	SfxObjectShell* 		GetObjectShell() const
							{ return xObjSh; }

	void					DoAdjustPosSize( SfxViewShell *pSh,
										const Point rPos, const Size &rSize );
	void                    LockAdjustPosSizePixel()
							{ nAdjustPosPixelLock++; }
	void                    UnlockAdjustPosSizePixel()
							{ nAdjustPosPixelLock--; }
	void                    DoAdjustPosSizePixel( SfxViewShell * pSh,
										const Point &rPos, const Size &rSize );
	void					Hide();
	void					Show();
	BOOL					IsVisible() const;
	void					ToTop();
	void					Enable( BOOL bEnable );
	virtual BOOL            Close();

	// DDE-Interface
	virtual long			DdeExecute( const String& rCmd );
	virtual long			DdeGetData( const String& rItem,
										const String& rMimeType,
										::com::sun::star::uno::Any & rValue );
	virtual long			DdeSetData( const String& rItem,
										const String& rMimeType,
								const ::com::sun::star::uno::Any & rValue );
	virtual ::so3::SvLinkSource* DdeCreateLinkSource( const String& rItem );

	virtual void            ShowStatusText( const String& rText );
	virtual void            HideStatusText();

	virtual String			UpdateTitle();

	// interne Handler
	virtual BOOL            SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder );
	virtual const SvBorder& GetBorderPixelImpl( const SfxViewShell *pSh ) const;
	virtual void			InvalidateBorderImpl( const SfxViewShell *pSh );

	virtual SfxObjectShell*	GetObjectShell();
	USHORT					GetCurViewId() const;
	SfxFrame*				GetFrame() const;
	SfxViewFrame*			GetTopViewFrame() const;

	BOOL					DoClose();
	ULONG					GetFrameType() const
							{ return GetFrame()->GetFrameType(); }
	SfxFrame*				GetTopFrame() const
							{ return GetFrame()->GetTopFrame(); }
	SfxFrame*				SearchFrame( const String& rName, SfxMedium* pMedium = 0)
							{ return GetFrame()->SearchFrame( rName, pMedium ); }
	void					GetTargetList( TargetList& rList ) const
							{ GetFrame()->GetTargetList( rList ); }
	void                	CancelTransfers()
							{ GetFrame()->CancelTransfers(); }
	SfxCancelManager*		GetCancelManager() const;

	void					SetModalMode( BOOL );
    BOOL                    IsInModalMode() const;
    void                    Resize();

    void                        SetChildWindow(USHORT, BOOL);
    void                        ToggleChildWindow(USHORT);
    BOOL                        HasChildWindow(USHORT);
    BOOL                        KnowsChildWindow(USHORT);
    void                        ShowChildWindow(USHORT,BOOL bVisible=TRUE);
    SfxChildWindow*             GetChildWindow(USHORT);
    void                        ChildWindowExecute(SfxRequest&);
    void                        ChildWindowState(SfxItemSet&);

    SfxImageManager*        GetImageManager();

#if 0 // _SOLAR__PRIVATE
	void 					SetIPFrame_Impl( SfxInPlaceFrame* );
	SfxInPlaceFrame*		GetIPFrame_Impl() const;
	void					SetFrame_Impl( SfxFrame* );
	void                    SetDowning_Impl();
	void                    GetDocNumber_Impl();
	BOOL                    IsDowning_Impl() const;
	void                    SetSetViewFrameAllowed_Impl( BOOL bSet );
	BOOL                    IsSetViewFrameAllowed_Impl() const;
	void                    SetImportingObjectShell_Impl( SfxObjectShell* pSH );
	SfxObjectShell*         GetImportingObjectShell_Impl( ) const;
	void                    SetViewShell_Impl( SfxViewShell *pVSh );
	void					SetObjectShell_Impl( SfxObjectShell& rObjSh ,
												 FASTBOOL bDefaultView = FALSE );
	void                    ReleaseObjectShell_Impl( BOOL bStoreView = FALSE );

	void                    GetState_Impl( SfxItemSet &rSet );
	void                    ExecReload_Impl( SfxRequest &rReq );
	void                    ExecReload_Impl( SfxRequest &rReq, BOOL bAsync );
	void                    StateReload_Impl( SfxItemSet &rSet );
	void                    ExecView_Impl( SfxRequest &rReq );
	void                    StateView_Impl( SfxItemSet &rSet );
	void                    PropState_Impl( SfxItemSet &rSet );
	void                    ExecHistory_Impl( SfxRequest &rReq );
	void                    StateHistory_Impl( SfxItemSet &rSet );
	void					SetParentViewFrame_Impl(SfxViewFrame *pParentFrame);
	SfxViewFrame*			GetParentViewFrame_Impl() const;
	void					ForceOuterResize_Impl(BOOL bOn=TRUE);
	BOOL					IsResizeInToOut_Impl() const;
	BOOL					IsAdjustPosSizePixelLocked_Impl() const
							{ return nAdjustPosPixelLock != 0; }

	void					LockObjectShell_Impl(BOOL bLock=TRUE);

	SfxViewShell*			CreateView_Impl( USHORT nViewId );
    void                    MakeActive_Impl( BOOL bActivate );
	void					SetQuietMode_Impl( BOOL );
	const Size&				GetMargin_Impl() const;
	void					SetMargin_Impl( const Size& );
	void					SetActiveChildFrame_Impl( SfxViewFrame* );
	SfxViewFrame*			GetActiveChildFrame_Impl() const;
	BOOL					IsRestoreView_Impl() const;
	void					SetRestoreView_Impl( BOOL );
	void 					SetViewData_Impl( USHORT, const String& );
	String&					GetViewData_Impl();
	String					GetHelpFile_Impl();
	String					GetActualPresentationURL_Impl() const;
	static void				CloseHiddenFrames_Impl();
    void                        ToolboxExec_Impl(SfxRequest &);
    void                        ToolboxState_Impl(SfxItemSet &);
    void                        MiscExec_Impl(SfxRequest &);
    void                        MiscState_Impl(SfxItemSet &);
    SfxWorkWindow*          GetWorkWindow_Impl( USHORT nId );
#endif
};

//--------------------------------------------------------------------

class SfxViewFrameItem: public SfxPoolItem
{
	SfxViewFrame*			pFrame;

public:
							TYPEINFO();
							SfxViewFrameItem( SfxViewFrame *pViewFrame ):
								SfxPoolItem( 0 ),
								pFrame( pViewFrame)
							{}
							SfxViewFrameItem( USHORT nWhich, SfxViewFrame *pViewFrame ):
								SfxPoolItem( nWhich ),
								pFrame( pViewFrame)
							{}

	virtual int 			operator==( const SfxPoolItem& ) const;
	virtual String			GetValueText() const;
	virtual SfxPoolItem*	Clone( SfxItemPool *pPool = 0 ) const;

	SfxViewFrame*			GetFrame() const
							{ return pFrame; }
};

#endif

