/*************************************************************************
 *
 *  $RCSfile: ldapber.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LDAPBER_LDAPBER_H
#define _LDAPBER_LDAPBER_H "$Revision: 1.1.1.1 $"

#ifndef _LDAPBER_LDAPASN_H
#include <ldapber/ldapasn.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*========================================================================
 *
 * LDAP Basic (ASN.1) data structures.
 *
 *======================================================================*/
/*
 * LDAP_STRING.
 */
#define LDAP_STRING ASN1_OCTET_STRING

#define LDAP_STRING_new() (LDAP_STRING *)ASN1_OCTET_STRING_new()
#define LDAP_STRING_free(a) ASN1_OCTET_STRING_free ((ASN1_OCTET_STRING *)(a))

#define i2d_LDAP_STRING(a,pp) \
    i2d_ASN1_OCTET_STRING ((a), (pp))
#define d2i_LDAP_STRING(a,pp,l) \
    (LDAP_STRING *)d2i_ASN1_OCTET_STRING ((a), (pp), (l))

#define tag_LDAP_STRING (tag_ASN1_OCTET_STRING)


/*
 * LDAP_DN.
 */
#define LDAP_DN  LDAP_STRING

#define LDAP_DN_new() (LDAP_DN *)LDAP_STRING_new()
#define LDAP_DN_free(a) LDAP_STRING_free ((LDAP_STRING *)(a))

#define i2d_LDAP_DN(a,pp) \
    i2d_LDAP_STRING ((a), (pp))
#define d2i_LDAP_DN(a,pp,l) \
    (LDAP_DN *)d2i_LDAP_STRING ((a), (pp), (l))

#define tag_LDAP_DN (tag_LDAP_STRING)


/*
 * LDAP_ATTRIBUTE_TYPE.
 */
#define LDAP_ATTRIBUTE_TYPE LDAP_STRING

#define LDAP_ATTRIBUTE_TYPE_new() (LDAP_ATTRIBUTE_TYPE *)LDAP_STRING_new()
#define LDAP_ATTRIBUTE_TYPE_free(a) LDAP_STRING_free((LDAP_STRING *)(a))

#define i2d_LDAP_ATTRIBUTE_TYPE(a,pp) \
    i2d_LDAP_STRING ((a), (pp))
#define d2i_LDAP_ATTRIBUTE_TYPE(a,pp,l) \
    (LDAP_ATTRIBUTE_TYPE *)d2i_LDAP_STRING ((a), (pp), (l))

#define tag_LDAP_ATTRIBUTE_TYPE (tag_LDAP_STRING)


/*
 * LDAP_ATTRIBUTE_VALUE.
 */
#define LDAP_ATTRIBUTE_VALUE ASN1_OCTET_STRING

#define LDAP_ATTRIBUTE_VALUE_new() \
    (LDAP_ATTRIBUTE_VALUE *)ASN1_OCTET_STRING_new()
#define LDAP_ATTRIBUTE_VALUE_free(a) \
    ASN1_OCTET_STRING_free ((ASN1_OCTET_STRING *)(a))

#define i2d_LDAP_ATTRIBUTE_VALUE(a,pp) \
    i2d_ASN1_OCTET_STRING ((a), (pp))
#define d2i_LDAP_ATTRIBUTE_VALUE(a,pp,l) \
    (LDAP_ATTRIBUTE_VALUE *)d2i_ASN1_OCTET_STRING ((a), (pp), (l))

#define tag_LDAP_ATTRIBUTE_VALUE (tag_ASN1_OCTET_STRING)


/*========================================================================
 *
 * LDAP Compound (ASN.1) data structures.
 *
 *======================================================================*/
/*
 * LDAP_ATTRIBUTE_VALUE_PAIR.
 */
typedef struct ldap_attribute_value_pair_st {
	LDAP_ATTRIBUTE_TYPE  *attributeType;
	LDAP_ATTRIBUTE_VALUE *attributeValue;
} LDAP_ATTRIBUTE_VALUE_PAIR;

LDAP_ATTRIBUTE_VALUE_PAIR* LDAP_ATTRIBUTE_VALUE_PAIR_new (void);
void LDAP_ATTRIBUTE_VALUE_PAIR_free (LDAP_ATTRIBUTE_VALUE_PAIR *a);

int i2d_LDAP_ATTRIBUTE_VALUE_PAIR (
	LDAP_ATTRIBUTE_VALUE_PAIR *a, BYTE **pp);
LDAP_ATTRIBUTE_VALUE_PAIR* d2i_LDAP_ATTRIBUTE_VALUE_PAIR (
	LDAP_ATTRIBUTE_VALUE_PAIR **a, BYTE **pp, long length);

#define tag_LDAP_ATTRIBUTE_VALUE_PAIR (tag_ASN1_SEQUENCE)

#define LDAP_ATTRIBUTE_VALUE_PAIR_dup(a) \
    (LDAP_ATTRIBUTE_VALUE_PAIR *)ASN1_dup ( \
        (ASN1_i2d_t *)i2d_LDAP_ATTRIBUTE_VALUE_PAIR, \
        (ASN1_d2i_t *)d2i_LDAP_ATTRIBUTE_VALUE_PAIR, (a))


/*
 * LDAP_ATTRIBUTES.
 */
typedef struct ldap_attributes_st {
	LDAP_ATTRIBUTE_TYPE *type;
	ASN1_SET            *values; /* SET OF LDAP_ATTRIBUTE_VALUE */
} LDAP_ATTRIBUTES;

LDAP_ATTRIBUTES* LDAP_ATTRIBUTES_new (void);
void LDAP_ATTRIBUTES_free (LDAP_ATTRIBUTES *a);

int i2d_LDAP_ATTRIBUTES (
	LDAP_ATTRIBUTES *a, BYTE **pp);
LDAP_ATTRIBUTES* d2i_LDAP_ATTRIBUTES (
	LDAP_ATTRIBUTES **a, BYTE **pp, long length);

#define tag_LDAP_ATTRIBUTES (tag_ASN1_SEQUENCE)

#define LDAP_ATTRIBUTES_dup(a) (LDAP_ATTRIBUTES *)ASN1_dup ( \
    (ASN1_i2d_t *)i2d_LDAP_ATTRIBUTES, (ASN1_d2i_t *)d2i_LDAP_ATTRIBUTES, (a))

#define LDAP_ATTRIBUTES_count(a) ASN1_SET_count((a)->values)
#define LDAP_ATTRIBUTES_value(a,i) \
    (LDAP_ATTRIBUTE_VALUE *)ASN1_SET_value((a)->values, (i))


/*
 * LDAP_ENTRY.
 */
typedef struct ldap_entry_st {
	LDAP_DN       *objectName;
	ASN1_SEQUENCE *attributes; /* SEQUENCE OF LDAP_ATTRIBUTES */
} LDAP_ENTRY;

LDAP_ENTRY* LDAP_ENTRY_new (void);
void LDAP_ENTRY_free (LDAP_ENTRY *a);

int i2d_LDAP_ENTRY (
	LDAP_ENTRY *a, BYTE **pp);
LDAP_ENTRY* d2i_LDAP_ENTRY (
	LDAP_ENTRY **a, BYTE **pp, long length);

#define tag_LDAP_ENTRY (tag_ASN1_SEQUENCE)

#define LDAP_ENTRY_dup(a) (LDAP_ENTRY *)ASN1_dup( \
	(ASN1_i2d_t *)i2d_LDAP_ENTRY, (ASN1_d2i_t *)d2i_LDAP_ENTRY, (a))

#define LDAP_ENTRY_count(a) ASN1_SEQUENCE_count((a)->attributes)
#define LDAP_ENTRY_value(a,i) \
    (LDAP_ATTRIBUTES *)ASN1_SEQUENCE_value((a)->attributes, (i))


/*
 * LDAP_SUBSTRING.
 */
#define LDAP_SUBSTRING_TYPE_INITIAL 0
#define LDAP_SUBSTRING_TYPE_ANY     1
#define LDAP_SUBSTRING_TYPE_FINAL   2

typedef struct ldap_substring_st {
	int substringType;
	union {
		BYTE        *ptr;
		LDAP_STRING *initial; /* [0] */
		LDAP_STRING *any;     /* [1] */
		LDAP_STRING *final;   /* [2] */
	} substring;
} LDAP_SUBSTRING;

LDAP_SUBSTRING* LDAP_SUBSTRING_new (void);
LDAP_SUBSTRING* LDAP_SUBSTRING_type_new (int substringType);
void LDAP_SUBSTRING_free (LDAP_SUBSTRING *a);

int i2d_LDAP_SUBSTRING (
	LDAP_SUBSTRING *a, BYTE **pp);
LDAP_SUBSTRING* d2i_LDAP_SUBSTRING (
	LDAP_SUBSTRING **a, BYTE **pp, long length);

#define LDAP_SUBSTRING_dup(a) (LDAP_SUBSTRING *)ASN1_dup( \
	(ASN1_i2d_t *)i2d_LDAP_SUBSTRING, (ASN1_d2i_t *)d2i_LDAP_SUBSTRING, (a))
	

/*
 * LDAP_SUBSTRING_FILTER.
 */
typedef struct ldap_substring_filter_st {
	LDAP_ATTRIBUTE_TYPE *type;
	ASN1_SEQUENCE       *substrings; /* SEQUENCE OF LDAP_SUBSTRING */
} LDAP_SUBSTRING_FILTER;

LDAP_SUBSTRING_FILTER* LDAP_SUBSTRING_FILTER_new (void);
void LDAP_SUBSTRING_FILTER_free (LDAP_SUBSTRING_FILTER *a);

int i2d_LDAP_SUBSTRING_FILTER (
	LDAP_SUBSTRING_FILTER *a, BYTE **pp);
LDAP_SUBSTRING_FILTER *d2i_LDAP_SUBSTRING_FILTER (
	LDAP_SUBSTRING_FILTER **a, BYTE **pp, long length);

#define tag_LDAP_SUBSTRING_FILTER (tag_ASN1_SEQUENCE)

#define LDAP_SUBSTRING_FILTER_dup(a) \
    (LDAP_SUBSTRING_FILTER *)ASN1_dup( \
		(ASN1_i2d_t *)i2d_LDAP_SUBSTRING_FILTER, \
		(ASN1_d2i_t *)d2i_LDAP_SUBSTRING_FILTER, (a))
	

/*
 * LDAP_FILTER.
 */
#define LDAP_FILTER_TYPE_AND               0
#define LDAP_FILTER_TYPE_OR                1
#define LDAP_FILTER_TYPE_NOT               2
#define LDAP_FILTER_TYPE_EQUALITY_MATCH    3
#define LDAP_FILTER_TYPE_SUBSTRINGS        4
#define LDAP_FILTER_TYPE_GREATER_OR_EQUAL  5
#define LDAP_FILTER_TYPE_LESS_OR_EQUAL     6
#define LDAP_FILTER_TYPE_PRESENT           7
#define LDAP_FILTER_TYPE_APPROX_MATCH      8

typedef struct ldap_filter_st
{
	int m_filterType;
	union
	{
		BYTE                      *m_ptr;
		ASN1_SET                  *m_and;            /* [0] SET OF ... */
		ASN1_SET                  *m_or;             /* [1] SET OF ... */
		struct ldap_filter_st     *m_not;            /* [2] LDAP_FILTER */
		LDAP_ATTRIBUTE_VALUE_PAIR *m_equalityMatch;  /* [3] */
		LDAP_SUBSTRING_FILTER     *m_substrings;     /* [4] */
		LDAP_ATTRIBUTE_VALUE_PAIR *m_greaterOrEqual; /* [5] */
		LDAP_ATTRIBUTE_VALUE_PAIR *m_lessOrEqual;    /* [6] */
		LDAP_ATTRIBUTE_TYPE       *m_present;        /* [7] */
		LDAP_ATTRIBUTE_VALUE_PAIR *m_approxMatch;    /* [8] */
	} m_filter;
} LDAP_FILTER;

LDAP_FILTER* LDAP_FILTER_new (void);
LDAP_FILTER* LDAP_FILTER_type_new (int filterType);
void LDAP_FILTER_free (LDAP_FILTER *a);

int i2d_LDAP_FILTER (
	LDAP_FILTER *a, BYTE **pp);
LDAP_FILTER* d2i_LDAP_FILTER (
	LDAP_FILTER **a, BYTE **pp, long length);

#define LDAP_FILTER_dup(a) (LDAP_FILTER *)ASN1_dup( \
	(ASN1_i2d_t *)i2d_LDAP_FILTER, (ASN1_d2i_t *)d2i_LDAP_FILTER, (a))


/*
 * LDAP_MODIFICATION.
 */
#define LDAP_MODIFICATION_OP_ADD     0
#define LDAP_MODIFICATION_OP_DELETE  1
#define LDAP_MODIFICATION_OP_REPLACE 2

typedef struct ldap_modification_st {
	ASN1_ENUMERATED *operation;
	LDAP_ATTRIBUTES *modification;
} LDAP_MODIFICATION;

LDAP_MODIFICATION* LDAP_MODIFICATION_new (void);
void LDAP_MODIFICATION_free (LDAP_MODIFICATION *a);

int i2d_LDAP_MODIFICATION (
	LDAP_MODIFICATION *a, BYTE **pp);
LDAP_MODIFICATION* d2i_LDAP_MODIFICATION (
	LDAP_MODIFICATION **a, BYTE **pp, long length);

#define tag_LDAP_MODIFICATION (tag_ASN1_SEQUENCE)

#define LDAP_MODIFICATION_dup(a) \
    (LDAP_MODIFICATION *)ASN1_dup( \
        (ASN1_i2d_t *)i2d_LDAP_MODIFICATION, \
        (ASN1_d2i_t *)d2i_LDAP_MODIFICATION, (a))

/*========================================================================
 *
 * LDAP Resquest/Response (ASN.1) data structures.
 *
 *======================================================================*/
/*
 * LDAP_RESULT.
 */
typedef struct ldap_result_st {
	ASN1_ENUMERATED *resultCode;
	LDAP_DN         *matchedDN;
	LDAP_STRING     *errorMessage;
} LDAP_RESULT;

LDAP_RESULT* LDAP_RESULT_new (void);
void LDAP_RESULT_free (LDAP_RESULT *a);

int i2d_LDAP_RESULT (
	LDAP_RESULT *a, BYTE **pp);
LDAP_RESULT* d2i_LDAP_RESULT (
	LDAP_RESULT **a, BYTE **pp, long length);

#define tag_LDAP_RESULT (tag_ASN1_SEQUENCE)

#define LDAP_RESULT_dup(a) (LDAP_RESULT *)ASN1_dup( \
    (ASN1_i2d_t *)i2d_LDAP_RESULT, (ASN1_d2i_t *)d2i_LDAP_RESULT, (a))


/*
 * LDAP_BIND_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_BIND_REQUEST  0

typedef struct ldap_bind_request_st {
	ASN1_INTEGER *version;
	LDAP_DN      *name;
	int          authType;
	union {
		ASN1_OCTET_STRING *simple;
		ASN1_OCTET_STRING *krbv42LDAP;
		ASN1_OCTET_STRING *krbv42DSA;
	} authentication;
} LDAP_BIND_REQUEST;

LDAP_BIND_REQUEST* LDAP_BIND_REQUEST_new (void);
void LDAP_BIND_REQUEST_free (LDAP_BIND_REQUEST *a);

int i2d_LDAP_BIND_REQUEST (
	LDAP_BIND_REQUEST *a, BYTE **pp);
LDAP_BIND_REQUEST* d2i_LDAP_BIND_REQUEST (
	LDAP_BIND_REQUEST **a, BYTE **pp, long length);

#define tag_LDAP_BIND_REQUEST (tag_ASN1_SEQUENCE)


/*
 * LDAP_BIND_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_BIND_RESPONSE  1

#define LDAP_BIND_RESPONSE LDAP_RESULT

#define LDAP_BIND_RESPONSE_new() (LDAP_BIND_RESPONSE *)LDAP_RESULT_new()
#define LDAP_BIND_RESPONSE_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_BIND_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_BIND_RESPONSE(a,pp,l) \
	(LDAP_BIND_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_BIND_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_UNBIND_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_UNBIND_REQUEST         2

#define LDAP_UNBIND_REQUEST ASN1_NULL

#define LDAP_UNBIND_REQUEST_new() (LDAP_UNBIND_REQUEST *)ASN1_NULL_new()
#define LDAP_UNBIND_REQUEST_free(a) ASN1_NULL_free((ASN1_NULL *)(a))

#define i2d_LDAP_UNBIND_REQUEST(a,pp) \
    i2d_ASN1_NULL((a), (pp))
#define d2i_LDAP_UNBIND_REQUEST(a,pp,l) \
    (LDAP_UNBIND_REQUEST *)d2i_ASN1_NULL((a), (pp), (l))

#define tag_LDAP_UNBIND_REQUEST (tag_ASN1_NULL)


/*
 * LDAP_SEARCH_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_SEARCH_REQUEST         3

typedef struct ldap_search_request_st {
	LDAP_DN         *baseObject;
	ASN1_ENUMERATED *scope;
	ASN1_ENUMERATED *derefAlias;
	ASN1_INTEGER    *sizeLimit;
	ASN1_INTEGER    *timeLimit;
	ASN1_BOOLEAN    *attrsOnly;
	LDAP_FILTER     *filter;
	ASN1_SEQUENCE   *attributes; /* SEQUENCE OF LDAP_ATTRIBUTE_TYPE */
} LDAP_SEARCH_REQUEST;

LDAP_SEARCH_REQUEST* LDAP_SEARCH_REQUEST_new (void);
void LDAP_SEARCH_REQUEST_free (LDAP_SEARCH_REQUEST *a);

int i2d_LDAP_SEARCH_REQUEST (
	LDAP_SEARCH_REQUEST *a, BYTE **pp);
LDAP_SEARCH_REQUEST* d2i_LDAP_SEARCH_REQUEST (
	LDAP_SEARCH_REQUEST **a, BYTE **pp, long length);

#define tag_LDAP_SEARCH_REQUEST (tag_ASN1_SEQUENCE)
	

/*
 * LDAP_SEARCH_ENTRY.
 */
#define LDAP_MESSAGE_TYPE_SEARCH_ENTRY  4

#define LDAP_SEARCH_ENTRY LDAP_ENTRY

#define LDAP_SEARCH_ENTRY_new() (LDAP_SEARCH_ENTRY *)LDAP_ENTRY_new ()
#define LDAP_SEARCH_ENTRY_free(a) LDAP_ENTRY_free((LDAP_ENTRY *)(a))

#define i2d_LDAP_SEARCH_ENTRY(a,pp) \
    i2d_LDAP_ENTRY ((a), (pp))
#define d2i_LDAP_SEARCH_ENTRY(a,pp,l) \
    (LDAP_SEARCH_ENTRY *)d2i_LDAP_ENTRY ((a), (pp), (l))

#define tag_LDAP_SEARCH_ENTRY (tag_LDAP_ENTRY)

#define LDAP_SEARCH_ENTRY_count(a)   LDAP_ENTRY_count((a))
#define LDAP_SEARCH_ENTRY_value(a,i) LDAP_ENTRY_value((a),(i))


/*
 * LDAP_SEARCH_RESULT.
 */
#define LDAP_MESSAGE_TYPE_SEARCH_RESULT 5

#define LDAP_SEARCH_RESULT LDAP_RESULT

#define LDAP_SEARCH_RESULT_new() (LDAP_SEARCH_RESULT *)LDAP_RESULT_new()
#define LDAP_SEARCH_RESULT_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_SEARCH_RESULT(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_SEARCH_RESULT(a,pp,l) \
	(LDAP_SEARCH_RESULT *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_SEARCH_RESULT (tag_LDAP_RESULT)


/*
 * LDAP_MODIFY_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_MODIFY_REQUEST         6

typedef struct ldap_modify_request_st {
	LDAP_DN       *object;
	ASN1_SEQUENCE *modifications; /* SEQUENCE OF LDAP_MODIFICATION */
} LDAP_MODIFY_REQUEST;

LDAP_MODIFY_REQUEST* LDAP_MODIFY_REQUEST_new (void);
void LDAP_MODIFY_REQUEST_free (LDAP_MODIFY_REQUEST *a);

int i2d_LDAP_MODIFY_REQUEST (
	LDAP_MODIFY_REQUEST *a, BYTE **pp);
LDAP_MODIFY_REQUEST* d2i_LDAP_MODIFY_REQUEST (
	LDAP_MODIFY_REQUEST **a, BYTE **pp, long length);

#define tag_LDAP_MODIFY_REQUEST (tag_ASN1_SEQUENCE)


/*
 * LDAP_MODIFY_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_MODIFY_RESPONSE        7

#define LDAP_MODIFY_RESPONSE LDAP_RESULT

#define LDAP_MODIFY_RESPONSE_new() (LDAP_MODIFY_RESPONSE *)LDAP_RESULT_new()
#define LDAP_MODIFY_RESPONSE_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_MODIFY_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_MODIFY_RESPONSE(a,pp,l) \
	(LDAP_MODIFY_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_MODIFY_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_ADD_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_ADD_REQUEST            8

#define LDAP_ADD_REQUEST LDAP_ENTRY

#define LDAP_ADD_REQUEST_new() (LDAP_ADD_REQUEST *)LDAP_ENTRY_new()
#define LDAP_ADD_REQUEST_free(a) LDAP_ENTRY_free ((LDAP_ENTRY *)(a))

#define i2d_LDAP_ADD_REQUEST(a,pp) \
	i2d_LDAP_ENTRY ((a), (pp))
#define d2i_LDAP_ADD_REQUEST(a,pp,l) \
	(LDAP_ADD_REQUEST *)d2i_LDAP_ENTRY ((a), (pp), (l))

#define tag_LDAP_ADD_REQUEST (tag_LDAP_ENTRY)


/*
 * LDAP_ADD_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_ADD_RESPONSE           9

#define LDAP_ADD_RESPONSE LDAP_RESULT

#define LDAP_ADD_RESPONSE_new() (LDAP_ADD_RESPONSE *)LDAP_RESULT_new()
#define LDAP_ADD_RESPONSE_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_ADD_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_ADD_RESPONSE(a,pp,l) \
	(LDAP_ADD_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_ADD_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_DELETE_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_DELETE_REQUEST         10

#define LDAP_DELETE_REQUEST LDAP_DN

#define LDAP_DELETE_REQUEST_new() (LDAP_DELETE_REQUEST *)LDAP_DN_new()
#define LDAP_DELETE_REQUEST_free(a) LDAP_DN_free ((LDAP_DN *)(a))

#define i2d_LDAP_DELETE_REQUEST(a,pp) \
    i2d_LDAP_DN ((a), (pp))
#define d2i_LDAP_DELETE_REQUEST(a,pp,l) \
	(LDAP_DELETE_REQUEST *)d2i_LDAP_DN ((a), (pp), (l))

#define tag_LDAP_DELETE_REQUEST (tag_LDAP_DN)


/*
 * LDAP_DELETE_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_DELETE_RESPONSE        11

#define LDAP_DELETE_RESPONSE LDAP_RESULT

#define LDAP_DELETE_RESPONSE_new() (LDAP_DELETE_RESPONSE *)LDAP_RESULT_new()
#define LDAP_DELETE_RESPONSE_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_DELETE_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_DELETE_RESPONSE(a,pp,l) \
	(LDAP_DELETE_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_DELETE_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_MODIFYRDN_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_MODIFYRDN_REQUEST      12

typedef struct ldap_modifyrdn_request_st {
	LDAP_DN      *entry;
	LDAP_DN      *newrdn;
	ASN1_BOOLEAN *deleteoldrdn;
} LDAP_MODIFYRDN_REQUEST;

LDAP_MODIFYRDN_REQUEST* LDAP_MODIFYRDN_REQUEST_new (void);
void LDAP_MODIFYRDN_REQUEST_free (LDAP_MODIFYRDN_REQUEST *a);

int i2d_LDAP_MODIFYRDN_REQUEST (
	LDAP_MODIFYRDN_REQUEST *a, BYTE **pp);
LDAP_MODIFYRDN_REQUEST* d2i_LDAP_MODIFYRDN_REQUEST (
	LDAP_MODIFYRDN_REQUEST **a, BYTE **pp, long length);

#define tag_LDAP_MODIFYRDN_REQUEST (tag_ASN1_SEQUENCE)


/*
 * LDAP_MODIFYRDN_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_MODIFYRDN_RESPONSE     13

#define LDAP_MODIFYRDN_RESPONSE LDAP_RESULT

#define LDAP_MODIFYRDN_RESPONSE_new() \
    (LDAP_MODIFYRDN_RESPONSE *)LDAP_RESULT_new()
#define LDAP_MODIFYRDN_RESPONSE_free(a) \
    LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_MODIFYRDN_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_MODIFYRDN_RESPONSE(a,pp,l) \
	(LDAP_MODIFYRDN_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_MODIFYRDN_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_COMPARE_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_COMPARE_REQUEST        14

typedef struct ldap_compare_request_st {
	LDAP_DN                   *entry;
	LDAP_ATTRIBUTE_VALUE_PAIR *ava;
} LDAP_COMPARE_REQUEST;

LDAP_COMPARE_REQUEST* LDAP_COMPARE_REQUEST_new (void);
void LDAP_COMPARE_REQUEST_free (LDAP_COMPARE_REQUEST *a);

int i2d_LDAP_COMPARE_REQUEST (
	LDAP_COMPARE_REQUEST *a, BYTE **pp);
LDAP_COMPARE_REQUEST* d2i_LDAP_COMPARE_REQUEST (
	LDAP_COMPARE_REQUEST **a, BYTE **pp, long length);

#define tag_LDAP_COMPARE_REQUEST (tag_ASN1_SEQUENCE)


/*
 * LDAP_COMPARE_RESPONSE.
 */
#define LDAP_MESSAGE_TYPE_COMPARE_RESPONSE       15

#define LDAP_COMPARE_RESPONSE LDAP_RESULT

#define LDAP_COMPARE_RESPONSE_new() (LDAP_COMPARE_RESPONSE *)LDAP_RESULT_new()
#define LDAP_COMPARE_RESPONSE_free(a) LDAP_RESULT_free ((LDAP_RESULT *)(a))

#define i2d_LDAP_COMPARE_RESPONSE(a,pp) \
    i2d_LDAP_RESULT ((a), (pp))
#define d2i_LDAP_COMPARE_RESPONSE(a,pp,l) \
	(LDAP_COMPARE_RESPONSE *)d2i_LDAP_RESULT ((a), (pp), (l))

#define tag_LDAP_COMPARE_RESPONSE (tag_LDAP_RESULT)


/*
 * LDAP_ABANDON_REQUEST.
 */
#define LDAP_MESSAGE_TYPE_ABANDON_REQUEST        16

#define LDAP_ABANDON_REQUEST ASN1_INTEGER

#define LDAP_ABANDON_REQUEST_new() (LDAP_ABANDON_REQUEST *)ASN1_INTEGER_new()
#define LDAP_ABANDON_REQUEST_free(a) ASN1_INTEGER_free ((ASN1_INTEGER *)(a))

#define i2d_LDAP_ABANDON_REQUEST(a,pp) \
    i2d_ASN1_INTEGER ((a), (pp))
#define d2i_LDAP_ABANDON_REQUEST(a,pp,l) \
	(LDAP_ABANDON_REQUEST *)d2i_ASN1_INTEGER ((a), (pp), (l))

#define tag_LDAP_ABANDON_REQUEST (tag_ASN1_INTEGER)


/*========================================================================
 *
 * LDAP Message (ASN.1) data structure.
 *
 *======================================================================*/
/*
 * LDAP_MESSAGE.
 */
typedef struct ldap_message_st {
	ASN1_INTEGER *messageID;
	int          messageType;
	union {
		BYTE                    *ptr;
		LDAP_BIND_REQUEST       *bindRequest;       /* [APPLICATION  0] */
		LDAP_BIND_RESPONSE      *bindResponse;      /* [APPLICATION  1] */
		LDAP_UNBIND_REQUEST     *unbindRequest;     /* [APPLICATION  2] */
		LDAP_SEARCH_REQUEST     *searchRequest;     /* [APPLICATION  3] */
		LDAP_SEARCH_ENTRY       *searchEntry;       /* [APPLICATION  4] */
		LDAP_SEARCH_RESULT      *searchResult;      /* [APPLICATION  5] */
		LDAP_MODIFY_REQUEST     *modifyRequest;     /* [APPLICATION  6] */
		LDAP_MODIFY_RESPONSE    *modifyResponse;    /* [APPLICATION  7] */
		LDAP_ADD_REQUEST        *addRequest;        /* [APPLICATION  8] */
		LDAP_ADD_RESPONSE       *addResponse;       /* [APPLICATION  9] */
		LDAP_DELETE_REQUEST     *deleteRequest;     /* [APPLICATION 10] */
		LDAP_DELETE_RESPONSE    *deleteResponse;    /* [APPLICATION 11] */
		LDAP_MODIFYRDN_REQUEST  *modifyRDNRequest;  /* [APPLICATION 12] */
		LDAP_MODIFYRDN_RESPONSE *modifyRDNResponse; /* [APPLICATION 13] */
		LDAP_COMPARE_REQUEST    *compareRequest;    /* [APPLICATION 14] */
		LDAP_COMPARE_RESPONSE   *compareResponse;   /* [APPLICATION 15] */
		LDAP_ABANDON_REQUEST    *abandonRequest;    /* [APPLICATION 16] */
	} protocolOp;
} LDAP_MESSAGE;

LDAP_MESSAGE* LDAP_MESSAGE_new (void);
LDAP_MESSAGE* LDAP_MESSAGE_type_new (int messageType);
void LDAP_MESSAGE_free (LDAP_MESSAGE *a);

int i2d_LDAP_MESSAGE (
	LDAP_MESSAGE *a, BYTE **pp);
LDAP_MESSAGE* d2i_LDAP_MESSAGE (
	LDAP_MESSAGE **a, BYTE **pp, long length);

#define tag_LDAP_MESSAGE (tag_ASN1_SEQUENCE)

#define LDAP_MESSAGE_dup(a) (LDAP_MESSAGE *)ASN1_dup( \
	(ASN1_i2d_t *)i2d_LDAP_MESSAGE, (ASN1_d2i_t *)d2i_LDAP_MESSAGE, (a))


/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* !_LDAPBER_LDAPBER_H */

