/*************************************************************************
 *
 *  $RCSfile: inetcfg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_CONFIG_HXX
#define _INET_CONFIG_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

#ifdef _USE_NAMESPACE
namespace inet {
#endif

/*=======================================================================
 *
 * INetProtocolPorts.
 *
 *=====================================================================*/
enum INetProtocolPorts
{
	eINET_FTP_PORT   =   21,
	eINET_SMTP_PORT  =   25,
	eINET_HTTP_PORT  =   80,
	eINET_POP3_PORT  =  110,
	eINET_NNTP_PORT  =  119,
	eINET_IMAP_PORT  =  143,
	eINET_LDAP_PORT  =  389,
	eINET_HTTPS_PORT =  443,
	eINET_SOCKS_PORT = 1080
};

/*=======================================================================
 *
 * INetProxyConfig interface.
 *
 *=====================================================================*/
class INetProxyConfig
{
	/** HttpProxy.
	*/
	rtl::OUString m_aHttpProxyName;
	sal_uInt16    m_nHttpProxyPort;

	/** FtpProxy.
	*/
	rtl::OUString m_aFtpProxyName;
	sal_uInt16    m_nFtpProxyPort;

	/** SecureSocketProxy.
	*/
	rtl::OUString m_aSecureSocketProxyName;
	sal_uInt16    m_nSecureSocketProxyPort;

	/** SocksProxy.
	*/
	rtl::OUString m_aSocksProxyName;
	sal_uInt16    m_nSocksProxyPort;

	/** NoProxyList.
	*/
	rtl::OUString m_aNoProxyList;

public:
	/** Construction, Destruction.
	*/
	INetProxyConfig (void);
	INetProxyConfig (const INetProxyConfig& rOther);
	virtual ~INetProxyConfig (void) {}

	/** Assignment.
	*/
	INetProxyConfig& operator= (const INetProxyConfig& rOther);

	/** Comparison.
	*/
	sal_Bool operator== (const INetProxyConfig& rOther);

	/** HttpProxy.
	*/
	const rtl::OUString& getHttpProxyName (void) const;
	sal_uInt16 getHttpProxyPort (void) const;
	sal_Bool   hasHttpProxy (void) const;
	void       setHttpProxy (
		const rtl::OUString& rName, sal_uInt16 nPort = eINET_HTTP_PORT);

	/** FtpProxy.
	*/
	const rtl::OUString& getFtpProxyName (void) const;
	sal_uInt16 getFtpProxyPort (void) const;
	sal_Bool   hasFtpProxy (void) const;
	void       setFtpProxy (
		const rtl::OUString& rName, sal_uInt16 nPort = eINET_HTTP_PORT);

	/** SecureSocketProxy.
	*/
	const rtl::OUString& getSecureSocketProxyName (void) const;
	sal_uInt16 getSecureSocketProxyPort (void) const;
	sal_Bool   hasSecureSocketProxy (void) const;
	void       setSecureSocketProxy (
		const rtl::OUString& rName, sal_uInt16 nPort = eINET_HTTP_PORT);

	/** SocksProxy.
	*/
	const rtl::OUString& getSocksProxyName (void) const;
	sal_uInt16 getSocksProxyPort (void) const;
	sal_Bool   hasSocksProxy (void) const;
	void       setSocksProxy (
		const rtl::OUString& rName, sal_uInt16 nPort = eINET_SOCKS_PORT);

	/** NoProxyList.
	*/
	const rtl::OUString& getNoProxyList (void) const;
	void setNoProxyList (const rtl::OUString& rNoProxyList);
};

/*=======================================================================
 *
 * INetProxyConfig (inline) implementation.
 *
 *=====================================================================*/
/*
 * INetProxyConfig.
 */
inline INetProxyConfig::INetProxyConfig (void)
	: m_nHttpProxyPort         (eINET_HTTP_PORT),
	  m_nFtpProxyPort          (eINET_HTTP_PORT),
	  m_nSecureSocketProxyPort (eINET_HTTP_PORT),
	  m_nSocksProxyPort        (eINET_SOCKS_PORT)
{
}

inline INetProxyConfig::INetProxyConfig (const INetProxyConfig& rOther)
	: m_aHttpProxyName         (rOther.m_aHttpProxyName),
	  m_nHttpProxyPort         (rOther.m_nHttpProxyPort),
	  m_aFtpProxyName          (rOther.m_aFtpProxyName),
	  m_nFtpProxyPort          (rOther.m_nFtpProxyPort),
	  m_aSecureSocketProxyName (rOther.m_aSecureSocketProxyName),
	  m_nSecureSocketProxyPort (rOther.m_nSecureSocketProxyPort),
	  m_aSocksProxyName        (rOther.m_aSocksProxyName),
	  m_nSocksProxyPort        (rOther.m_nSocksProxyPort),
	  m_aNoProxyList           (rOther.m_aNoProxyList)
{
}

/*
 * operator=().
 */
inline INetProxyConfig&
INetProxyConfig::operator= (const INetProxyConfig& rOther)
{
	if (this != &rOther)
	{
		m_aHttpProxyName         = rOther.m_aHttpProxyName;
		m_nHttpProxyPort         = rOther.m_nHttpProxyPort;

		m_aFtpProxyName          = rOther.m_aFtpProxyName;
		m_nFtpProxyPort          = rOther.m_nFtpProxyPort;

		m_aSecureSocketProxyName = rOther.m_aSecureSocketProxyName;
		m_nSecureSocketProxyPort = rOther.m_nSecureSocketProxyPort;

		m_aSocksProxyName        = rOther.m_aSocksProxyName;
		m_nSocksProxyPort        = rOther.m_nSocksProxyPort;

		m_aNoProxyList           = rOther.m_aNoProxyList;
	}
	return *this;
}

/*
 * operator==().
 */
inline sal_Bool INetProxyConfig::operator== (const INetProxyConfig& rOther)
{
	return (
		(m_aHttpProxyName         == rOther.m_aHttpProxyName        ) &&
		(m_nHttpProxyPort         == rOther.m_nHttpProxyPort        ) &&
		(m_aFtpProxyName          == rOther.m_aFtpProxyName         ) &&
		(m_nFtpProxyPort          == rOther.m_nFtpProxyPort         ) &&
		(m_aSecureSocketProxyName == rOther.m_aSecureSocketProxyName) &&
		(m_nSecureSocketProxyPort == rOther.m_nSecureSocketProxyPort) &&
		(m_aSocksProxyName        == rOther.m_aSocksProxyName       ) &&
		(m_nSocksProxyPort        == rOther.m_nSocksProxyPort       ) &&
		(m_aNoProxyList           == rOther.m_aNoProxyList          )    );
}

/*
 * HttpProxy.
 */
inline const rtl::OUString&
INetProxyConfig::getHttpProxyName (void) const
{
	return m_aHttpProxyName;
}

inline sal_uInt16 INetProxyConfig::getHttpProxyPort (void) const
{
	return m_nHttpProxyPort;
}

inline sal_Bool INetProxyConfig::hasHttpProxy (void) const
{
	return ((m_aHttpProxyName.getLength() > 0) &&
			(m_nHttpProxyPort             > 0)    );
}

inline void INetProxyConfig::setHttpProxy (
	const rtl::OUString& rName, sal_uInt16 nPort)
{
	m_aHttpProxyName = rName;
	m_nHttpProxyPort = nPort;
}

/*
 * FtpProxy.
 */
inline const rtl::OUString&
INetProxyConfig::getFtpProxyName (void) const
{
	return m_aFtpProxyName;
}

inline sal_uInt16 INetProxyConfig::getFtpProxyPort (void) const
{
	return m_nFtpProxyPort;
}

inline sal_Bool INetProxyConfig::hasFtpProxy (void) const
{
	return ((m_aFtpProxyName.getLength() > 0) &&
			(m_nFtpProxyPort             > 0)    );
}

inline void INetProxyConfig::setFtpProxy (
	const rtl::OUString& rName, sal_uInt16 nPort)
{
	m_aFtpProxyName = rName;
	m_nFtpProxyPort = nPort;
}

/*
 * SecureSocketProxy.
 */
inline const rtl::OUString&
INetProxyConfig::getSecureSocketProxyName (void) const
{
	return m_aSecureSocketProxyName;
}

inline sal_uInt16 INetProxyConfig::getSecureSocketProxyPort (void) const
{
	return m_nSecureSocketProxyPort;
}

inline sal_Bool INetProxyConfig::hasSecureSocketProxy (void) const
{
	return ((m_aSecureSocketProxyName.getLength() > 0) &&
			(m_nSecureSocketProxyPort             > 0)    );
}

inline void INetProxyConfig::setSecureSocketProxy (
	const rtl::OUString& rName, sal_uInt16 nPort)
{
	m_aSecureSocketProxyName = rName;
	m_nSecureSocketProxyPort = nPort;
}

/*
 * SocksProxy.
 */
inline const rtl::OUString&
INetProxyConfig::getSocksProxyName (void) const
{
	return m_aSocksProxyName;
}

inline sal_uInt16 INetProxyConfig::getSocksProxyPort (void) const
{
	return m_nSocksProxyPort;
}

inline sal_Bool INetProxyConfig::hasSocksProxy (void) const
{
	return ((m_aSocksProxyName.getLength() > 0) &&
			(m_nSocksProxyPort             > 0)    );
}

inline void INetProxyConfig::setSocksProxy (
	const rtl::OUString& rName, sal_uInt16 nPort)
{
	m_aSocksProxyName = rName;
	m_nSocksProxyPort = nPort;
}

/*
 * NoProxyList.
 */
inline const rtl::OUString& INetProxyConfig::getNoProxyList (void) const
{
	return m_aNoProxyList;
}

inline void INetProxyConfig::setNoProxyList (const rtl::OUString& rNoProxyList)
{
	m_aNoProxyList = rNoProxyList;
}

/*=======================================================================
 *
 * INetProxyPolicy interface.
 *
 *=====================================================================*/
class INetProxyPolicy : public NAMESPACE_VOS(IReference)
{
public:
	virtual sal_Bool shouldUseProxy (
		const rtl::OUString& rUrl, INetProxyConfig& rProxyConfig) = 0;
};

/*=======================================================================
 *
 * INetConfig interface.
 *
 *=====================================================================*/
class INetConfig :
	public NAMESPACE_VOS(OReference),
	public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetConfig, inet));

public:
	/** Get or create the single instance.
	 */
	static sal_Bool getOrCreate (
		NAMESPACE_VOS(ORef)<INetConfig> &rxConfig);

	/** DomainNameServer.
	*/
	const rtl::OUString& getDomainNameServer (void) const;
	void setDomainNameServer (
		const rtl::OUString& rDomainNameServer);

	/** UserAgent.
	*/
	const rtl::OUString& getUserAgent (void) const;
	void  setUserAgent (const rtl::OUString& rUserAgent);

	/** ProxyConfig.
	*/
	const INetProxyConfig& getProxyConfig (void) const;
	void  setProxyConfig (const INetProxyConfig& rProxyConfig);

	/** ProxyPolicy.
	*/
	virtual NAMESPACE_VOS(ORef)<INetProxyPolicy> getProxyPolicy (void) const;
	void    setProxyPolicy (
		const NAMESPACE_VOS(ORef)<INetProxyPolicy> &rxProxyPolicy);

	/** SecureSocket certificate path.
	*/
	virtual void setSecureSocketCertificatePath (
		const rtl::OUString &rPath);

	/** SecureSocket cipher level.
	*   @param nLevel determines (U.S. export restricted) cipher usage.
	*/
	virtual void setSecureSocketCipherLevel (sal_uInt16 nLevel);

protected:
	INetConfig (void);
	virtual ~INetConfig (void);

private:
	/** The single instance.
	 */
	static INetConfig *m_pThis;

	/** Representation.
	*/
	rtl::OUString m_aDomainNameServer;
	rtl::OUString m_aUserAgent;

	NAMESPACE_VOS(ORef)<INetProxyPolicy> m_xProxyPolicy;
	INetProxyConfig                      m_aProxyConfig;

	/** Not implemented.
	*/
	INetConfig (const INetConfig&);
	INetConfig& operator= (const INetConfig&);
};

/*=======================================================================
 *
 * INetConfig (inline) implementation.
 *
 *=====================================================================*/
/*
 * getDomainNameServer.
 */
inline const rtl::OUString&
INetConfig::getDomainNameServer (void) const
{
	return m_aDomainNameServer;
}

/*
 * setDomainNameServer.
 */
inline void INetConfig::setDomainNameServer (
	const rtl::OUString& rDomainNameServer)
{
	m_aDomainNameServer = rDomainNameServer;
}

/*
 * getUserAgent.
 */
inline const rtl::OUString& INetConfig::getUserAgent (void) const
{
	return m_aUserAgent;
}

/*
 * setUserAgent.
 */
inline void INetConfig::setUserAgent (const rtl::OUString& rUserAgent)
{
	m_aUserAgent = rUserAgent;
}

/*
 * getProxyConfig.
 */
inline const INetProxyConfig& INetConfig::getProxyConfig (void) const
{
	return m_aProxyConfig;
}

/*
 * setProxyConfig.
 */
inline void INetConfig::setProxyConfig (
	const INetProxyConfig& rProxyConfig)
{
	m_aProxyConfig = rProxyConfig;
}

/*
 * setProxyPolicy.
 */
inline void INetConfig::setProxyPolicy (
	const NAMESPACE_VOS(ORef)<INetProxyPolicy> &rxProxyPolicy)
{
	m_xProxyPolicy = rxProxyPolicy;
}

/*=======================================================================
 *
 * The End.
 *
 *=====================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_CONFIG_HXX */

