<!--

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright: 2000 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xt="http://www.jclark.com/xt"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                office:class="text"
                office:version="1.0"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help">


    <xsl:output method               = "xml"
                omit-xml-declaration = "no"
                media-type           = "text/vnd.wap.wml"
                indent-result        = "yes"
                doctype-public       = "-//WAPFORUM//DTD WML 1.1//EN"
                doctype-system       = "http://www.wapforum.org/DTD/wml_1.1.xml"/>


    <!--+++++ INCLUDED XSL MODULES +++++-->

      <!-- inherited style properties will be collected and written in a CSS header (CSS) -->
    <xsl:include href="style_header.xsl"/>
      <!-- inherited style properties will be collected and written as html properties in a temporary variable (HTML4, PALM) -->
    <xsl:include href="style_inlined.xsl"/>
      <!-- our xml style properties will be mapped to CSS and HTML4.x properties -->
    <xsl:include href="style_mapping.xsl"/>
      <!-- common element handling -->
    <xsl:include href="common.xsl"/>
      <!-- table handling -->
    <xsl:include href="table.xsl"/>
    <xsl:include href="table_wml.xsl"/>
      <!-- palm handling -->
    <xsl:include href="palm.xsl"/>



    <!--+++++ PARAMETER FROM THE APPLICATION AND GLOBAL VARIABLES +++++-->

    <!--    user-agent will be differntiated by this parameter given by application (e.g. java servlet)-->
    <xsl:param name="outputType" select="'WML'"/>
    <xsl:param name="baseURL"/>
    <xsl:param name="documentPackageURL"/>
    <xsl:param name="suffixOfURL"/>
    <xsl:param name="metaURL"/>
    <xsl:param name="stylesURL"/>

    <xsl:variable name="office:document-meta" select="document($metaURL)/office:document-meta"/>
    <xsl:variable name="office:document-styles" select="document($stylesURL)/office:document-styles"/>
    <xsl:variable name="office:styles" select="$office:document-styles/office:styles"/>
    <xsl:variable name="office:automatic-styles" select="/office:document-content/office:automatic-styles"/>

    <!--    for activating the debug mode set the variable here to 'true()' or give any value from outside -->
    <xsl:variable name="DEBUG"   select="false()"/>

    <!--    to access the variable like a node-set it is necessary to convert it
            from a result-tree-fragment (RTF) to a node set using the James Clark extension-->
    <xsl:variable name="cssStyleProperties-RTF">
            <xsl:call-template name='create-all-inline-styles'/>
    </xsl:variable>
    <xsl:variable name="cssStyleProperties" select="xt:node-set($cssStyleProperties-RTF)"/>

    <!--    AVOID NESTING PARAGRAPHS IN WML:
            The list of all office tags, which map to a paragraph. This is necessary as no nested
            paragraph tags are allowed in WML1.1 so a parent check before open has to be done.
            Checked in a table cell, the table row is ALWAYS an ancestor, so it have to be excluded -->
    <xsl:variable name="wap-paragraph-elements-without-table-row" select="'text:p text:h text:span text:a text:section text:list-item draw:text-box draw:page table:sub-table'"/>
    <xsl:variable name="wap-paragraph-elements"                   select="concat($wap-paragraph-elements-without-table-row, ' table:table-row ')"/>




    <!-- ************************************* -->
    <!-- *** build the propriate HTML file *** -->
    <!-- ************************************* -->


    <xsl:template match="/">
        <xsl:element name="wml">
            <xsl:element name="card">
                <!-- processing the content of the xml file -->
                <xsl:apply-templates select="/office:document-content/office:body"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>

</xsl:stylesheet>
