/*************************************************************************
 *
 *  $RCSfile: queue.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_QUEUE_HXX_
#define _VOS_QUEUE_HXX_


#ifndef _VOS_SEMAPHOR_HXX_
#	include <vos/semaphor.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#	include <vos/mutex.hxx>
#endif

#ifndef __LIST__
#ifdef __BORLANDC__
#include <list.>
#else
#	include <list>
#endif
#endif

#ifdef _USE_NAMESPACE
namespace vos
{
#endif

template <class TELEMENT>
class OQueue : public VOS_NAMESPACE(OObject, vos)
{
public:
	enum { Infinite= -1 };

	/// default queue has no length-limitation (capacity= Infinite)
	OQueue(sal_Int32 capacity= Infinite );

	/// removes all elements
	inline ~OQueue();


	/// returns True is getLength() is 0
	sal_Bool SAL_CALL isEmpty() const;

	/// if capacity is Infinite, always returns False
	sal_Bool SAL_CALL isFull() const;


	/** returns the max.length of the queue, if capacity is limited,
	    otherwise returns "Infinite"
	*/
	sal_Int32 SAL_CALL getCapacity() const;

	/// returns actual amount of entries in the queue
	sal_uInt32 SAL_CALL getLength() const;

	/** blocks if capacity != Infinite and isFull() is True until
	    another element has been removed
	*/
	void SAL_CALL addTail(const TELEMENT& element);

	/** Removes the front element from the queue and returns it. The
	    call blocks if the queue is emty (isEmpty()==True).
	*/
	TELEMENT SAL_CALL getHead();

	/// Removes head from queue. If the queue is empty, it will NOT block.
	void SAL_CALL removeHead();

	/** Removes "element" from the queue, if it is found. The call will NOT
	    block, even if the queue is empty or "element" is not found.
	 */
	void SAL_CALL remove(const TELEMENT& element);

 protected:

	NAMESPACE_VOS(OSemaphore)			m_notEmpty;
	NAMESPACE_VOS(OSemaphore)			m_notFull;
	NAMESPACE_VOS(OMutex)				m_Lock;

// HRO: Keine typedefs innerhalb von Klassen-Deklarationen beim Borland

#if !defined( __BORLANDC__ )
	typedef NAMESPACE_STD(list)<TELEMENT> TElementList;
	TElementList                        m_Queue;
#else
	NAMESPACE_STD(list<TELEMENT>)		m_Queue;
#endif

	sal_Int32								m_Capacity;
};

#include <vos/queue.inl>

#ifdef _USE_NAMESPACE
}
#endif

#endif // _VOS_QUEUE_HXX_
