/*************************************************************************
 *
 *  $RCSfile: lstbox.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mt $ $Date: 2001/04/12 10:02:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_LSTBOX_HXX
#define _SV_LSTBOX_HXX

#ifndef _SV_CTRL_HXX
#include <vcl/ctrl.hxx>
#endif
#ifndef _SV_LSTBOX_H
#include <vcl/lstbox.h>
#endif

class Image;
class ImplListBox;
class ImplListBoxFloatingWindow;
class ImplBtn;
class ImplWin;

// ------------
//	- ListBox -
// ------------

class ListBox : public Control
{
private:
	ImplListBox*				mpImplLB;
	ImplListBoxFloatingWindow*	mpFloatWin;
	ImplWin*					mpImplWin;
	ImplBtn*					mpBtn;
	USHORT						mnDDHeight;
	USHORT						mnSaveValue;
	BOOL						mbDDAutoSize;
	Link						maSelectHdl;
	Link						maDoubleClickHdl;

#if 0 // _SOLAR__PRIVATE
private:
	void			ImplInitData();

					DECL_LINK( ImplSelectHdl, void* );
					DECL_LINK( ImplCancelHdl, void* );
					DECL_LINK( ImplDoubleClickHdl, void* );
					DECL_LINK( ImplClickBtnHdl, void* );
					DECL_LINK( ImplPopupModeEndHdl, void* );
					DECL_LINK( ImplSelectionChangedHdl, void* );
					DECL_LINK( ImplUserDrawHdl, UserDrawEvent* );

protected:
	void			ImplInit( Window* pParent, WinBits nStyle );
	WinBits 		ImplInitStyle( WinBits nStyle );
	void			ImplLoadRes( const ResId& rResId );
	BOOL			IsDropDownBox() const { return mpFloatWin ? TRUE : FALSE; }
#endif

protected:
					ListBox( WindowType nType );

public:
					ListBox( Window* pParent, WinBits nStyle = WB_BORDER );
					ListBox( Window* pParent, const ResId& rResId );
					~ListBox();

	virtual void	Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
	virtual void	Resize();
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual void	StateChanged( StateChangedType nType );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
	virtual void	UserDraw( const UserDrawEvent& rUDEvt );

	virtual void	Select();
	virtual void	DoubleClick();
	virtual void	GetFocus();
	virtual void	LoseFocus();

	virtual void	SetPosSizePixel( long nX, long nY,
									 long nWidth, long nHeight, USHORT nFlags = WINDOW_POSSIZE_ALL );
	void			SetPosSizePixel( const Point& rNewPos, const Size& rNewSize )
						{ Control::SetPosSizePixel( rNewPos, rNewSize ); }

	void			SetDropDownLineCount( USHORT nLines );
	USHORT			GetDropDownLineCount() const;

	void			EnableAutoSize( BOOL bAuto );
	BOOL			IsAutoSizeEnabled() const { return mbDDAutoSize; }

	USHORT			InsertEntry( const XubString& rStr, USHORT nPos = LISTBOX_APPEND );
	USHORT			InsertEntry( const Image& rImage, USHORT nPos = LISTBOX_APPEND );
	USHORT			InsertEntry( const XubString& rStr, const Image& rImage, USHORT nPos = LISTBOX_APPEND );
	void			RemoveEntry( const XubString& rStr );
	void			RemoveEntry( USHORT nPos );

	void			Clear();

	USHORT			GetEntryPos( const XubString& rStr ) const;
	USHORT			GetEntryPos( const void* pData ) const;
	XubString		GetEntry( USHORT nPos ) const;
	USHORT			GetEntryCount() const;

	void			SelectEntry( const XubString& rStr, BOOL bSelect = TRUE );
	void			SelectEntryPos( USHORT nPos, BOOL bSelect = TRUE );

	USHORT			GetSelectEntryCount() const;
	XubString		GetSelectEntry( USHORT nSelIndex = 0 ) const;
	USHORT			GetSelectEntryPos( USHORT nSelIndex = 0 ) const;

	BOOL			IsEntrySelected( const XubString& rStr ) const;
	BOOL			IsEntryPosSelected( USHORT nPos ) const;
	void			SetNoSelection();

	void			SetEntryData( USHORT nPos, void* pNewData );
	void*			GetEntryData( USHORT nPos ) const;

	void			SetTopEntry( USHORT nPos );
	void			SetTopEntryStr( const XubString& rStr );
	USHORT			GetTopEntry() const;

	void			SaveValue() { mnSaveValue = GetSelectEntryPos(); }
	USHORT			GetSavedValue() const { return mnSaveValue; }

	void			SetSeparatorPos( USHORT n );
	void			SetSeparatorPos();
	USHORT			GetSeparatorPos() const;

	BOOL			IsTravelSelect() const;
	BOOL			IsInDropDown() const;

	void			EnableMultiSelection( BOOL bMulti, BOOL bStackSelection );
	void			EnableMultiSelection( BOOL bMulti );
	BOOL			IsMultiSelectionEnabled() const;

	void			SetReadOnly( BOOL bReadOnly = TRUE );
	BOOL			IsReadOnly() const;

	long			CalcWindowSizePixel( USHORT nLines ) const;

	void			SetUserItemSize( const Size& rSz );
	const Size& 	GetUserItemSize() const;

	void			EnableUserDraw( BOOL bUserDraw );
	BOOL			IsUserDrawEnabled() const;

	void			DrawEntry( const UserDrawEvent& rEvt, BOOL bDrawImage, BOOL bDrawText, BOOL bDrawTextAtImagePos = FALSE );

	void			SetSelectHdl( const Link& rLink )		{ maSelectHdl = rLink; }
	const Link& 	GetSelectHdl() const					{ return maSelectHdl; }
	void			SetDoubleClickHdl( const Link& rLink )	{ maDoubleClickHdl = rLink; }
	const Link& 	GetDoubleClickHdl() const				{ return maDoubleClickHdl; }

	Size			CalcMinimumSize() const;
	Size			CalcAdjustedSize( const Size& rPrefSize ) const;
	Size			CalcSize( USHORT nColumns, USHORT nLines ) const;
	void			GetMaxVisColumnsAndLines( USHORT& rnCols, USHORT& rnLines ) const;

	void			SetMRUEntries( const XubString& rEntries, xub_Unicode cSep = ';' );
	XubString		GetMRUEntries( xub_Unicode cSep = ';' ) const;
	void			SetMaxMRUCount( USHORT n );
	USHORT			GetMaxMRUCount() const;
};

// ----------------
// - MultiListBox -
// ----------------

class MultiListBox : public ListBox
{
private:
	// Bei MultiListBox nicht erlaubt...
	void			SaveValue();
	USHORT			GetSavedValue();

public:
					MultiListBox( Window* pParent, WinBits nStyle = 0 );
					MultiListBox( Window* pParent, const ResId& rResId );
};

#endif	// _SV_LSTBOX_HXX
