/*************************************************************************
 *
 *  $RCSfile: timestamp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: willem.vandorp $ $Date: 2000/09/29 14:23:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TIMESTAMP_HXX
#define _TIMESTAMP_HXX

//______________________________________________________________________________________________________________________________
//  my own includes
//______________________________________________________________________________________________________________________________

//______________________________________________________________________________________________________________________________
//  includes of other projects
//______________________________________________________________________________________________________________________________

//______________________________________________________________________________________________________________________________
//  includes of my own project
//______________________________________________________________________________________________________________________________

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

//______________________________________________________________________________________________________________________________
//  defines
//______________________________________________________________________________________________________________________________

#define TIMESTAMP_MAXLENGTH       		31														/// Max. length of valid timestamp in stream.
#define TIMESTAMP_INVALID_DATETIME    	( DateTime ( Date ( 1, 1, 1601 ), Time ( 0, 0, 0 ) ) )	/// Invalid value for date and time to create invalid instance of TimeStamp.

//______________________________________________________________________________________________________________________________
//  classes, structs
//______________________________________________________________________________________________________________________________

class TimeStamp
{
	//--------------------------------------------------------------------------------
	//  public method
	//--------------------------------------------------------------------------------
	public:

		//--------------------------------------------------------------------------------
		//  construct / destruct
		//--------------------------------------------------------------------------------

		TimeStamp (													) ;
		TimeStamp ( const String& rName								) ;
		TimeStamp ( const DateTime& rDateTime						) ;
		TimeStamp ( const String& rName, const DateTime& rDateTime	) ;

		//--------------------------------------------------------------------------------
		//  operator methods
		//--------------------------------------------------------------------------------

		const TimeStamp&	operator=	( const TimeStamp& rCopy	)	    ;
		BOOL				operator==	( const TimeStamp& rCompare ) const ;
		int					operator!=	( const TimeStamp& rCompare ) const ;

		//--------------------------------------------------------------------------------
		//  other methods
		//--------------------------------------------------------------------------------

		BOOL				IsValid	(							) const ;
		BOOL				Load	( SvStream& rStream 		)       ;
		BOOL				Save 	( SvStream& rStream 		) const ;
		void				SetName ( const String& rName 		)       ;
		void				SetTime ( const DateTime& rDateTime )       ;
		const String&		GetName (							) const ;
		const DateTime&		GetTime (							) const ;

	//--------------------------------------------------------------------------------
	//  protected methods
	//--------------------------------------------------------------------------------
	protected:

	//--------------------------------------------------------------------------------
	//  private methods
	//--------------------------------------------------------------------------------
	private:

		void	impl_setInvalid		(				) ;
		void	impl_adjustName		( String& rName ) ;

		//--------------------------------------------------------------------------------
		//  debug methods
		//--------------------------------------------------------------------------------

		#ifdef DBG_UTIL

		BOOL	impl_debug_checkParameter	( const String& rString								) const ;
		BOOL	impl_debug_checkParameter	( const String& rString, const DateTime& rDateTime	) const ;
		BOOL	impl_debug_checkParameter	( const TimeStamp& rTimeStamp						) const ;
		BOOL	impl_debug_checkParameter	( SvStream& rSvStream								) const ;
		BOOL	impl_debug_checkParameter	( const DateTime& rDateTime							) const ;

		#endif // DBG_UTIL

	//--------------------------------------------------------------------------------
	//  private variables
	//--------------------------------------------------------------------------------
	private:

		String		m_sModifiedByName	;	/// Name of stamp
		DateTime	m_aModifiedDateTime	;	/// Time and date of stamp

} ;

#endif // _TIMESTAMP_HXX
