/*************************************************************************
 *
 *  $RCSfile: iparser.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2001/05/07 14:35:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef IPARSER_HXX
#define IPARSER_HXX

#include <tools/string.hxx>
#include <tools/link.hxx>
#include <tools/stream.hxx>

// forwards
class Dir;
class GenericInformation;
class GenericInformationList;

//
// class InformationParser
//

/******************************************************************************
Purpose: reads generic information files into a simple structure in memory
******************************************************************************/

// information files used by this parser have following format:

/*

key [value]
{
	key [value]
	key [value]
	{
		key [value]
		...
		...
	}
}
key [value]
...
...

*/

#define DEF_STAND_LST  "\\\\dev4\\data1\\b_server\\config\\stand.lst"

// error codes:

#define IP_NO_ERROR			0x0000
#define IP_UNEXPECTED_EOF	0x0001

#define REPLACE_VARIABLES	TRUE

class InformationParser
{
private:
  static const char cKeyLevelChars;
	BOOL bRecover;
	ByteString sOldLine;

	ByteString sCurrentComment;

	BOOL bReplaceVariables; // meaning %UPD and %VERSION
	USHORT nLevel;
	ByteString sUPD;
	ByteString sVersion;

	Link aStatusLink;
	SvStream *pActStream;
    UniString sStreamName;

	USHORT nErrorCode;
	ULONG nErrorLine;
	ByteString sErrorText;
	ULONG nActLine;

	// methods
	ByteString &ReadLine();
	GenericInformation *ReadKey( GenericInformationList *pExistingList );
	void Recover();

protected:
  BOOL Save( SvStream &rOutStream,
	     const GenericInformationList *pSaveList, USHORT nLevel );
	GenericInformationList *Execute( SvStream &rSourceStream,
								GenericInformationList *pExistingList );
	virtual void PrintStatus( ByteString &rStatus )
		{ if ( aStatusLink.IsSet()) aStatusLink.Call( &rStatus ); }

public:
	InformationParser( BOOL bReplace = FALSE );
	~InformationParser();

	// the following methods return NULL if any errors are detected

	// reads a information file and stores the data in a
	// GenericInformationList
	GenericInformationList *Execute( SvMemoryStream &rSourceStream,
								GenericInformationList *pExistingList = NULL );
	GenericInformationList *Execute( SvFileStream &rSourceStream,
								GenericInformationList *pExistingList = NULL );
	GenericInformationList *Execute( UniString &rSourceFile,
								GenericInformationList *pExistingList = NULL );
	// reads all information files in the dir and stores the data in a
	// GenericInformationList => first key is the filename
	GenericInformationList *Execute( Dir &rDir,
								GenericInformationList *pExistingList = NULL );

  // save the InfrormationList to rSourceFile
  // returns FALSE on error
  BOOL Save( SvFileStream &rSourceStream,
	     const GenericInformationList *pSaveList );
  BOOL Save( SvMemoryStream &rSourceStream,
	     const GenericInformationList *pSaveList );
  BOOL Save( const UniString &rSourceFile,
	     const GenericInformationList *pSaveList );

	USHORT GetErrorCode();
	ByteString &GetErrorText();

	void SetStatusHdl( const Link &rHdl ) { aStatusLink = rHdl; }
};

#endif

