/*************************************************************************
 *
 *  $RCSfile: wrapper.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _INET_WRAPPER_HXX
#define _INET_WRAPPER_HXX "$Revision:   1.0"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _VOS_DYNLOAD_HXX_
#include <vos/dynload.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

class INetIMAPClientRef;
class INetCoreSSLConfig;

class INetSession;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class INetConfig;
class INetCoreMailer;
class INetFTPConnection;
class INetHTTPWrapper;
class INetLDAPWrapper;

/*========================================================================
 *
 * INetModuleApi interface.
 *
 *======================================================================*/
class INetModuleApi
{
public:
	virtual void acquire (void) = 0;
	virtual void release (void) = 0;

	virtual sal_Bool getINetConfig (
		NAMESPACE_VOS(ORef)<INetConfig> &rxConfig) = 0;
	virtual sal_Bool getINetCoreSSLConfig (
		INetCoreSSLConfig *&rpConfig) = 0;

	virtual sal_Bool newINetIMAPClient (
		INetIMAPClientRef &rxClient) = 0;
	virtual sal_Bool newINetFTPConnection (
		NAMESPACE_VOS(ORef)<INetFTPConnection> &rxConnection) = 0;
	virtual sal_Bool newINetHTTPWrapper (
		INetHTTPWrapper *&rpWrapper) = 0;
	virtual sal_Bool newINetLDAPWrapper (
		INetLDAPWrapper *&rpWrapper) = 0;
	virtual sal_Bool newINetCoreMailer (
		INetCoreMailer *&rpMailer) = 0;

	virtual sal_Bool newINetSession (
		INetSession *&rpSession) = 0;
};

/*========================================================================
 *
 * INetWrapper interface.
 *
 *======================================================================*/
class INetWrapper :
	public NAMESPACE_INET(INetModuleApi),
	public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO (VOS_NAMESPACE (INetWrapper, inet));

public:
	INetWrapper (void);
	virtual ~INetWrapper (void);

	/** Obtain the INetConfig instance.
	 *  @param  rxConfig [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool getINetConfig (
		NAMESPACE_VOS(ORef)<INetConfig> &rxConfig);

	/** Obtain the INetCoreSSLConfig instance.
	 *  @param  rpConfig [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool getINetCoreSSLConfig (
		INetCoreSSLConfig *&rpConfig);

	/** Create a new INetIMAPClient instance.
	 *  @param  rxClient [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newINetIMAPClient (
		INetIMAPClientRef &rxClient);

	/** Create a new INetFTPConnection instance.
	 *  @param  rxConnection [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newINetFTPConnection (
		NAMESPACE_VOS(ORef)<INetFTPConnection> &rxConnection);

	/** Create a new INetHTTPWrapper instance.
	 *  @param  rpWrapper [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newINetHTTPWrapper (
		INetHTTPWrapper *&rpWrapper);

	/** Create a new INetLDAPWrapper instance.
	 *  @param  rpWrapper [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newINetLDAPWrapper (
		INetLDAPWrapper *&rpWrapper);

	/** Create a new INetCoreMailer instance.
	 *  @param  rpMailer [out]
	 *  @return sal_True upon success, sal_False otherwise.
	 */
	virtual sal_Bool newINetCoreMailer (
		INetCoreMailer *&rpMailer);

	/** Obsolete. Available for backward compatibility, only.
	 */
	virtual sal_Bool newINetSession (
		INetSession *&rpSession);

private:
	/** Representation.
	 */
	NAMESPACE_VOS(ODynamicLoader)<INetModuleApi>  m_aLoader;
	NAMESPACE_VOS(OMutex)                         m_aMutex;
	INetModuleApi                                *m_pApi;

	/** Implementation.
	 */
	virtual void acquire (void);
	virtual void release (void);

	/** Not implemented.
	 */
	INetWrapper (const INetWrapper&);
	INetWrapper& operator= (const INetWrapper&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INET_WRAPPER_HXX */

