#ifndef GCFG_INC
#define GCFG_INC

/* =====================================================
 *      SO_ROOT definition
 * =====================================================*/

#ifdef SRV_PRODUCT
#define GID_MODULE_SO_ROOT GID_MODULE_OFFICE_SERVER
#elif defined WEB_PRODUCT
#define GID_MODULE_SO_ROOT GID_MODULE_FAT_OFFICE
#else
#define GID_MODULE_SO_ROOT GID_MODULE_ROOT
#endif

/* =====================================================
 *       Styles = (DONT_SELECT_BY_USER);    definition
 * =====================================================*/

#if defined( SRV_PRODUCT ) || defined( WEB_PRODUCT )
#define NO_DONT_SELECT_PRODUCT
#endif

/* =====================================================
 *       Webtop mini is also a Webtop
 * =====================================================*/

#if defined( WEM_PRODUCT )
#define WEB_PRODUCT
#endif

/* =====================================================
 *       Making Classic Fat-Product available
 * =====================================================*/

#if defined( FAT_PRODUCT ) || defined( OFA_PRODUCT ) || defined( OFS_PRODUCT )
#define CLASSIC_FAT_PRODUCT
#endif

/* =====================================================
 *       An Asian ImpressPlayer is also an ImpressPlayer
 * =====================================================*/

#if defined( APL_PRODUCT )
#define IPL_PRODUCT 1
#endif

/* =====================================================
 *       An Asian Adabas is also an Adabas
 * =====================================================*/

#if defined( AAD_PRODUCT )
#define ADA_PRODUCT 2
#endif

/* ================================================================
 *       An Asian Multi installation is also an multi installation
 * ================================================================*/

#if defined( FMA_PRODUCT )
#define FAM_PRODUCT
#endif

// OFA is the new OfficeFATAsia, IS, 27.06.01
// FMA is the new FatMultiAsia, IS, 18.01.02

/* =====================================================
 *		StarOffice FAT
 * =====================================================*/

#if defined( FAM_PRODUCT ) || defined( SFX_PRODUCT ) || defined( OSL_PRODUCT ) || defined( RVP_PRODUCT ) || defined( WEB_PRODUCT ) || defined( OFA_PRODUCT ) || defined( OFS_PRODUCT ) || defined( PP1_PRODUCT )
#define FAT_PRODUCT
#endif

#ifdef FAT_PRODUCT

#ifdef UNX
    #ifdef WEB_PRODUCT
        #define         GCFG_DEF_DESTPATH                   "webtop"
    #elif defined OFA_PRODUCT
        #define         GCFG_DEF_DESTPATH                   "starsuite%PRODUCTVERSION"
    #elif defined CLASSIC_FAT_PRODUCT
        #define         GCFG_DEF_DESTPATH                   "staroffice%PRODUCTVERSION"
    #else
        #define         GCFG_DEF_DESTPATH                   "%PRODUCTNAME%PRODUCTVERSION"
    #endif
#else
    #ifdef WEB_PRODUCT
        #define         GCFG_DEF_DESTPATH                   "<winprogpath>\webtop"
    #else
        #define         GCFG_DEF_DESTPATH                   "<winprogpath>\%PRODUCTNAME%PRODUCTVERSION"
    #endif
#endif

#define         GCFG_DATACARRIER                    "%PRODUCTNAME %PRODUCTVERSION"

#ifdef OSL_PRODUCT
    #define         GCFG_TIME_STAMP                     "0600"
    #define         GCFG_DATE_STAMP                     STRING(SCP_DATESTRING)
#else
    #define         GCFG_TIME_STAMP                     "0600"
    #define         GCFG_DATE_STAMP                     "01052002"  // Format ddmmyyyy
#endif

#define         GCFG_BINARY_DIR                     GID_DIR_PROGRAM
#define         GCFG_RESOURCE_DIR                   GID_DIR_RESOURCE

/* =====================================================
 *		StarOffice Server
 * =====================================================*/
#elif SRV_PRODUCT

#ifdef UNX
#define         GCFG_DEF_DESTPATH                   "sun_webtop"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\sun_webtop"
#endif

#define         GCFG_DATACARRIER                    "sun_webtop_1_1"
#define         GCFG_TODAY_DATE_STAMP               STRING(SCP_DATESTRING)
#define         GCFG_DATE_STAMP                     "01012002"  // Format ddmmyyyy
#define         GCFG_TIME_STAMP                     "0110"
#define         GCFG_BINARY_DIR                     GID_DIR_PROGRAM
#define         GCFG_RESOURCE_DIR                   GID_DIR_RESOURCE

/* =====================================================
 *		StarImpress Player
 * =====================================================*/
#elif IPL_PRODUCT

#ifdef UNX
#define			GCFG_DEF_DESTPATH		   			"soplayer"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\SOPlayer"
#endif

#define			GCFG_STARIMPRESS_FOLDER				"%PRODUCTNAME %PRODUCTVERSION"
#define			GCFG_STARIMPRESS_FOLDERENTRY		"%PRODUCTNAME %PRODUCTVERSION"
#define			GCFG_STARIMPRESS_SETUP				"%PRODUCTNAME Setup"
#define			GCFG_STARIMPRESS_VERSIONKEY			"%PRODUCTNAME %PRODUCTVERSION"

#define			GCFG_DATACARRIER	  		 		"%PRODUCTNAME %PRODUCTVERSION"
#define         GCFG_DATE_STAMP                     "28112001"
#define         GCFG_TIME_STAMP                     "0600"

#define			GCFG_BINARY_DIR						GID_DIR_PROGRAM
#define			GCFG_RESOURCE_DIR                   GID_DIR_PROGRAM

/* =====================================================
 *      OpenOffice.org Player
 * =====================================================*/
#elif OPL_PRODUCT

#ifdef UNX
#define         GCFG_DEF_DESTPATH                   "ooplayer"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\OOPlayer"
#endif

#define         GCFG_STARIMPRESS_FOLDER             "%PRODUCTNAME"
#define         GCFG_STARIMPRESS_FOLDERENTRY        "%PRODUCTNAME"
#define         GCFG_STARIMPRESS_SETUP              "%PRODUCTNAME Setup"
#define         GCFG_STARIMPRESS_VERSIONKEY         "%PRODUCTNAME"

#define         GCFG_DATACARRIER                    "%PRODUCTNAME"
#define         GCFG_DATE_STAMP                     "28112001"
#define         GCFG_TIME_STAMP                     "0100"

#define			GCFG_BINARY_DIR						GID_DIR_PROGRAM
#define			GCFG_RESOURCE_DIR                   GID_DIR_PROGRAM

/* =====================================================
 *		StarSchedule Server
 * =====================================================*/
#elif SSS_PRODUCT

#ifdef UNX
#define			GCFG_DEF_DESTPATH		   			"SdlSrv52"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\SdlSrv52"
#endif

#define			GCFG_SCHEDULESERVER_FOLDER	  		"StarOffice Schedule Server 5.2"
#define			GCFG_SCHEDULESERVER_FOLDERENTRY		"Service Manager 5.2"
#define			GCFG_SCHEDULESERVER_SETUP			"Setup"
#define			GCFG_SCHEDULESERVER_VERSIONKEY		"StarOffice Schedule Server 5.2"

#define			GCFG_DATACARRIER	  		 		"StarOffice Schedule Server 5.2"
#define         GCFG_DATE_STAMP                     "28112001"
#define         GCFG_TIME_STAMP                     "0600"

#define			GCFG_BINARY_DIR						GID_DIR_SERVICE
#define         GCFG_RESOURCE_DIR                   GID_DIR_SERVICE

/* =====================================================
 *		Adabas Setup
 * =====================================================*/
#elif ADA_PRODUCT

#ifdef UNX
#define			GCFG_DEF_DESTPATH		   			"adabas"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\Adabas"
#endif

#define         GCFG_ADABAS_FOLDER                  "Adabas"
#define         GCFG_ADABAS_FOLDERENTRY             "Adabas"
#define         GCFG_ADABAS_SETUP                   "Adabas Setup"
#define         GCFG_ADABAS_VERSIONKEY              "Adabas"

#define         GCFG_DATACARRIER                    "Adabas"
#define         GCFG_DATE_STAMP                     "01012002"  // Format ddmmyyyy
#define         GCFG_TIME_STAMP                     "0600"

#define         GCFG_BINARY_DIR                     GID_DIR_DATABASE_ADABAS_ADABAS
#define         GCFG_RESOURCE_DIR                   GID_DIR_DATABASE_ADABAS_ADABAS

/* =====================================================
 *		Adabas Multikulti Setup
 * =====================================================*/
#elif ADM_PRODUCT

#ifdef UNX
#define			GCFG_DEF_DESTPATH		   			"adabas"
#else
#define         GCFG_DEF_DESTPATH                   "<winprogpath>\Adabas"
#endif

#define         GCFG_ADABAS_FOLDER                  "Adabas"
#define         GCFG_ADABAS_FOLDERENTRY             "Adabas"
#define         GCFG_ADABAS_SETUP                   "Adabas Setup"
#define         GCFG_ADABAS_VERSIONKEY              "Adabas"

#define			GCFG_DATACARRIER	  		 		"Adabas"
#define         GCFG_DATE_STAMP                     "01012002"  // Format ddmmyyyy
#define         GCFG_TIME_STAMP                     "0600"

#define         GCFG_BINARY_DIR                     GID_DIR_DATABASE_ADABAS_ADABAS
#define         GCFG_RESOURCE_DIR                   GID_DIR_DATABASE_ADABAS_ADABAS
#endif

/* =====================================================
 * global helper macros
 * =====================================================*/

#define DOSTRING( x )			   			#x
#define STRING( x )				   			DOSTRING( x )

#define DOCONCAT2( x, y )					x##y
#define CONCAT2( x, y)						DOCONCAT2(x,y)
#define DOCONCAT3( x, y, z )				x##y##z
#define CONCAT3( x, y, z )		   			DOCONCAT3(x,y,z)
#define DOCONCAT4( x, y, z, a )				x##y##z##a
#define CONCAT4( x, y, z, a )				DOCONCAT4(x,y,z,a)
#define DOCONCAT5( x, y, z, a, b )			x##y##z##a##b
#define CONCAT5( x, y, z, a, b )	 		DOCONCAT5(x,y,z,a,b)
#define DOCONCAT6( x, y, z, a, b, c )		x##y##z##a##b##c
#define CONCAT6( x, y, z, a, b, c )			DOCONCAT6(x,y,z,a,b,c)
#define DOCONCAT7( x, y, z, a, b, c, u)     x##y##z##a##b##c##u
#define CONCAT7( x, y, z, a, b, c, u)       DOCONCAT7(x,y,z,a,b,c,u)
#define DOCONCAT8( x, y, z, a, b, c, u, v)  x##y##z##a##b##c##u##v
#define CONCAT8( x, y, z, a, b, c, u, v)    DOCONCAT8(x,y,z,a,b,c,u,v)

/* --------------------------------------------------*/

#define FILE_BODY \
	Carrier			= GID_DATACARRIER;	\
	Date			= GCFG_DATE_STAMP;	\
	Time			= GCFG_TIME_STAMP;

#define BIN_FILE_BODY FILE_BODY \
	UnixRights		= 755

#define TXT_FILE_BODY FILE_BODY \
	UnixRights		= 644

#define TODAY_FILE_BODY \
	Carrier			= GID_DATACARRIER;	\
    Date            = GCFG_TODAY_DATE_STAMP;  \
	Time			= GCFG_TIME_STAMP;

#define TODAY_BIN_FILE_BODY TODAY_FILE_BODY \
	UnixRights		= 755

#define TODAY_TXT_FILE_BODY TODAY_FILE_BODY \
	UnixRights		= 644

/* --------------------------------------------------*/

#ifdef UNX
#define LIBNAME(name)			   			STRING(CONCAT5(lib,name,SUPD,DLLSUFFIX,.so))
#define LIBSHORTNAME(name)                  STRING(CONCAT4(lib,name,DLLSUFFIX,.so))
#define FILTER_LIBNAME(name)	   			LIBNAME(name)
#define EXENAME(name)			  			STRING(name)
#define PROFILENAME(name)		  			STRING(CONCAT2(name,rc))
#else
#define LIBNAME(name)			  			STRING(CONCAT4(name,SUPD,DLLSUFFIX,.dll))
#define LIBSHORTNAME(name)                  STRING(CONCAT3(name,DLLSUFFIX,.dll))
#define FILTER_LIBNAME(name)	   			LIBNAME(name)
#define EXENAME(name)						STRING(CONCAT2(name,.exe))
#define PROFILENAME(name)					STRING(CONCAT2(name,.ini))
#endif

#define RESFILENAME(name,lang)				STRING(CONCAT4(name,SUPD,lang,.res))
#define SHORTRESFILENAME(name,lang)         STRING(CONCAT3(name,lang,.res))
#define HELPFILENAME(name,endung) 			STRING(CONCAT3(name,.,endung))
#define EXTRAFILENAME(name,lang) 			STRING(CONCAT3(name,lang,.zip))

#define ALL_LANG(ident, resid) \
	ident (01) 		= resid; \
	ident (03) 		= resid; \
	ident (07) 		= resid; \
    ident (30)      = resid; \
	ident (31) 		= resid; \
	ident (33) 		= resid; \
	ident (34) 		= resid; \
    ident (35)      = resid; \
    ident (37)      = resid; \
	ident (39) 		= resid; \
	ident (45) 		= resid; \
	ident (46) 		= resid; \
	ident (48) 		= resid; \
	ident (49) 		= resid; \
	ident (81) 		= resid; \
	ident (82) 		= resid; \
	ident (86) 		= resid; \
    ident (88)      = resid; \
    ident (90)      = resid; \
    ident (96)      = resid; \
    ident (99)      = resid

#define RESFILE_ALL_LANG(name) \
	Name (01) 		= RESFILENAME(name,01);		\
	Name (03) 		= RESFILENAME(name,03);		\
	Name (07) 		= RESFILENAME(name,07);		\
    Name (30)       = RESFILENAME(name,30);     \
	Name (31) 		= RESFILENAME(name,31);		\
	Name (33) 		= RESFILENAME(name,33);		\
	Name (34) 		= RESFILENAME(name,34);		\
    Name (35)       = RESFILENAME(name,35);     \
    Name (37)       = RESFILENAME(name,37);     \
	Name (39) 		= RESFILENAME(name,39);		\
	Name (45) 		= RESFILENAME(name,45);		\
	Name (46) 		= RESFILENAME(name,46);		\
	Name (48) 		= RESFILENAME(name,48);		\
	Name (49) 		= RESFILENAME(name,49);		\
	Name (81) 		= RESFILENAME(name,81);		\
	Name (82) 		= RESFILENAME(name,82);		\
	Name (86) 		= RESFILENAME(name,86);		\
    Name (88)       = RESFILENAME(name,88);     \
    Name (90)       = RESFILENAME(name,90);     \
    Name (96)       = RESFILENAME(name,96);     \
    Name (99)       = RESFILENAME(name,99)

#define SHORT_RESFILE_ALL_LANG(name) \
    Name (01)       = SHORTRESFILENAME(name,01);     \
    Name (03)       = SHORTRESFILENAME(name,03);     \
    Name (07)       = SHORTRESFILENAME(name,07);     \
    Name (30)       = SHORTRESFILENAME(name,30);     \
    Name (31)       = SHORTRESFILENAME(name,31);     \
    Name (33)       = SHORTRESFILENAME(name,33);     \
    Name (34)       = SHORTRESFILENAME(name,34);     \
    Name (35)       = SHORTRESFILENAME(name,35);     \
    Name (36)       = SHORTRESFILENAME(name,36);     \
    Name (37)       = SHORTRESFILENAME(name,37);     \
    Name (39)       = SHORTRESFILENAME(name,39);     \
    Name (42)       = SHORTRESFILENAME(name,42);     \
    Name (43)       = SHORTRESFILENAME(name,43);     \
    Name (44)       = SHORTRESFILENAME(name,44);     \
    Name (45)       = SHORTRESFILENAME(name,45);     \
    Name (46)       = SHORTRESFILENAME(name,46);     \
    Name (47)       = SHORTRESFILENAME(name,47);     \
    Name (48)       = SHORTRESFILENAME(name,48);     \
    Name (49)       = SHORTRESFILENAME(name,49);     \
    Name (55)       = SHORTRESFILENAME(name,55);     \
    Name (66)       = SHORTRESFILENAME(name,66);     \
    Name (81)       = SHORTRESFILENAME(name,81);     \
    Name (82)       = SHORTRESFILENAME(name,82);     \
    Name (86)       = SHORTRESFILENAME(name,86);     \
    Name (88)       = SHORTRESFILENAME(name,88);     \
    Name (90)       = SHORTRESFILENAME(name,90);     \
    Name (91)       = SHORTRESFILENAME(name,91);     \
    Name (96)       = SHORTRESFILENAME(name,96);     \
    Name (97)       = SHORTRESFILENAME(name,97);     \
    Name (99)       = SHORTRESFILENAME(name,99)

#define EXTRA_ALL_LANG(name) \
    Name (01)       = EXTRAFILENAME(name,01);     \
    Name (03)       = EXTRAFILENAME(name,03);     \
    Name (07)       = EXTRAFILENAME(name,07);     \
    Name (30)       = EXTRAFILENAME(name,30);     \
    Name (31)       = EXTRAFILENAME(name,31);     \
    Name (33)       = EXTRAFILENAME(name,33);     \
    Name (34)       = EXTRAFILENAME(name,34);     \
    Name (35)       = EXTRAFILENAME(name,35);     \
    Name (37)       = EXTRAFILENAME(name,37);     \
    Name (39)       = EXTRAFILENAME(name,39);     \
    Name (45)       = EXTRAFILENAME(name,45);     \
    Name (46)       = EXTRAFILENAME(name,46);     \
    Name (48)       = EXTRAFILENAME(name,48);     \
    Name (49)       = EXTRAFILENAME(name,49);     \
    Name (81)       = EXTRAFILENAME(name,81);     \
    Name (82)       = EXTRAFILENAME(name,82);     \
    Name (86)       = EXTRAFILENAME(name,86);     \
    Name (88)       = EXTRAFILENAME(name,88);     \
    Name (90)       = EXTRAFILENAME(name,90);     \
    Name (96)       = EXTRAFILENAME(name,96);     \
    Name (99)       = EXTRAFILENAME(name,99)

#define EXTRA_IDENT_ALL_LANG(name) \
    Name (01)       = STRING(name);     \
    Name (03)       = STRING(name);     \
    Name (07)       = STRING(name);     \
    Name (30)       = STRING(name);     \
    Name (31)       = STRING(name);     \
    Name (33)       = STRING(name);     \
    Name (34)       = STRING(name);     \
    Name (35)       = STRING(name);     \
    Name (37)       = STRING(name);     \
    Name (39)       = STRING(name);     \
    Name (45)       = STRING(name);     \
    Name (46)       = STRING(name);     \
    Name (48)       = STRING(name);     \
    Name (49)       = STRING(name);     \
    Name (81)       = STRING(name);     \
    Name (82)       = STRING(name);     \
    Name (86)       = STRING(name);     \
    Name (88)       = STRING(name);     \
    Name (90)       = STRING(name);     \
    Name (96)       = STRING(name);     \
    Name (99)       = STRING(name)

#define CONFIGHELPFILE_ALL_LANG(name) \
    Name (01)       = HELPFILENAME(name,01);     \
    Name (03)       = HELPFILENAME(name,03);     \
    Name (07)       = HELPFILENAME(name,07);     \
    Name (30)       = HELPFILENAME(name,30);     \
    Name (31)       = HELPFILENAME(name,31);     \
    Name (33)       = HELPFILENAME(name,33);     \
    Name (34)       = HELPFILENAME(name,34);     \
    Name (35)       = HELPFILENAME(name,35);     \
    Name (37)       = HELPFILENAME(name,37);     \
    Name (39)       = HELPFILENAME(name,39);     \
    Name (45)       = HELPFILENAME(name,45);     \
    Name (46)       = HELPFILENAME(name,46);     \
    Name (48)       = HELPFILENAME(name,48);     \
    Name (49)       = HELPFILENAME(name,49);     \
    Name (81)       = HELPFILENAME(name,81);     \
    Name (82)       = HELPFILENAME(name,82);     \
    Name (86)       = HELPFILENAME(name,86);     \
    Name (88)       = HELPFILENAME(name,88);     \
    Name (90)       = HELPFILENAME(name,90);     \
    Name (96)       = HELPFILENAME(name,96);     \
    Name (99)       = HELPFILENAME(name,99)

#define DELCONFIGHELPFILE_ALL_LANG(name) \
    Name (01)       = HELPFILENAME(name,01x);     \
    Name (03)       = HELPFILENAME(name,03x);     \
    Name (07)       = HELPFILENAME(name,07x);     \
    Name (30)       = HELPFILENAME(name,30x);     \
    Name (31)       = HELPFILENAME(name,31x);     \
    Name (33)       = HELPFILENAME(name,33x);     \
    Name (34)       = HELPFILENAME(name,34x);     \
    Name (35)       = HELPFILENAME(name,35x);     \
    Name (37)       = HELPFILENAME(name,37x);     \
    Name (39)       = HELPFILENAME(name,39x);     \
    Name (45)       = HELPFILENAME(name,45x);     \
    Name (46)       = HELPFILENAME(name,46x);     \
    Name (48)       = HELPFILENAME(name,48x);     \
    Name (49)       = HELPFILENAME(name,49x);     \
    Name (81)       = HELPFILENAME(name,81x);     \
    Name (82)       = HELPFILENAME(name,82x);     \
    Name (86)       = HELPFILENAME(name,86x);     \
    Name (88)       = HELPFILENAME(name,88x);     \
    Name (90)       = HELPFILENAME(name,90x);     \
    Name (96)       = HELPFILENAME(name,96x);     \
    Name (99)       = HELPFILENAME(name,99x)

#define HELPFILENAME_ALL_LANG(name, endung) \
    Name (01)       = HELPFILENAME(name,endung);     \
    Name (03)       = HELPFILENAME(name,endung);     \
    Name (07)       = HELPFILENAME(name,endung);     \
    Name (30)       = HELPFILENAME(name,endung);     \
    Name (31)       = HELPFILENAME(name,endung);     \
    Name (33)       = HELPFILENAME(name,endung);     \
    Name (34)       = HELPFILENAME(name,endung);     \
    Name (35)       = HELPFILENAME(name,endung);     \
    Name (37)       = HELPFILENAME(name,endung);     \
    Name (39)       = HELPFILENAME(name,endung);     \
    Name (45)       = HELPFILENAME(name,endung);     \
    Name (46)       = HELPFILENAME(name,endung);     \
    Name (48)       = HELPFILENAME(name,endung);     \
    Name (49)       = HELPFILENAME(name,endung);     \
    Name (81)       = HELPFILENAME(name,endung);     \
    Name (82)       = HELPFILENAME(name,endung);     \
    Name (86)       = HELPFILENAME(name,endung);     \
    Name (88)       = HELPFILENAME(name,endung);     \
    Name (90)       = HELPFILENAME(name,endung);     \
    Name (96)       = HELPFILENAME(name,endung);     \
    Name (99)       = HELPFILENAME(name,endung)

#define HELPDIRNAME_ALL_LANG \
    Dir (01)       = GID_DIR_HELP_01;     \
    Dir (03)       = GID_DIR_HELP_03;     \
    Dir (07)       = GID_DIR_HELP_07;     \
    Dir (30)       = GID_DIR_HELP_30;     \
    Dir (31)       = GID_DIR_HELP_31;     \
    Dir (33)       = GID_DIR_HELP_33;     \
    Dir (34)       = GID_DIR_HELP_34;     \
    Dir (35)       = GID_DIR_HELP_35;     \
    Dir (37)       = GID_DIR_HELP_37;     \
    Dir (39)       = GID_DIR_HELP_39;     \
    Dir (45)       = GID_DIR_HELP_45;     \
    Dir (46)       = GID_DIR_HELP_46;     \
    Dir (48)       = GID_DIR_HELP_48;     \
    Dir (49)       = GID_DIR_HELP_49;     \
    Dir (81)       = GID_DIR_HELP_81;     \
    Dir (82)       = GID_DIR_HELP_82;     \
    Dir (86)       = GID_DIR_HELP_86;     \
    Dir (88)       = GID_DIR_HELP_88;     \
    Dir (90)       = GID_DIR_HELP_90;     \
    Dir (96)       = GID_DIR_HELP_96;     \
    Dir (99)       = GID_DIR_HELP_99

#define DIR_IDENT_ALL_LANG(name) \
    DosName (01)       = STRING(name);     \
    DosName (03)       = STRING(name);     \
    DosName (07)       = STRING(name);     \
    DosName (30)       = STRING(name);     \
    DosName (31)       = STRING(name);     \
    DosName (33)       = STRING(name);     \
    DosName (34)       = STRING(name);     \
    DosName (35)       = STRING(name);     \
    DosName (37)       = STRING(name);     \
    DosName (39)       = STRING(name);     \
    DosName (45)       = STRING(name);     \
    DosName (46)       = STRING(name);     \
    DosName (48)       = STRING(name);     \
    DosName (49)       = STRING(name);     \
    DosName (81)       = STRING(name);     \
    DosName (82)       = STRING(name);     \
    DosName (86)       = STRING(name);     \
    DosName (88)       = STRING(name);     \
    DosName (90)       = STRING(name);     \
    DosName (96)       = STRING(name);     \
    DosName (99)       = STRING(name)

#define DIR_ENGLISH_ALL_LANG            \
    DosName (01)       = "english";     \
    DosName (03)       = "portuguese";  \
    DosName (07)       = "russian";     \
    DosName (30)       = "greek";       \
    DosName (31)       = "dutch";       \
    DosName (33)       = "french";      \
    DosName (34)       = "spanish";     \
    DosName (35)       = "finnish";     \
    DosName (37)       = "catalan";     \
    DosName (39)       = "italian";     \
    DosName (45)       = "danish";      \
    DosName (46)       = "swedish";     \
    DosName (48)       = "polish";      \
    DosName (49)       = "german";      \
    DosName (81)       = "japanese";    \
    DosName (82)       = "korean";      \
    DosName (86)       = "chinese_simplified";     \
    DosName (88)       = "chinese_traditional";    \
    DosName (90)       = "turkish";     \
    DosName (96)       = "arabic";     \
    DosName (99)       = STRING(VLANG)

#define DIR_ISOLANGUAGE_ALL_LANG \
    DosName (01)       = "en";  \
    DosName (03)       = "pt";  \
    DosName (07)       = "ru";  \
    DosName (30)       = "el";  \
    DosName (31)       = "nl";  \
    DosName (33)       = "fr";  \
    DosName (34)       = "es";  \
    DosName (35)       = "fi";  \
    DosName (37)       = "ca";  \
    DosName (39)       = "it";  \
    DosName (45)       = "da";  \
    DosName (46)       = "sv";  \
    DosName (48)       = "pl";  \
    DosName (49)       = "de";  \
    DosName (81)       = "ja";  \
    DosName (82)       = "ko";  \
    DosName (86)       = "zh-CN"; \
    DosName (88)       = "zh-TW"; \
    DosName (90)       = "tr";  \
    DosName (96)       = "ar";  \
    DosName (99)       = STRING(ISO_CODE)

#define ALL_LANG_STR_SECTION(ident) \
        Section (01)              = STRING(ident##-01); \
        Section (03)              = STRING(ident##-03); \
        Section (07)              = STRING(ident##-07); \
        Section (30)              = STRING(ident##-30); \
        Section (31)              = STRING(ident##-31); \
        Section (33)              = STRING(ident##-33); \
        Section (34)              = STRING(ident##-34); \
        Section (35)              = STRING(ident##-35); \
        Section (37)              = STRING(ident##-37); \
        Section (39)              = STRING(ident##-39); \
        Section (45)              = STRING(ident##-45); \
        Section (46)              = STRING(ident##-46); \
        Section (48)              = STRING(ident##-48); \
        Section (49)              = STRING(ident##-49); \
        Section (81)              = STRING(ident##-81); \
        Section (82)              = STRING(ident##-82); \
        Section (86)              = STRING(ident##-86); \
        Section (88)              = STRING(ident##-88); \
        Section (90)              = STRING(ident##-90); \
        Section (96)              = STRING(ident##-96); \
        Section (99)              = STRING(ident##-99)

// Achtung: der Zusatz "-C" ist ntig fr die Zeichenkonvertierung von DV
// Damit drfen mit diesem Makro nur noch "Type-Description"-Eintrge generiert werden
// IS: 27.04.00

#define ALL_LANG_KEY_SECTION(ident) \
        Key (01)              = STRING(ident##-01); \
        Key (03)              = STRING(ident##-03); \
        Key (07)              = STRING(ident##-07-C); \
        Key (30)              = STRING(ident##-30-C); \
        Key (31)              = STRING(ident##-31); \
        Key (33)              = STRING(ident##-33); \
        Key (34)              = STRING(ident##-34); \
        Key (39)              = STRING(ident##-39); \
        Key (45)              = STRING(ident##-45); \
        Key (46)              = STRING(ident##-46); \
        Key (48)              = STRING(ident##-48); \
        Key (49)              = STRING(ident##-49); \
        Key (81)              = STRING(ident##-81-C); \
        Key (82)              = STRING(ident##-82-C); \
        Key (86)              = STRING(ident##-86-C); \
        Key (88)              = STRING(ident##-88-C); \
        Key (90)              = STRING(ident##-90-C); \
        Key (96)              = STRING(ident##-96-C); \
        Key (99)              = STRING(ident##-99)

#define ALL_LANG_STR_KEY(ident) \
        ALL_LANG(Key,ident)

#define ALL_LANG_STR_KEY_LNG(ident) \
        ALL_LANG(Key,STR_KEY_##ident)

#define ALL_LANG_STR_VALUE_LNG(ident) \
        ALL_LANG(Value,STR_VALUE_##ident)

#define ALL_LANG_VALUE(vident) \
	ALL_LANG(Value,vident)

#define ALL_LANG_KEY(vident) \
        ALL_LANG(Key,vident)

#define FILTER_SECTION_KEY_VALUE(s,k,v) \
        ALL_LANG_STR_SECTION(s); \
        ALL_LANG_STR_KEY(k);  \
        ALL_LANG_VALUE(v)

#define KEY_ALL_LANG \
        Key (01)              = STRING(1033); \
        Key (03)              = STRING(2070); \
        Key (07)              = STRING(1049); \
        Key (30)              = STRING(1032); \
        Key (31)              = STRING(1043); \
        Key (33)              = STRING(1036); \
        Key (34)              = STRING(1034); \
        Key (35)              = STRING(1035); \
        Key (37)              = STRING(1037); \
        Key (39)              = STRING(1040); \
        Key (45)              = STRING(1030); \
        Key (46)              = STRING(1053); \
        Key (48)              = STRING(1045); \
        Key (49)              = STRING(1031); \
        Key (81)              = STRING(1041); \
        Key (82)              = STRING(1042); \
        Key (86)              = STRING(2052); \
        Key (88)              = STRING(1028); \
        Key (90)              = STRING(1055); \
        Key (96)              = STRING(1055); \
        Key (99)              = STRING(ISO_CODE)

#define KEY_ALL_LANG_LETTER \
        Key (01)              = STRING(en-US); \
        Key (03)              = STRING(pt); \
        Key (07)              = STRING(ru); \
        Key (30)              = STRING(el); \
        Key (31)              = STRING(nl); \
        Key (33)              = STRING(fr); \
        Key (34)              = STRING(es); \
        Key (35)              = STRING(fi); \
        Key (37)              = STRING(ca); \
        Key (39)              = STRING(it); \
        Key (45)              = STRING(da); \
        Key (46)              = STRING(sv); \
        Key (48)              = STRING(pl); \
        Key (49)              = STRING(de); \
        Key (81)              = STRING(ja); \
        Key (82)              = STRING(ko); \
        Key (86)              = STRING(zh-CN); \
        Key (88)              = STRING(zh-TW); \
        Key (90)              = STRING(tr); \
        Key (96)              = STRING(ar); \
        Key (99)              = STRING(ISO_CODE)

#define VALUE_ALL_LANG \
        Value (01)              = STRING(1033); \
        Value (03)              = STRING(2070); \
        Value (07)              = STRING(1049); \
        Value (30)              = STRING(1032); \
        Value (31)              = STRING(1043); \
        Value (33)              = STRING(1036); \
        Value (34)              = STRING(1034); \
        Value (35)              = STRING(1035); \
        Value (37)              = STRING(1037); \
        Value (39)              = STRING(1040); \
        Value (45)              = STRING(1030); \
        Value (46)              = STRING(1053); \
        Value (48)              = STRING(1045); \
        Value (49)              = STRING(1031); \
        Value (81)              = STRING(1041); \
        Value (82)              = STRING(1042); \
        Value (86)              = STRING(2052); \
        Value (88)              = STRING(1028); \
        Value (90)              = STRING(1055); \
        Value (96)              = STRING(1025); \
        Value (99)              = STRING(ISO_CODE)

#define VALUE_ALL_LANG_LETTER \
        Value (01)              = STRING(en-US); \
        Value (03)              = STRING(pt); \
        Value (07)              = STRING(ru); \
        Value (30)              = STRING(el); \
        Value (31)              = STRING(nl); \
        Value (33)              = STRING(fr); \
        Value (34)              = STRING(es); \
        Value (35)              = STRING(fi); \
        Value (37)              = STRING(ca); \
        Value (39)              = STRING(it); \
        Value (45)              = STRING(da); \
        Value (46)              = STRING(sv); \
        Value (48)              = STRING(pl); \
        Value (49)              = STRING(de); \
        Value (81)              = STRING(ja); \
        Value (82)              = STRING(ko); \
        Value (86)              = STRING(zh-CN); \
        Value (88)              = STRING(zh-TW); \
        Value (90)              = STRING(tr); \
        Value (96)              = STRING(ar); \
        Value (99)              = STRING(ISO_CODE)

#define VALUE_ALL_LANG_LETTER_NON_ASIA \
        Value (01)              = STRING(en-US); \
        Value (03)              = STRING(pt); \
        Value (07)              = STRING(ru); \
        Value (30)              = STRING(el); \
        Value (31)              = STRING(nl); \
        Value (33)              = STRING(fr); \
        Value (34)              = STRING(es); \
        Value (35)              = STRING(fi); \
        Value (37)              = STRING(ca); \
        Value (39)              = STRING(it); \
        Value (45)              = STRING(da); \
        Value (46)              = STRING(sv); \
        Value (48)              = STRING(pl); \
        Value (49)              = STRING(de); \
        Value (90)              = STRING(tr); \
        Value (96)              = STRING(ar); \
        Value (99)              = STRING(ISO_CODE)

#define VALUE_ALL_LANG_LETTER_DIR \
        Value (01)              = STRING(en); \
        Value (03)              = STRING(pt); \
        Value (07)              = STRING(ru); \
        Value (30)              = STRING(el); \
        Value (31)              = STRING(nl); \
        Value (33)              = STRING(fr); \
        Value (34)              = STRING(es); \
        Value (35)              = STRING(fi); \
        Value (37)              = STRING(ca); \
        Value (39)              = STRING(it); \
        Value (45)              = STRING(da); \
        Value (46)              = STRING(sv); \
        Value (48)              = STRING(pl); \
        Value (49)              = STRING(de); \
        Value (81)              = STRING(ja); \
        Value (82)              = STRING(ko); \
        Value (86)              = STRING(zh-CN); \
        Value (88)              = STRING(zh-TW); \
        Value (90)              = STRING(tr); \
        Value (96)              = STRING(ar); \
        Value (99)              = STRING(ISO_CODE)

#define VALUE_ALL_LANGUAGE \
        Value (01)              = STRING(01); \
        Value (03)              = STRING(03); \
        Value (07)              = STRING(07); \
        Value (30)              = STRING(30); \
        Value (31)              = STRING(31); \
        Value (33)              = STRING(33); \
        Value (34)              = STRING(34); \
        Value (35)              = STRING(35); \
        Value (37)              = STRING(37); \
        Value (39)              = STRING(39); \
        Value (45)              = STRING(45); \
        Value (46)              = STRING(46); \
        Value (48)              = STRING(48); \
        Value (49)              = STRING(49); \
        Value (81)              = STRING(81); \
        Value (82)              = STRING(82); \
        Value (86)              = STRING(86); \
        Value (88)              = STRING(88); \
        Value (90)              = STRING(90); \
        Value (96)              = STRING(96); \
        Value (99)              = STRING(99)

// ----------------------------------------------

#define JARFILENAME(name) STRING(CONCAT2(name,.jar))

#define STD_JAR_FILE(id,name) \
	File id \
		TXT_FILE_BODY; \
        Name            = JARFILENAME(name) ; \
        Dir             = GID_DIR_CLASSES; \
        Styles          = (PACKED,DONT_OVERWRITE); \
	End

#endif /* GCFG_INC */

