<!--

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright: 2000 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xt="http://www.jclark.com/xt"
                xmlns:office="http://openoffice.org/2000/office"
                xmlns:style="http://openoffice.org/2000/style"
                xmlns:text="http://openoffice.org/2000/text"
                xmlns:table="http://openoffice.org/2000/table"
                xmlns:draw="http://openoffice.org/2000/drawing"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:number="http://openoffice.org/2000/datastyle"
                xmlns:svg="http://www.w3.org/2000/svg"
                xmlns:chart="http://openoffice.org/2000/chart"
                xmlns:dr3d="http://openoffice.org/2000/dr3d"
                xmlns:math="http://www.w3.org/1998/Math/MathML"
                xmlns:form="http://openoffice.org/2000/form"
                xmlns:script="http://openoffice.org/2000/script"
                office:class="text"
                office:version="1.0"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:meta="http://openoffice.org/2000/meta"
                xmlns:config="http://openoffice.org/2001/config"
                xmlns:help="http://openoffice.org/2000/help"
                xmlns:system="http://www.jclark.com/xt/java/java.lang.System">

    <xsl:output method="html"
                indent-result="yes"/>



    <!--+++++ INCLUDED XSL MODULES +++++-->
    <!-- inherited style properties will be collected and written in a CSS header (CSS) -->
    <xsl:include href="style_header.xsl"/>

    <!-- inherited style properties will be collected and written as html properties in a temporary variable (HTML4, PALM) -->
    <xsl:include href="style_inlined.xsl"/>

    <!-- our xml style properties will be mapped to CSS and HTML4.x properties -->
    <xsl:include href="style_mapping.xsl"/>

    <!-- common element handling -->
    <xsl:include href="common.xsl"/>

    <!-- table handling -->
    <xsl:include href="table.xsl"/>

    <!-- palm handling -->
    <xsl:include href="palm.xsl"/>



    <!--+++++ PARAMETER FROM THE APPLICATION AND GLOBAL VARIABLES +++++-->
    <!-- encoded absolute URL path - including Authority (Server, Port) and Path (SessionID and packed SX* path)  -->
    <xsl:param name="baseURL"/>
    <xsl:param name="documentPackageURL"/>
    <xsl:param name="suffixOfURL"/>
    <xsl:param name="metaURL"/>
    <xsl:param name="stylesURL"/>


    <!-- user-agent will be differntiated by this parameter given by application (e.g. java servlet)-->
    <xsl:param name="outputType" select="'CSS_HEADER'"/>
    <!-- set of possible deviceTyps (WML is set in its own startfile main_wml.xsl):
    <xsl:param name="outputType" select="'CSS_HEADER'"/>
    <xsl:param name="outputType" select="'CSS_INLINED'"/>
    <xsl:param name="outputType" select="'PALM'"/> -->


    <!-- for activating the debug mode set the variable here to 'true()' or give any value from outside -->
    <xsl:param name="DEBUG"   select="false()"/>

    <xsl:variable name="office:document-meta"       select="document($metaURL)/office:document-meta"/>
    <xsl:variable name="office:document-styles"     select="document($stylesURL)/office:document-styles"/>
    <xsl:variable name="office:styles"              select="$office:document-styles/office:styles"/>
    <xsl:variable name="office:automatic-styles"    select="/office:document-content/office:automatic-styles"/>



    <!-- to access the variable like a node-set it is necessary to convert it
         from a result-tree-fragment (RTF) to a node set using the James Clark extension-->
    <xsl:variable name="cssStyleProperties-RTF">
        <xsl:variable name="startTime" select="system:current-time-millis()"/>
        <xsl:call-template name='create-all-inline-styles'/>
        <xsl:if test="$DEBUG">
            <xsl:message>Time for instantiating style variable: <xsl:value-of select="(system:current-time-millis() - $startTime)"/> ms</xsl:message>
        </xsl:if>
    </xsl:variable>
    <xsl:variable name="cssStyleProperties" select="xt:node-set($cssStyleProperties-RTF)"/>



    <!-- ************************************* -->
    <!-- *** build the propriate HTML file *** -->
    <!-- ************************************* -->

    <xsl:template match="/">
        <xsl:choose>
            <!--+++++ CSS (CASCADING STLYE SHEET) HEADER STYLE WAY +++++-->
            <xsl:when test="$outputType = 'CSS_HEADER'">
                <xsl:element name="html">
                    <xsl:element name="head">
                        <xsl:call-template name='common-header-properties'/>

                        <!-- constructing the css header simulating inheritance of style-families by style order -->
                        <xsl:call-template name='create-css-styleheader'/>
                    </xsl:element>

                    <xsl:variable name="backgroundImageURL" select="$office:document-styles/office:automatic-styles/style:page-master/style:properties/style:background-image/@xlink:href"/>
                    <xsl:element name="body">
                        <!-- background image -->
                        <xsl:if test="$backgroundImageURL">
                            <xsl:attribute name="background">
                                <xsl:choose>
                                    <!-- for images jared in open office document -->
                                    <xsl:when test="contains($backgroundImageURL, '#Pictures/')">
                                        <!-- creating an absolute http URL to the contained/packed image file -->
                                        <xsl:value-of select="concat($documentPackageURL, '/Pictures/', substring-after($backgroundImageURL, '#Pictures/'), $suffixOfURL)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:attribute name="src"><xsl:value-of select="$backgroundImageURL"/></xsl:attribute>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                        </xsl:if>

                        <!-- processing the content of the xml file -->
                        <xsl:apply-templates select="/office:document-content/office:body"/>
                    </xsl:element>

                </xsl:element>
            </xsl:when>

            <!--+++++ HTML 4.0 INLINING  +++++-->
            <xsl:when test="$outputType = 'CSS_INLINED'">
                <xsl:element name="html">
                    <xsl:element name="head">
                        <xsl:call-template name='common-header-properties'/>
                    </xsl:element>

                    <xsl:variable name="backgroundImageURL" select="$office:document-styles/office:automatic-styles/style:page-master/style:properties/style:background-image/@xlink:href"/>
                    <xsl:element name="body">
                        <!-- background image -->
                        <xsl:if test="$backgroundImageURL">
                            <xsl:attribute name="background">
                                <xsl:choose>
                                    <!-- for images jared in open office document -->
                                    <xsl:when test="contains($backgroundImageURL, '#Pictures/')">
                                        <!-- creating an absolute http URL to the contained/packed image file -->
                                        <xsl:value-of select="concat($documentPackageURL, '/Pictures/', substring-after($backgroundImageURL, '#Pictures/'), $suffixOfURL)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:attribute name="src"><xsl:value-of select="$backgroundImageURL"/></xsl:attribute>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                        </xsl:if>
                        <xsl:apply-templates select="/office:document-content/office:body"/>
                    </xsl:element>
                </xsl:element>
            </xsl:when>

            <!--+++++ PALM-VII (3.2 HTML SUBSET)  +++++-->
            <xsl:when test="$outputType = 'PALM'">
                <!-- the proxy will convert the html file later to PQA -->
                <xsl:element name="html">
                    <xsl:element name="head">
                        <xsl:call-template name='palm-header-properties'/>
                    </xsl:element>

                    <xsl:element name="body">
                        <!-- processing the content of the xml file -->
                        <xsl:apply-templates select="/office:document-content/office:body"/>
                    </xsl:element>
                </xsl:element>
            </xsl:when>
        </xsl:choose>
    </xsl:template>



    <!-- ******************************************** -->
    <!-- *** title for CSS_INLINED and CSS_HEADER *** -->
    <!-- ******************************************** -->

    <xsl:template name='common-header-properties'>
<!--????-->
        <xsl:apply-templates select="$office:document-meta/office:meta/dc:subject"/>
        <xsl:apply-templates select="$office:document-meta/office:meta/dc:description"/>
        <!--<xsl:for-each select="$office:document-meta/office:meta/dc:title">
            <xsl:element name="title"><xsl:value-of select="."/></xsl:element>
        </xsl:for-each>
        -->
        <!--<xsl:if test="$office:document-meta/office:meta/dc:title">
            <xsl:element name="title"><xsl:value-of select="$office:document-meta/office:meta/dc:title"/></xsl:element>
        </xsl:if>-->
    </xsl:template>

</xsl:stylesheet>
