/*************************************************************************
 *
 *  $RCSfile: itemwin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: os $ $Date: 2001/09/06 14:42:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_ITEMWIN_HXX
#define _SVX_ITEMWIN_HXX

#include <svx/dlgctrl.hxx>

// forward ---------------------------------------------------------------

class XLineColorItem;
class XLineWidthItem;

// class SvxLineBox ------------------------------------------------------

class SvxLineBox : public LineLB
{
public:
	SvxLineBox( Window* pParent, SfxBindings& rBind,
				WinBits nBits = WB_BORDER | WB_DROPDOWN | WB_AUTOHSCROLL );
	~SvxLineBox();

protected:
	virtual void 	Select();
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );

private:
	USHORT			nCurPos;
	Timer			aDelayTimer;
	SfxBindings&	rBindings;
    BOOL            bRelease;

#ifdef _SVX_ITEMWIN_CXX
					DECL_LINK( DelayHdl_Impl, Timer * );

	void			ReleaseFocus_Impl();
#endif
};

// class SvxColorBox -----------------------------------------------------

class SvxColorBox : public ColorLB
{
public:
	SvxColorBox( Window* pParent, USHORT nSID, SfxBindings& rBind,
				 WinBits nBits = WB_BORDER | WB_DROPDOWN | WB_AUTOHSCROLL );
	~SvxColorBox();

	void			Update( const XLineColorItem* pItem );

protected:
	virtual void 	Select();
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );

private:
	USHORT			nCurPos;
	USHORT			nId;
	Timer			aDelayTimer;
	SfxBindings&	rBindings;
    BOOL            bRelease;

#ifdef _SVX_ITEMWIN_CXX
					DECL_LINK( DelayHdl_Impl, Timer * );

	void			ReleaseFocus_Impl();
#endif
};

// class SvxMetricField --------------------------------------------------

class SvxMetricField : public MetricField
{
private:
	String			aCurTxt;
	SfxMapUnit		ePoolUnit;
	FieldUnit		eDlgUnit;
	SfxBindings&	rBindings;

#ifdef _SVX_ITEMWIN_CXX
	void			ReleaseFocus_Impl();
#endif

protected:
	virtual void 	Modify();
	virtual void    Down();
	virtual void    Up();		// Nur zur Sicherheit

	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );

public:
	SvxMetricField( Window* pParent, SfxBindings& rBind,
					WinBits nBits = WB_BORDER | WB_SPIN | WB_REPEAT );
	~SvxMetricField();

	void			Update( const XLineWidthItem* pItem );
	void			SetCoreUnit( SfxMapUnit eUnit );
	void			RefreshDlgUnit();
};

// class SvxFillTypeBox --------------------------------------------------

class SvxFillTypeBox : public FillTypeLB
{
public:
	SvxFillTypeBox( Window* pParent, WinBits nBits = WB_BORDER | WB_DROPDOWN | WB_AUTOHSCROLL );
	~SvxFillTypeBox();

	void			Selected() { bSelect = TRUE; }
    BOOL            IsRelease() { return bRelease;}

protected:
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );

private:
	USHORT			nCurPos;
	BOOL			bSelect;
    BOOL            bRelease;

#ifdef _SVX_ITEMWIN_CXX
	void			ReleaseFocus_Impl();
#endif
};

// class SvxFillAttrBox --------------------------------------------------

class SvxFillAttrBox : public FillAttrLB
{
public:
	SvxFillAttrBox( Window* pParent, WinBits nBits = WB_BORDER | WB_DROPDOWN | WB_AUTOHSCROLL );
	~SvxFillAttrBox();

    BOOL            IsRelease() { return bRelease;}

protected:
	virtual long	PreNotify( NotifyEvent& rNEvt );
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void	Select();

private:
	USHORT			nCurPos;
    BOOL            bRelease;

#ifdef _SVX_ITEMWIN_CXX
	void			ReleaseFocus_Impl();
#endif
};

#endif // #ifndef _SVX_ITEMWIN_HXX

