/*************************************************************************
 *
 *  $RCSfile: styfitem.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:33:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_STYFITEM_HXX
#define _SFX_STYFITEM_HXX

#ifndef _BITMAP_HXX //autogen
#include <vcl/bitmap.hxx>
#endif
#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _RC_HXX //autogen
#include <vcl/rc.hxx>
#endif
#ifndef _RSCSFX_HXX
#include <rsc/rscsfx.hxx>
#endif

#ifndef _SFX_STYFITEM_HXX_NOLIST
struct SfxFilterTupel {
	String aName;
	USHORT nFlags;
};

DECLARE_LIST(SfxStyleFilter, SfxFilterTupel*)
#else
typedef List SfxStyleFilter;
#endif

// CLASS -----------------------------------------------------------------

class SfxStyleFamilyItem: public Resource
{
	Image           aImage;
	Bitmap          aBitmap;
	String          aText;
	String          aHelpText;
	USHORT          nFamily;
	SfxStyleFilter  aFilterList;

public:
					SfxStyleFamilyItem( const ResId &rId );
					~SfxStyleFamilyItem();

	const Bitmap&   GetBitmap() const { return aBitmap; }
	const String&   GetText() const { return aText; }
	const String&   GetHelpText() const { return aHelpText; }
	SfxStyleFamily  GetFamily() const { return (SfxStyleFamily)nFamily; }
	const SfxStyleFilter& GetFilterList() const { return aFilterList; }
	const Image&    GetImage() const { return aImage; }
};

#if 0 // _SOLAR__PRIVATE
DECLARE_LIST(SfxStyleFamilyList, SfxStyleFamilyItem*)
#else
typedef List SfxStyleFamilyList;
#endif

class SfxStyleFamilies: public Resource
{
	SfxStyleFamilyList  aEntryList;

public:
						SfxStyleFamilies( const ResId &);
						SfxStyleFamilies( ) {};
						~SfxStyleFamilies();

	USHORT              Count() const
						{ return (USHORT)aEntryList.Count(); }

	const SfxStyleFamilyItem* GetObject(ULONG nIdx) const
						{ return (SfxStyleFamilyItem*)aEntryList.GetObject(nIdx); }
};

#endif

