/*************************************************************************
 *
 *  $RCSfile: os.hxx,v $
 *
 *  $Revision: 1.11.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:07:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SETUP_OS_HXX
#define __SETUP_OS_HXX

#include <com/sun/star/setup/OSType.hpp>
#include <setup2/sifsys.hxx>

class Window;

///////////////////////////////////////////////////////////////////////////////
//		OS

class OS
{
	static ULONG GetFreeDriveSize(USHORT nDrive);

public:
	static const char* GetAllFilesWildCard();

	static ByteString GetGUIPath();
	static ByteString GetSystemPath();
	static ByteString GetSystemFontPath();
	static ByteString GetIEDir();
	static ByteString GetIEPluginDir( BOOL bPlugin = TRUE );
	static ByteString GetNSPluginDir();
	static ByteString GetNS6PluginDir();

	static ULONG  GetDriveSize(SiDirEntry const&);
	static ULONG  GetClusterSize(SiDirEntry const&);
	static void   SetDateTime (ByteString const& rFilename, Date const&, Time const&);
	static BOOL	  MakeWritable(ByteString const& rFilename);

	static BOOL   InstallFont (ByteString const& rFontFile, ByteString const& rFontName);
	static BOOL   UnInstallFont(ByteString const& rFontFile, ByteString const& rFontName);
	static BOOL   IsFontInstalled(ByteString const& rFontFile,ByteString const& rFontName);

	static com::sun::star::setup::OSType GetType();
	static BOOL   IsConfigurationValid(Window*);
};

#if defined WIN || defined WNT
	inline com::sun::star::setup::OSType OS::GetType() { return com::sun::star::setup::OSType_WIN; }
#elif defined OS2
	inline com::sun::star::setup::OSType OS::GetType() { return com::sun::star::setup::OSType_OS2; }
#elif defined MAC
	inline com::sun::star::setup::OSType OS::GetType() { return com::sun::star::setup::OSType_MAC; }
#elif defined UNX
	inline com::sun::star::setup::OSType OS::GetType() { return com::sun::star::setup::OSType_UNIX_SOLS; }
#else
	inline com::sun::star::setup::OSType OS::GetType() { return com::sun::star::setup::OSType_INVALID; }
#endif

///////////////////////////////////////////////////////////////////////////////
//		WinOS
#if defined (WIN) || defined (WNT)

class WinOS
{
public:
	static UINT32		GetFreeMemory();
	static BOOL  		ExecDDECommand(ByteString const& aReceiver, ByteString const& aCommand);

	// create shortcut
	static BOOL 		CreateShortcut( const UniString& rAbsObject, const UniString& rAbsObjectPath,
							const UniString& rAbsShortcut, const UniString& rDescription,
							const UniString& rParameter );

	// SH Interfaces laufen ueber SHGetSpecialFolderLocation (modern)
	static UniString		SHGetUserProgramFilesFolder();
	static UniString		SHGetUserProgramFolder();
	static UniString		SHGetFavoritesFolderName();
	static UniString		SHGetPersonalFolderName();
	static UniString    	SHGetTemplateFolderName();

	static UniString 		SHGetAutostartFolderName();
	static UniString		SHGetSystemDesktopFolderName();

	static BOOL				SHDoShowExtension();

	// registration database
	static long  		Register(ByteString const& rKey, ByteString const& rSubKey,
							ByteString const& rData, ByteString const& rVal, BOOL bHex, BOOL bExpand_SZ = FALSE );
	static long  		Register(ByteString const& rKey, UniString const& rSubKey,
                                 UniString const& rData, UniString const& rVal, BOOL bHex, BOOL bExpand_SZ = FALSE );
	static long			Deregister(ByteString const& rKey, ByteString const& rSubKey,
							BOOL bKeyOnly, ByteString const& rName,	BOOL bDeleteAllSubKeys);
	static long			Deregister(ByteString const& rKey, UniString const& rSubKey,
							BOOL bKeyOnly, UniString const& rName,	BOOL bDeleteAllSubKeys);
	static BOOL			IsRegistered(ByteString const& rKey, ByteString const& rSubKey,
							ByteString const& rName, BOOL bHasValue);
	static long			ClearRegEdit(ByteString const& rSubKey,
							ByteString const& rStart, ByteString const& rEnd);
	static ByteString	GetRegValue(ByteString const& rKey, ByteString const& rSubKey,
							ByteString const& rName);

	static BOOL	  		BindBinary(ByteString aBinName);
	static BOOL   		IsSourceFileNewerVersion
	(
		ByteString const& aSourceFile,
		BOOL          bPacked,
		ByteString const& aDestFile
	);

	static void			registerActiveX(const ByteString& rPath, BOOL bregister);
	static ByteString	GetOSVersion();
	static BOOL         IsNT();
	static void 		InstallShare();
	static void			Shutdown( BOOL bLogoutOnly );
	static void			PropagateEnvironmentChange();
	static BOOL			Shell_FlushIconCache();
    static BOOL         DeregisterFont( const ByteString &rFilename );

    static BOOL         PatchProductName( const SiDirEntry& rToPatch, const ByteString& rName );

    static BOOL         IsOfficeRunning( const ByteString& rInstalledPath );
};

#endif // defined (WIN) || defined (WNT)

///////////////////////////////////////////////////////////////////////////////
//		Os2OS
#ifdef OS2

#define OS2_VER_211 	211
#define OS2_VER_WARP3	230
#define OS2_VER_WARP4	240

class Os2OS
{
public:
	static USHORT	GetOSVersion();
	static ByteString	GetBootDrive();
	static void		Shutdown();

	// Um nach Shutdown das automatische Neustartren des Setups
	// zu verhindern:
	static BOOL DoesTempFileExists();
	static void KillTempFile();

	static ByteString GetFavoritesFolderName();  // cool url's

	static ByteString ReadOS2Ini(ByteString const& rAppName, ByteString const& rKey);
	static BOOL   WriteOS2Ini(ByteString const& rAppName,
						ByteString const& rKey, ByteString const& rValue);

	static ULONG  RegisterClass(ByteString const& rClass, ByteString const& rDLL);
	static ULONG  DeregisterClass(ByteString const& rClass);
	static ULONG  RegisterTemplateIcon(const ByteString& aClassID, const ByteString& aTemplateID,
									   const ByteString& aIconPath);

	static BOOL   ReplaceModule(const char* pDest, const char* pSource);

	static BOOL   DeleteTemplate(ByteString const& aTemplateID);

	static BOOL CreateFolder
	(
		ByteString const& aFolderID,    // <OFFICE_FOLDER3>
		ByteString const& aFolderName,  // "StarOffice 3.1"
		ByteString const& aOpenIcon,
		ByteString const& aCloseIcon
	);

	static BOOL CreateFolderItem
	(
		ByteString const& aFolderID,    // <OFFICE_FOLDER3>
		ByteString const& anItemID,     // <WRITER3_EXE>
		ByteString const& anItemName,   // StarWriter 3.0
		ByteString const& aClassName,   // WPStOfExe
		ByteString const& aCreater,
		ByteString const& aFile,
		ByteString const& aFilterList
	);

	static BOOL CreateFolderItem
	(
		ByteString const& aFolderID,    // <OFFICE_FOLDER3>
		ByteString const& anItemID,     // <WRITER3_EXE>
		ByteString const& anItemName,   // StarWriter 3.0
		ByteString const& aReference
	);

	static BOOL DeleteFolder(ByteString const& rFolderID);
	static BOOL IsFolderInstalled(ByteString const& rFolderID);

	static BOOL DeleteFolderItem(ByteString const& rFolderItemID);
	static BOOL IsFolderItemInstalled(ByteString const& rFolderID);

	static ByteString GetAutostartFolderID()
	{ return "WP_START"; }

	static BOOL SetFileTypeAndIcon
	(
		ByteString const& aFile,
		ByteString const& aFileType,
		ByteString const& anIcon
	);

	static BOOL JoinEAs(ByteString const& aFile, ByteString const& anEAFile);
	static BOOL IsFATFileSystem(const ByteString& rPath);

	static BOOL AddDestPathToConfigSys(BOOL bModifyCopy, ByteString const &rDestPath);
	static BOOL RemoveDestPathFromConfigSys(ByteString const &rDestPath);
};

#endif // OS2

///////////////////////////////////////////////////////////////////////////////
//		UnixOS
#ifdef UNX

struct passwd;

class UnixOS
{
	static passwd*	GetPasswdEntry( const ByteString& rUserName );
public:
	static BOOL  	IsRoot();

	static DateTime		GetDateTime(ByteString const& aFile);

	static void		SetRights(ByteString const& aFile, int nRights);
	static void		ChangeOwnerRecursive( const ByteString aPath, const ByteString& rUserName );

	static BOOL		CreateSoftLink( ByteString const& aSource, ByteString const& aDest );
	static BOOL		CreateHardLink( ByteString const& aSource, ByteString const& aDest );
	static BOOL		ConvertShellScript( SiDirEntry const& aDest, SiDirEntry const& aSource,
										ByteString const& rWorkPath, ByteString const& rProgPath );

	static BOOL		GetUserHomeDir( const ByteString& rUserName, SiDirEntry& rEntry );
	static SiDirEntry GetHomeDir(void);
	static SiDirEntry GetProfile(void);

	static ByteString	InsertLine( SiDirEntry const& aNewProfile, ByteString const& aLine );

	static char* 	p_get_localhost();
	static char* 	p_get_exechost();
	static BOOL	 	bSOfficeRemoteApplication();
	static ByteString&	rGetExecHostAction();
};

#endif

///////////////////////////////////////////////////////////////////////////////
//		MacOS
#ifdef MAC

class MacOS
{
public:
	static BOOL     AddApplication(ByteString const& rAppName);
	static ByteString   SearchApplication(ByteString Creator /* genau 4 Zeichen */);
	static BOOL     RemoveApplication(ByteString const& rAppName, ByteString Creator /* genau 4 Zeichen */);

	static BOOL		IsFloppy(ByteString const& rPath);
	static void		EjectDisk(ByteString const& rPath);

	static void		Shutdown();
	static ByteString	GetSystemVolumeName();
	static BOOL		IsKeyPressed(int nKey);
};

#endif

#endif // __SETUP_OS_HXX

