/*************************************************************************
 *
 *  $RCSfile: inetdns.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETDNS_HXX
#define _INETDNS_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif

class INetCoreDNSHostEntry;

#ifdef _USE_NAMESPACE
namespace inet 
{
#endif
	class INetDNSCache_Impl;
	class INetDNSResolver_Impl;
#ifdef _USE_NAMESPACE
}
#endif /* _USE_NAMESPACE */

/*========================================================================
 *
 * INetCoreDNSResolver Interface.
 *
 *======================================================================*/
enum INetCoreDNSResolverStatus
{
	INETCOREDNS_RESOLVER_NOTFOUND = -2,
	INETCOREDNS_RESOLVER_ERROR    = -1,
	INETCOREDNS_RESOLVER_START    =  0,
	INETCOREDNS_RESOLVER_SUCCESS  =  1,
	INETCOREDNS_RESOLVER_EXPIRED  =  2,
	INETCOREDNS_RESOLVER_NODATA   =  3
};

typedef sal_Bool INetCoreDNSCallback (
	sal_Int32             nStatus,
	INetCoreDNSHostEntry *pHostEntry,
	void                 *pData);

class INetCoreDNSResolver
{
public:
	INetCoreDNSResolver (void);
	virtual ~INetCoreDNSResolver (void);

	virtual sal_Bool GetHostName (
		INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool GetHostByName (
		INetCoreDNSHostEntry *pHostEntry,
		INetCoreDNSCallback  *pfnCallback,
		void                 *pData);

	virtual sal_Bool GetHostByAddress (
		INetCoreDNSHostEntry *pHostEntry,
		INetCoreDNSCallback  *pfnCallback,
		void                 *pData);

	virtual sal_Bool GetMailExchangerByName (
		INetCoreDNSHostEntry *pHostEntry,
		INetCoreDNSCallback  *pfnCallback,
		void                 *pData);

private:
	/** Representation.
	 */
	NAMESPACE_INET(INetDNSResolver_Impl) *m_pImpl;

	/** Not implemented.
	 */
	INetCoreDNSResolver (const INetCoreDNSResolver&);
	INetCoreDNSResolver& operator= (const INetCoreDNSResolver&);
};

/*========================================================================
 *
 * INetCoreDNSHostEntry Interface.
 *
 *======================================================================*/
class INetCoreDNSHostEntry
{
	friend class NAMESPACE_INET(INetDNSCache_Impl);
	friend class NAMESPACE_INET(INetDNSResolver_Impl);

public:
	INetCoreDNSHostEntry (
		const rtl::OUString &rDomainName, sal_uInt16 nPort = 0);

	INetCoreDNSHostEntry (
		const INetCoreDNSHostEntry& rHostEntry);
	INetCoreDNSHostEntry& operator = (
		const INetCoreDNSHostEntry& rHostEntry);

	~INetCoreDNSHostEntry (void);

	const rtl::OUString& GetDomainName        (void) const;
	const rtl::OUString& GetCanonicalName     (void) const;
	const rtl::OUString& GetDottedDecimalName (void) const;
	sal_uInt16           GetPort              (void) const;

private:
	/** Representation.
	 */
	rtl::OUString m_aDotDecName;  // "192.109.83.75"
	rtl::OUString m_aCName;       // "jaguar.stardiv.de"
	rtl::OUString m_aName;        // "www.stardiv.de"
	sal_uInt16    m_nPort;        // (host byte order)
};

inline const rtl::OUString&
INetCoreDNSHostEntry::GetDomainName (void) const
{
	return m_aName;
}

inline const rtl::OUString&
INetCoreDNSHostEntry::GetCanonicalName (void) const
{
	return m_aCName;
}

inline const rtl::OUString&
INetCoreDNSHostEntry::GetDottedDecimalName (void) const
{
	return m_aDotDecName;
}

inline sal_uInt16 INetCoreDNSHostEntry::GetPort (void) const
{
	return m_nPort;
}

#endif /* !_INETDNS_HXX */

