/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbt;
import com.sun.star.help.HelpDatabases;
import com.sun.star.help.StringDbt;
import com.sun.star.ucb.IllegalIdentifierException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class HelpURLParameter {
    private boolean m_bBerkeleyRead = false;
    private URL m_URL;
    private boolean _isStart = false;
    private String _tag = "";
    private String _id = "";
    private String _path = "";
    private String _module = "";
    private String _title = "";
    private String _jar = "";
    private String _eid = "";
    private String _defaultLanguage = "";
    private String _language = "";
    private String _prefix = "";
    private String _device = "";
    private String _program = "";
    private String _query = "";
    private String _scope = "";
    private String _system = "";
    private String _active = "";
    private int _hitCount = 100;
    String _expr;

    public HelpURLParameter(URL uRL) throws IllegalIdentifierException {
        this.m_URL = uRL;
        this.parse3();
    }

    public HelpURLParameter(URL uRL, String string) throws IllegalIdentifierException {
        this(uRL);
        this._defaultLanguage = string;
    }

    public boolean isPicture() {
        return this._module.equals("picture");
    }

    public boolean isActive() {
        return this._active.equals("true");
    }

    public boolean isQuery() {
        return this._id.equals("") && !this._query.equals("");
    }

    public boolean isEntryForModule() {
        return this._id.equals("start") || this._isStart;
    }

    public boolean isFile() {
        return !this._id.equals("");
    }

    public boolean isModule() {
        return this._id.equals("") && !this._module.equals("");
    }

    public boolean isRoot() {
        return this._module.equals("");
    }

    public String get_id() {
        if (this._id.equals("start")) {
            HelpDatabases.StaticModuleInformation staticModuleInformation = HelpDatabases.getStaticInformationForModule(this.get_module(), this.get_language());
            this._id = staticModuleInformation.get_id();
            this._isStart = true;
        }
        return this._id;
    }

    public String get_tag() {
        if (this.isFile()) {
            return this.get_the_tag();
        }
        return this._tag;
    }

    public String get_path() {
        return this.get_the_path();
    }

    public String get_eid() {
        return this._eid;
    }

    public String get_title() {
        if (this.isFile()) {
            return this.get_the_title();
        }
        if (!this._module.equals("")) {
            HelpDatabases.StaticModuleInformation staticModuleInformation = HelpDatabases.getStaticInformationForModule(this.get_module(), this.get_language());
            this._title = staticModuleInformation.get_title();
        } else {
            this._title = new String("root");
        }
        return this._title;
    }

    public String get_jar() {
        return this.get_the_jar();
    }

    public String get_module() {
        return this._module;
    }

    public String get_prefix() {
        return this._prefix;
    }

    public String get_language() {
        if (this._language.equals("")) {
            this._language = this._defaultLanguage;
        }
        return this._language;
    }

    public String get_device() {
        return this._device;
    }

    public String get_program() {
        if (this._program.equals("")) {
            HelpDatabases.StaticModuleInformation staticModuleInformation = HelpDatabases.getStaticInformationForModule(this.get_module(), this.get_language());
            this._program = staticModuleInformation.get_program();
        }
        return this._program;
    }

    public String get_query() {
        return this._query;
    }

    public String get_scope() {
        return this._scope;
    }

    public String get_system() {
        return this._system;
    }

    public int get_hitCount() {
        return this._hitCount;
    }

    public InputStream getInputFromJarFile() {
        try {
            JarEntry jarEntry;
            JarFile jarFile = HelpDatabases.getJarFileForLanguage(this.get_jar(), this.get_language());
            String string = this.get_path();
            int n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((jarEntry = jarFile.getJarEntry(string)) != null) {
                return jarFile.getInputStream(jarEntry);
            }
            return HelpDatabases.errorFile(this.get_language());
        }
        catch (Exception exception) {
            return HelpDatabases.errorFile(this.get_language());
        }
    }

    public InputStream getInputFromDisk() {
        try {
            File file;
            String string = HelpDatabases.getInstallDirectory() + HelpDatabases.lang(this.get_language()) + File.separator + this.get_path();
            int n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((file = new File(string)).exists()) {
                return new FileInputStream(file);
            }
            System.out.println("File not found from disk: " + this.get_path());
            return HelpDatabases.errorFile(this.get_language());
        }
        catch (Exception exception) {
            return HelpDatabases.errorFile(this.get_language());
        }
    }

    public byte[] getByteArrayText() {
        try {
            Db db = HelpDatabases.getHelptextDbForLanguage(this.get_module(), this.get_language());
            StringDbt stringDbt = new StringDbt(this._id);
            StringDbt stringDbt2 = new StringDbt();
            int n = db.get(null, (Dbt)stringDbt, (Dbt)stringDbt2, 0);
            if (stringDbt2 != null) {
                try {
                    return stringDbt2.getString().getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return stringDbt2.getString().getBytes();
                }
            }
            return new byte[0];
        }
        catch (DbException dbException) {
            System.out.println("No database for language: HelpURLParameter._readBerkeley");
            return new byte[0];
        }
    }

    private String get_the_tag() {
        if (!this.m_bBerkeleyRead) {
            this._readBerkeley();
        }
        this.m_bBerkeleyRead = true;
        return this._tag;
    }

    private String get_the_path() {
        if (!this.m_bBerkeleyRead) {
            this._readBerkeley();
        }
        this.m_bBerkeleyRead = true;
        return this._path;
    }

    private String get_the_title() {
        if (!this.m_bBerkeleyRead) {
            this._readBerkeley();
        }
        this.m_bBerkeleyRead = true;
        return this._title;
    }

    private String get_the_jar() {
        if (!this.m_bBerkeleyRead) {
            this._readBerkeley();
        }
        this.m_bBerkeleyRead = true;
        return this._jar;
    }

    public int isEqualTo(HelpURLParameter helpURLParameter) {
        return this.get_module().equals(helpURLParameter.get_module()) && this.get_id().equals(helpURLParameter.get_id()) && this.get_language().equals(helpURLParameter.get_language()) && this.get_device().equals(helpURLParameter.get_device()) && this.get_program().equals(helpURLParameter.get_program()) && this.get_query().equals(helpURLParameter.get_query()) && this.get_scope().equals(helpURLParameter.get_scope()) && this.get_system().equals(helpURLParameter.get_system()) && this.get_hitCount() == helpURLParameter.get_hitCount() ? 1 : 0;
    }

    private void _readBerkeley() {
        if (!this.get_id().equals("")) {
            try {
                Db db = HelpDatabases.getDatabaseForLanguage(this.get_module(), this.get_language());
                StringDbt stringDbt = new StringDbt(this._id);
                StringDbt stringDbt2 = new StringDbt();
                int n = db.get(null, (Dbt)stringDbt, (Dbt)stringDbt2, 0);
                if (stringDbt2 != null) {
                    this._title = stringDbt2.getTitle();
                    this._path = stringDbt2.getFile();
                    this._jar = stringDbt2.getDatabase();
                    this._tag = stringDbt2.getHash();
                }
            }
            catch (DbException dbException) {
                System.out.println("No database for language: HelpURLParameter._readBerkeley");
            }
        }
    }

    void parse3() throws IllegalIdentifierException {
        this._expr = this.m_URL.toExternalForm();
        int n = this._expr.lastIndexOf(35);
        if (n != -1) {
            this._expr = this._expr.substring(0, n);
        }
        if (!(this.scheme() && this.name(this.module()) && this.query())) {
            throw new IllegalIdentifierException(this.m_URL.toExternalForm());
        }
    }

    boolean scheme() {
        boolean bl;
        boolean bl2 = bl = this._expr != null;
        if (bl && this._expr.startsWith("vnd.sun.star.help://")) {
            this._expr = this._expr.substring("vnd.sun.star.help://".length());
            return true;
        }
        if (bl && this._expr.startsWith("vnd.sun.star.help:/")) {
            this._expr = this._expr.substring("vnd.sun.star.help:/".length());
            return true;
        }
        if (bl && this._expr.startsWith("vnd.sun.star.help:")) {
            this._expr = this._expr.substring("vnd.sun.star.help:".length());
            return true;
        }
        return false;
    }

    boolean module() {
        int n = 0;
        int n2 = this._expr.length();
        while (n < n2 && Character.isLetterOrDigit(this._expr.charAt(n))) {
            ++n;
        }
        if (n != 0) {
            this._module = this._expr.substring(0, n);
            this._expr = this._expr.substring(n);
            return true;
        }
        return false;
    }

    boolean name(boolean bl) {
        int n = this._expr.length();
        if (n != 0 && this._expr.charAt(0) == '/') {
            int n2 = 1;
            while (n2 < n && Character.isLetterOrDigit(this._expr.charAt(n2))) {
                ++n2;
            }
            if (n2 != 1 && !bl) {
                return false;
            }
            this._id = this._expr.substring(1, n2);
            this._expr = this._expr.substring(n2);
        }
        return true;
    }

    boolean query() {
        String string = "";
        if (this._expr == null || this._expr.length() == 0) {
            return true;
        }
        if (this._expr.charAt(0) != '?') {
            return false;
        }
        string = this._expr.substring(1).trim();
        boolean bl = true;
        while (string.length() != 0) {
            String string2;
            int n = string.indexOf(38);
            int n2 = string.indexOf(61);
            String string3 = string.substring(0, n2).trim();
            if (n == -1) {
                string2 = string.substring(n2 + 1).trim();
                string = new String();
            } else {
                string2 = string.substring(n2 + 1, n).trim();
                string = string.substring(n + 1).trim();
            }
            if ("Language".equals(string3)) {
                this._language = string2;
                continue;
            }
            if ("Device".equals(string3)) {
                this._device = string2;
                continue;
            }
            if ("Program".equals(string3)) {
                this._program = string2;
                continue;
            }
            if ("Eid".equals(string3)) {
                this._eid = string2;
                continue;
            }
            if ("Language".equals(string3)) {
                this._language = string2;
                continue;
            }
            if ("Query".equals(string3)) {
                if (this._query == null) {
                    this._query = string2;
                    continue;
                }
                this._query = this._query + " " + string2;
                continue;
            }
            if ("Scope".equals(string3)) {
                this._scope = string2;
                continue;
            }
            if ("System".equals(string3)) {
                this._system = string2;
                continue;
            }
            if ("HelpPrefix".equals(string3)) {
                this._prefix = string2;
                continue;
            }
            if ("HitCount".equals(string3)) {
                this._hitCount = Integer.decode(string2);
                continue;
            }
            if ("Active".equals(string3)) {
                this._active = string2;
                continue;
            }
            bl = false;
        }
        return bl;
    }
}

