/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.IThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.JavaThreadPool;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaThreadPoolFactory
implements IThreadPoolFactory {
    private static final boolean DEBUG = false;
    protected Hashtable _jobQueues = new Hashtable();

    synchronized void list() {
        Enumeration enumeration = this._jobQueues.elements();
        System.err.println("##### JavaThreadPoolFactory.list:");
        while (enumeration.hasMoreElements()) {
            System.err.println(" - " + enumeration.nextElement());
        }
    }

    public ThreadId getThreadId(Thread thread) {
        ThreadId threadId = null;
        if (thread instanceof JobQueue.JobDispatcher) {
            threadId = ((JobQueue.JobDispatcher)thread).getThreadId();
        } else {
            try {
                threadId = new ThreadId(UnoRuntime.generateOid(thread).getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("JavaThreadPool.getThreadId - unexpected: " + unsupportedEncodingException.toString());
            }
        }
        return threadId;
    }

    public ThreadId getThreadId() {
        return this.getThreadId(Thread.currentThread());
    }

    void addJobQueue(JobQueue jobQueue) {
        this._jobQueues.put(jobQueue.getThreadId(), jobQueue);
    }

    JobQueue getJobQueue(ThreadId threadId) {
        return (JobQueue)this._jobQueues.get(threadId);
    }

    void removeJobQueue(JobQueue jobQueue) {
        this._jobQueues.remove(jobQueue.getThreadId());
    }

    JobQueue getAsyncJobQueue(ThreadId threadId) {
        JobQueue jobQueue = (JobQueue)this._jobQueues.get(threadId);
        JobQueue jobQueue2 = null;
        if (jobQueue != null) {
            jobQueue2 = jobQueue._async_jobQueue;
        }
        return jobQueue2;
    }

    public IThreadPool createThreadPool() {
        return new JavaThreadPool(this);
    }

    void dispose(Object object, Throwable throwable) {
        Enumeration enumeration = this._jobQueues.elements();
        while (enumeration.hasMoreElements()) {
            ((JobQueue)enumeration.nextElement()).dispose(object, throwable);
        }
    }
}

