/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.indexer;

import com.sun.xmlsearch.util.Configuration;
import com.sun.xmlsearch.util.ExtensibleURLStreamHandlerFactory;
import com.sun.xmlsearch.util.PrefixTranslator;
import com.sun.xmlsearch.xml.indexer.XmlIndexBuilder;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlIndexer {
    private boolean _verbose = true;

    private void configure(Element element) throws Exception {
        ConfigurationData configurationData = new ConfigurationData();
        configurationData.process(element);
    }

    private Vector findXmlFiles(String string, String string2) {
        Vector vector = new Vector();
        this.findXmlFiles(new File(string), string2, vector);
        return vector;
    }

    private void findXmlFiles(File file, String string, Vector vector) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isDirectory()) {
                    this.findXmlFiles(file2, string, vector);
                } else if (file2.isFile() && stringArray[n].endsWith(string)) {
                    vector.addElement(file2);
                }
                ++n;
            }
        }
    }

    public static void process(Element element) throws Exception {
        new XmlIndexer().configure(element);
    }

    public static void main(String[] stringArray) {
        try {
            ExtensibleURLStreamHandlerFactory extensibleURLStreamHandlerFactory = new ExtensibleURLStreamHandlerFactory();
            extensibleURLStreamHandlerFactory.setHandler("star", "com.sun.xmlsearch.util.StarURLStreamHandler");
            URL.setURLStreamHandlerFactory(extensibleURLStreamHandlerFactory);
            Element element = Configuration.configElementFromArgs(stringArray);
            if (element != null) {
                XmlIndexer.process(element);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final class ConfigurationData {
        private Element _root;
        private Hashtable _toAdd = new Hashtable();
        private Hashtable _toRefresh = new Hashtable();
        private Hashtable _toRemove = new Hashtable();

        private ConfigurationData() {
        }

        public void process(Element element) throws Exception {
            this._root = element;
            String string = element.getAttribute("index");
            String string2 = element.getAttribute("action");
            String string3 = element.getAttribute("transform");
            String string4 = element.getAttribute("transformLocation");
            XmlIndexBuilder xmlIndexBuilder = new XmlIndexBuilder(string);
            if (string4.length() > 0) {
                xmlIndexBuilder.setTransformLocation(string4);
            }
            if ("create".equals(string2)) {
                xmlIndexBuilder.clearIndex();
            }
            if (xmlIndexBuilder.init(string3)) {
                this.processDirectories(xmlIndexBuilder);
                xmlIndexBuilder.close();
            }
        }

        private void processDirectories(XmlIndexBuilder xmlIndexBuilder) throws Exception {
            NodeList nodeList = this._root.getElementsByTagName("IndexDirectory");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element = (Element)nodeList.item(n);
                String string = element.getAttribute("directory");
                String string2 = element.getAttribute("extension");
                if (string2 == null) {
                    string2 = ".xml";
                }
                boolean bl = "yes".equals(element.getAttribute("recurse"));
                Vector vector = XmlIndexer.this.findXmlFiles(string, string2);
                if (vector.size() > 0) {
                    String[] stringArray = Configuration.processPrefixTranslations(element);
                    PrefixTranslator prefixTranslator = PrefixTranslator.makePrefixTranslator(stringArray);
                    xmlIndexBuilder.setPrefixTranslator(prefixTranslator);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        File file = (File)enumeration.nextElement();
                        URL uRL = file.toURL();
                        System.out.println("Indexing: " + uRL);
                        xmlIndexBuilder.indexDocument(uRL, "xml");
                    }
                    xmlIndexBuilder.setPrefixTranslator(null);
                }
                ++n;
            }
        }

        private void prepareSets(Element element) {
            NodeList nodeList = element.getElementsByTagName("Document");
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getAttribute("file");
                String string2 = element2.getAttribute("action");
                if (string2.equals("add")) {
                    if (this._toRefresh.get(string) == null) {
                        this._toAdd.put(string, string);
                    }
                    if (XmlIndexer.this._verbose && this._toRemove.remove(string) != null) {
                        System.out.println("remove/add " + string);
                    }
                } else if (string2.equals("remove")) {
                    this._toRemove.put(string, string);
                    if (XmlIndexer.this._verbose && this._toAdd.remove(string) != null) {
                        System.out.println("add/remove " + string);
                    }
                    if (XmlIndexer.this._verbose && this._toRefresh.remove(string) != null) {
                        System.out.println("refresh/remove " + string);
                    }
                } else if (string2.equals("refresh")) {
                    this._toRefresh.put(string, string);
                    if (XmlIndexer.this._verbose && this._toRemove.remove(string) != null) {
                        System.out.println("remove/refresh " + string);
                    }
                    if (XmlIndexer.this._verbose && this._toAdd.remove(string) != null) {
                        System.out.println("add/refresh " + string);
                    }
                }
                ++n;
            }
        }

        private void updateIndex(XmlIndexBuilder xmlIndexBuilder) throws Exception {
            xmlIndexBuilder.updateIndex(this._toRemove, this._toRefresh, this._toAdd);
        }
    }
}

