import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XSet;

import org.OpenOffice.XInstanceInspector;

import java.io.DataInputStream;

public class Test {
  public static void main(String args[]) {
    try {
      String sConnectionString = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";

      // It is possible to use a different connection string, passed as argument
      if ( args.length == 1 ) {
            sConnectionString = args[0];
      }
      
      /* Bootstraps a component context with the jurt base components
         registered. Component context to be granted to a component for running.
         Arbitrary values can be retrieved from the context. */
      XComponentContext xcomponentcontext =
      com.sun.star.comp.helper.Bootstrap.createInitialComponentContext( null );
      
      /* Gets the service manager instance to be used (or null). This method has
         been added for convenience, because the service manager is a often used
         object. */
      XMultiComponentFactory xmulticomponentfactory =
      xcomponentcontext.getServiceManager();
      
      /* Creates an instance of the component UnoUrlResolver which
         supports the services specified by the factory. */
      Object objectUrlResolver =
      xmulticomponentfactory.createInstanceWithContext(
      "com.sun.star.bridge.UnoUrlResolver", xcomponentcontext );
      
      // Create a new url resolver
      XUnoUrlResolver xurlresolver = ( XUnoUrlResolver )
      UnoRuntime.queryInterface( XUnoUrlResolver.class,
      objectUrlResolver );
      
      /* Resolves an object that is specified as follow:
         uno:<connection description>;<protocol description>;<initial object name>
       */
      Object objectInitial = xurlresolver.resolve( sConnectionString );
      
      // Create a service manager from the initial object
      xmulticomponentfactory = ( XMultiComponentFactory )
      UnoRuntime.queryInterface( XMultiComponentFactory.class,
      objectInitial );
      
      // Query for the XPropertySet interface.
      XPropertySet xpropertysetMultiComponentFactory = ( XPropertySet )
      UnoRuntime.queryInterface( XPropertySet.class, xmulticomponentfactory );
      
      // Get the default context from the office server.
      Object objectDefaultContext =
      xpropertysetMultiComponentFactory.getPropertyValue( "DefaultContext" );
      
      // Query for the interface XComponentContext.
      xcomponentcontext = ( XComponentContext ) UnoRuntime.queryInterface(
      XComponentContext.class, objectDefaultContext );
      
      /* A desktop environment contains tasks with one or more
         frames in which components can be loaded. Desktop is the
         environment for components which can instanciate within
         frames. */
      XComponentLoader xcomponentloader = ( XComponentLoader )
      UnoRuntime.queryInterface( XComponentLoader.class,
      xmulticomponentfactory.createInstanceWithContext(
      "com.sun.star.frame.Desktop", xcomponentcontext ) );
      
      // Load a Writer document, which will be automaticly displayed
      XComponent xcomponent = xcomponentloader.loadComponentFromURL(
      "private:factory/scalc", "_blank", 0,
      new PropertyValue[0] );
      
      // Querying for the interface XSet on the XMultiServiceFactory
      XSet xsetMultiComponentFactory = ( XSet ) UnoRuntime.queryInterface(
      XSet.class, xmulticomponentfactory );
      
      // Getting the single service factory of the instance inspector
      XSingleServiceFactory xsingleservicefactoryInstanceInspector =
      InstanceInspector.__getServiceFactory(
      "InstanceInspector$_InstanceInspector", ( XMultiServiceFactory )
      UnoRuntime.queryInterface( XMultiServiceFactory.class,
      xmulticomponentfactory ), null );
      
      // Inserting the single service factory into the multi service factory
      xsetMultiComponentFactory.insert( xsingleservicefactoryInstanceInspector );
      
      // Creating an instance of the instance inspector with arguments
      Object objectInstanceInspector =
      xmulticomponentfactory.createInstanceWithArgumentsAndContext(
      "org.OpenOffice.InstanceInspector",
      new Object[]{ xmulticomponentfactory }, xcomponentcontext );
      
      // Create a new instance inspector
      XInstanceInspector xinstanceinspector = ( XInstanceInspector )
      UnoRuntime.queryInterface( XInstanceInspector.class,
      objectInstanceInspector );
      
      // Inspect the calc
      xinstanceinspector.inspect( xcomponent );
      
      // Remove instance inspector from the container
      xsetMultiComponentFactory.remove( xsingleservicefactoryInstanceInspector );    

      System.out.println("\nPlease inspect the new spreadsheet document component." +
                         " Press RETURN to exit");
      DataInputStream inputStream = new DataInputStream(System.in);
      inputStream.read();
      // dispose the created document component
      xcomponent.dispose();
      
      System.exit( 0 );
    }
    catch( Exception exception ) {
      System.err.println( exception );
    }
  }
}
