'\"
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH "Safe Tcl" n 8.0 Tcl "Tcl Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
safe \- Creating and manipulating safe interpreters
.SH SYNOPSIS
.nf
\fB::safe::interpCreate\fR ?\fIchild\fR? ?\fIoptions...\fR?
\fB::safe::interpInit\fI child\fR ?\fIoptions...\fR?
\fB::safe::interpConfigure\fI child\fR ?\fIoptions...\fR?
\fB::safe::interpDelete\fI child\fR
\fB::safe::interpAddToAccessPath\fI child directory\fR
\fB::safe::interpFindInAccessPath\fI child directory\fR
\fB::safe::setSyncMode\fR ?\fInewValue\fR?
\fB::safe::setLogCmd\fR ?\fIcmd arg...\fR?
.fi
.SS OPTIONS
.nf
?\fB\-accessPath\fI pathList\fR?
?\fB\-autoPath\fI pathList\fR?
?\fB\-statics\fI boolean\fR?
?\fB\-noStatics\fR?
?\fB\-nested\fI boolean\fR?
?\fB\-nestedLoadOk\fR?
?\fB\-deleteHook\fI script\fR?
.fi
.BE
.SH DESCRIPTION
Safe Tcl is a mechanism for executing untrusted Tcl scripts
safely and for providing mediated access by such scripts to
potentially dangerous functionality.
.PP
Safe Tcl ensures that untrusted Tcl scripts cannot harm the
hosting application.
It prevents integrity and privacy attacks. Untrusted Tcl
scripts are prevented from corrupting the state of the hosting
application or computer. Untrusted scripts are also prevented from
disclosing information stored on the hosting computer or in the
hosting application to any party.
.PP
Safe Tcl allows a parent interpreter to create safe, restricted
interpreters that contain a set of predefined aliases for the \fBsource\fR,
\fBload\fR, \fBfile\fR, \fBencoding\fR, and \fBexit\fR commands and
are able to use the auto-loading and package mechanisms.
.PP
No knowledge of the file system structure is leaked to the
safe interpreter, because it has access only to a virtualized path
containing tokens. When the safe interpreter requests to source a file, it
uses the token in the virtual path as part of the file name to source; the
parent interpreter transparently
translates the token into a real directory name and executes the
requested operation (see the section \fBSECURITY\fR below for details).
Different levels of security can be selected by using the optional flags
of the commands described below.
.PP
All commands provided in the parent interpreter by Safe Tcl reside in
the \fBsafe\fR namespace.
.SH COMMANDS
The following commands are provided in the parent interpreter:
.\" COMMAND: interpCreate
.TP
\fB::safe::interpCreate\fR ?\fIchild\fR? ?\fIoptions...\fR?
.
Creates a safe interpreter, installs the aliases described in the section
\fBALIASES\fR and initializes the auto-loading and package mechanism as
specified by the supplied \fIoptions\fR.
See the \fBOPTIONS\fR section below for a description of the
optional arguments.
If the \fIchild\fR argument is omitted, a name will be generated.
\fB::safe::interpCreate\fR always returns the interpreter name.
.RS
.PP
The interpreter name \fIchild\fR may include namespace separators,
but may not have leading or trailing namespace separators, or excess
colon characters in namespace separators.  The interpreter name is
qualified relative to the global namespace ::, not the namespace in which
the \fB::safe::interpCreate\fR command is evaluated.
.RE
.\" COMMAND: interpInit
.TP
\fB::safe::interpInit\fI child\fR ?\fIoptions...\fR?
.
This command is similar to \fBinterpCreate\fR except it that does not
create the safe interpreter. \fIchild\fR must have been created by some
other means, like \fBinterp create\fR \fB\-safe\fR.  The interpreter
name \fIchild\fR may include namespace separators, subject to the same
restrictions as for \fBinterpCreate\fR.
.\" COMMAND: interpConfigure
.TP
\fB::safe::interpConfigure\fI child\fR ?\fIoptions...\fR?
.
If no \fIoptions\fR are given, returns the settings for all options for the
named safe interpreter as a list of options and their current values
for that \fIchild\fR.
If a single additional argument is provided,
it will return a list of 2 elements \fIname\fR and \fIvalue\fR where
\fIname\fR is the full name of that option and \fIvalue\fR the current value
for that option and the \fIchild\fR.
If more than two additional arguments are provided, it will reconfigure the
safe interpreter and change each and only the provided options.
See the section on \fBOPTIONS\fR below for options description.
Example of use:
.RS
.PP
.CS
# Create new interp with the same configuration as "$i0":
set i1 [safe::interpCreate {*}[safe::interpConfigure $i0]]

# Get the current deleteHook
set dh [safe::interpConfigure $i0  -del]

# Change (only) the statics loading ok attribute of an
# interp and its deleteHook (leaving the rest unchanged):
safe::interpConfigure $i0  -delete {foo bar} -statics 0
.CE
.RE
.\" COMMAND: interpDelete
.TP
\fB::safe::interpDelete\fI child\fR
.
Deletes the safe interpreter and cleans up the corresponding
parent interpreter data structures.
If a \fIdeleteHook\fR script was specified for this interpreter it is
evaluated before the interpreter is deleted, with the name of the
interpreter as an additional argument.
.\" COMMAND: interpFindInAccessPath
.TP
\fB::safe::interpFindInAccessPath\fI child directory\fR
.
This command finds and returns the token for the real directory
\fIdirectory\fR in the safe interpreter's current virtual access path.
It generates an error if the directory is not found.
Example of use:
.RS
.PP
.CS
$child eval [list set tk_library \e
      [::safe::interpFindInAccessPath $name $tk_library]]
.CE
.RE
.\" COMMAND: interpAddToAccessPath
.TP
\fB::safe::interpAddToAccessPath\fI child directory\fR
.
This command adds \fIdirectory\fR to the virtual path maintained for the
safe interpreter in the parent, and returns the token that can be used in
the safe interpreter to obtain access to files in that directory.
If the directory is already in the virtual path, it only returns the token
without adding the directory to the virtual path again.
Example of use:
.RS
.PP
.CS
$child eval [list set tk_library \e
      [::safe::interpAddToAccessPath $name $tk_library]]
.CE
.RE
.\" COMMAND: setSyncMode
.TP
\fB::safe::setSyncMode\fR ?\fInewValue\fR?
.
This command is used to get or set the "Sync Mode" of the Safe Base.
When an argument is supplied, the command returns an error if the argument
is not a boolean value, or if any Safe Base interpreters exist.  Typically
the value will be set as part of initialization - boolean true for
"Sync Mode" on (the default), false for "Sync Mode" off.  With "Sync Mode"
on, the Safe Base keeps each child interpreter's ::auto_path synchronized
with its access path.  See the section \fBSYNC MODE\fR below for details.
.\" COMMAND: setLogCmd
.TP
\fB::safe::setLogCmd\fR ?\fIcmd arg...\fR?
.
This command installs a script that will be called when interesting
life cycle events occur for a safe interpreter.
When called with no arguments, it returns the currently installed script.
When called with one argument, an empty string, the currently installed
script is removed and logging is turned off.
The script will be invoked with one additional argument, a string
describing the event of interest.
The main purpose is to help in debugging safe interpreters.
Using this facility you can get complete error messages while the safe
interpreter gets only generic error messages.
This prevents a safe interpreter from seeing messages about failures
and other events that might contain sensitive information such as real
directory names.
.RS
.PP
Example of use:
.PP
.CS
::safe::setLogCmd puts stderr
.CE
.PP
Below is the output of a sample session in which a safe interpreter
attempted to source a file not found in its virtual access path.
Note that the safe interpreter only received an error message saying that
the file was not found:
.PP
.CS
NOTICE for child interp10 : Created
NOTICE for child interp10 : Setting accessPath=(/foo/bar) staticsok=1 nestedok=0 deletehook=()
NOTICE for child interp10 : auto_path in interp10 has been set to {$p(:0:)}
ERROR for child interp10 : /foo/bar/init.tcl: no such file or directory
.CE
.RE
.SS OPTIONS
The following options are common to
\fB::safe::interpCreate\fR, \fB::safe::interpInit\fR,
and \fB::safe::interpConfigure\fR.
Any option name can be abbreviated to its minimal
non-ambiguous name.
Option names are not case sensitive.
.\" OPTION: -accessPath
.TP
\fB\-accessPath\fI directoryList\fR
.
This option sets the list of directories from which the safe interpreter
can \fBsource\fR and \fBload\fR files.
If this option is not specified, or if it is given as the
empty list, the safe interpreter will use the same directories as its
parent for auto-loading.
See the section \fBSECURITY\fR below for more detail about virtual paths,
tokens and access control.
.\" OPTION: -autoPath
.TP
\fB\-autoPath\fI directoryList\fR
.
This option sets the list of directories in the safe interpreter's
::auto_path.  The option is undefined if the Safe Base has "Sync Mode" on
- in that case the safe interpreter's ::auto_path is managed by the Safe
Base and is a tokenized form of its access path.
See the section \fBSYNC MODE\fR below for details.
.\" OPTION: -statics
.TP
\fB\-statics\fI boolean\fR
.
This option specifies if the safe interpreter will be allowed
to load statically linked packages (like \fBload {} Tk\fR).
The default value is \fBtrue\fR :
safe interpreters are allowed to load statically linked packages.
.\" OPTION: -noStatics
.TP
\fB\-noStatics\fR
.
This option is a convenience shortcut for \fB\-statics false\fR and
thus specifies that the safe interpreter will not be allowed
to load statically linked packages.
.\" OPTION: -nested
.TP
\fB\-nested\fI boolean\fR
.
This option specifies if the safe interpreter will be allowed
to load packages into its own sub-interpreters.
The default value is \fBfalse\fR :
safe interpreters are not allowed to load packages into
their own sub-interpreters.
.\" OPTION: -nestedLoadOk
.TP
\fB\-nestedLoadOk\fR
.
This option is a convenience shortcut for \fB\-nested true\fR and
thus specifies the safe interpreter will be allowed
to load packages into its own sub-interpreters.
.\" OPTION: -deleteHook
.TP
\fB\-deleteHook\fI script\fR
.
When this option is given a non-empty \fIscript\fR, it will be
evaluated in the parent with the name of
the safe interpreter as an additional argument
just before actually deleting the safe interpreter.
Giving an empty value removes any currently installed deletion hook
script for that safe interpreter.
The default value (\fB{}\fR) is not to have any deletion call back.
.SH ALIASES
The following aliases are provided in a safe interpreter:
.TP
\fBsource\fI fileName\fR
.
The requested file, a Tcl source file, is sourced into the safe interpreter
if it is found.
The \fBsource\fR alias can only source files from directories in
the virtual path for the safe interpreter. The \fBsource\fR alias requires
the safe interpreter to
use one of the token names in its virtual path to denote the directory in
which the file to be sourced can be found.
See the section on \fBSECURITY\fR for more discussion of restrictions on
valid filenames.
.TP
\fBload\fI fileName\fR
.
The requested file, a shared object file, is dynamically loaded into the
safe interpreter if it is found.
The filename must contain a token name mentioned in the virtual path for
the safe interpreter for it to be found successfully.
Additionally, the shared object file must contain a safe entry point; see
the manual page for the \fBload\fR command for more details.
.TP
\fBfile\fR ?\fIsubcommand args...\fR?
.
The \fBfile\fR alias provides access to a safe subset of the subcommands of
the \fBfile\fR command; it allows only \fBdirname\fR, \fBjoin\fR,
\fBextension\fR, \fBroot\fR, \fBtail\fR, \fBpathtype\fR and \fBsplit\fR
subcommands. For more details on what these subcommands do see the manual
page for the \fBfile\fR command.
.TP
\fBencoding\fR ?\fIsubcommand args...\fR?
.
The \fBencoding\fR alias provides access to a safe subset of the
subcommands of the \fBencoding\fR command;  it disallows setting of
the system encoding, but allows all other subcommands including
\fBsystem\fR to check the current encoding.
.TP
\fBexit\fR
.
The calling interpreter is deleted and its computation is stopped, but the
Tcl process in which this interpreter exists is not terminated.
.SH SECURITY
Safe Tcl does not attempt to completely prevent annoyance and
denial of service attacks. These forms of attack prevent the
application or user from temporarily using the computer to perform
useful work, for example by consuming all available CPU time or
all available screen real estate.
These attacks, while aggravating, are deemed to be of lesser importance
in general than integrity and privacy attacks that Safe Tcl
is to prevent.
.PP
The commands available in a safe interpreter, in addition to
the safe set as defined in \fBinterp\fR manual page, are mediated aliases
for \fBsource\fR, \fBload\fR, \fBexit\fR, and safe subsets of
\fBfile\fR and \fBencoding\fR. The safe interpreter can also auto-load
code and it can request that packages be loaded.
.PP
Because some of these commands access the local file system, there is a
potential for information leakage about its directory structure.
To prevent this, commands that take file names as arguments in a safe
interpreter use tokens instead of the real directory names.
These tokens are translated to the real directory name while a request to,
e.g., source a file is mediated by the parent interpreter.
This virtual path system is maintained in the parent interpreter for each safe
interpreter created by \fB::safe::interpCreate\fR or initialized by
\fB::safe::interpInit\fR and
the path maps tokens accessible in the safe interpreter into real path
names on the local file system thus preventing safe interpreters
from gaining knowledge about the
structure of the file system of the host on which the interpreter is
executing.
The only valid file names arguments
for the \fBsource\fR and \fBload\fR aliases provided to the child
are path in the form of
\fB[file join \fItoken filename\fB]\fR (i.e. when using the
native file path formats: \fItoken\fB/\fIfilename\fR
on Unix and \fItoken\fB\e\fIfilename\fR on Windows),
where \fItoken\fR is representing one of the directories
of the \fIaccessPath\fR list and \fIfilename\fR is
one file in that directory (no sub directories access are allowed).
.PP
When a token is used in a safe interpreter in a request to source or
load a file, the token is checked and
translated to a real path name and the file to be
sourced or loaded is located on the file system.
The safe interpreter never gains knowledge of the actual path name under
which the file is stored on the file system.
.PP
To further prevent potential information leakage from sensitive files that
are accidentally included in the set of files that can be sourced by a safe
interpreter, the \fBsource\fR alias restricts access to files
meeting the following constraints: the file name must
fourteen characters or shorter, must not contain more than one dot
.PQ \fB.\fR "" ,
must end up with the extension
.PQ \fB.tcl\fR
or be called
.PQ \fBtclIndex\fR .
.PP
Each element of the initial access path
list will be assigned a token that will be set in
the child \fBauto_path\fR and the first element of that list will be set as
the \fBtcl_library\fR for that child.
.PP
If the access path argument is not given to \fB::safe::interpCreate\fR or
\fB::safe::interpInit\fR or is the empty list,
the default behavior is to let the child access the same packages
as the parent has access to (Or to be more precise:
only packages written in Tcl (which by definition cannot be dangerous
as they run in the child interpreter) and C extensions that
provides a _SafeInit entry point). For that purpose, the parent's
\fBauto_path\fR will be used to construct the child access path.
In order that the child successfully loads the Tcl library files
(which includes the auto-loading mechanism itself) the \fBtcl_library\fR will be
added or moved to the first position if necessary, in the
child access path, so the child
\fBtcl_library\fR will be the same as the parent's (its real
path will still be invisible to the child though).
In order that auto-loading works the same for the child and
the parent in this by default case, the first-level
sub directories of each directory in the parent \fBauto_path\fR will
also be added (if not already included) to the child access path.
You can always specify a more
restrictive path for which sub directories will never be searched by
explicitly specifying your directory list with the \fB\-accessPath\fR flag
instead of relying on this default mechanism.
.PP
When the \fIaccessPath\fR is changed after the first creation or
initialization (i.e. through \fBinterpConfigure -accessPath \fR\fIlist\fR),
an \fBauto_reset\fR is automatically evaluated in the safe interpreter
to synchronize its \fBauto_index\fR with the new token list.
.SH TYPICAL USE
In many cases, the properties of a Safe Base interpreter can be specified
when the interpreter is created, and then left unchanged for the lifetime
of the interpreter.
.PP
If you wish to use Safe Base interpreters with "Sync Mode" off, evaluate
the command
.RS
.PP
.CS
 safe::setSyncMode 0
.CE
.RE
.PP
Use \fB::safe::interpCreate\fR or \fB::safe::interpInit\fR to create an
interpreter with the properties that you require.  The simplest way is not
to specify \fB\-accessPath\fR or \fB\-autoPath\fR, which means the safe
interpreter will use the same paths as the parent interpreter.  However,
if \fB\-accessPath\fR is specified, then \fB\-autoPath\fR must also be
specified, or else it will be set to {}.
.PP
The value of \fB\-autoPath\fR will be that required to access tclIndex
and pkgIndex.tcl files according to the same rules as an unsafe
interpreter (see pkg_mkIndex(n) and library(n)).
.PP
With "Sync Mode" on, the option \fB\-autoPath\fR is undefined, and
the Safe Base sets the child's ::auto_path to a tokenized form of the
access path. In addition to the directories present if "Safe Mode" is off,
the ::auto_path includes the numerous subdirectories and module paths
that belong to the access path.
.SH SYNC MODE
Before Tcl version 9.0, the Safe Base kept each safe interpreter's
::auto_path synchronized with a tokenized form of its access path.
Limitations of Tcl 8.4 and earlier made this feature necessary.  This
definition of ::auto_path did not conform its specification in library(n)
and pkg_mkIndex(n), but nevertheless worked perfectly well for the discovery
and loading of packages.  The introduction of Tcl modules in Tcl 8.5 added a
large number of directories to the access path, and it is inconvenient to
have these additional directories unnecessarily appended to the ::auto_path.
.PP
In order to preserve compatibility with existing code, this synchronization
of the ::auto_path and access path ("Sync Mode" on) is still the default.
However, the Safe Base offers the option of limiting the safe interpreter's
::auto_path to the much shorter list of directories that is necessary for
it to perform its function ("Sync Mode" off).  Use the command
\fB::safe::setSyncMode\fR to choose the mode before creating any Safe
Base interpreters.
.PP
In either mode, the most convenient way to initialize a safe interpreter is
to call \fB::safe::interpCreate\fR or \fB::safe::interpInit\fR without the
\fB\-accessPath\fR or \fB\-autoPath\fR options (or with the \fB\-accessPath\fR
option set to the
empty list), which will give the safe interpreter the same access as the
parent interpreter to packages, modules, and autoloader files.  With
"Sync Mode" off, the Safe Base will set the value of \fB\-autoPath\fR to the
parent's ::auto_path, and will set the child's ::auto_path to a tokenized form
of the parent's ::auto_path.
.PP
With "Sync Mode" off, if a value is specified for \fB\-autoPath\fR, even the
empty list, in a call to \fB::safe::interpCreate\fR, \fB::safe::interpInit\fR,
or \fB::safe::interpConfigure\fR, it will be tokenized and used as the safe
interpreter's ::auto_path.  Any directories that do not also belong to the
access path cannot be tokenized and will be silently ignored.  However, the
value of \fB\-autoPath\fR will remain as specified, and will be used to
re-tokenize the child's ::auto_path if \fB::safe::interpConfigure\fR is called
to change the value of \fB\-accessPath\fR.
.PP
With "Sync Mode" off, if the access path is reset to the values in the
parent interpreter by calling \fB::safe::interpConfigure\fR with arguments
\fB\-accessPath\fR {}, then the ::auto_path will also be reset unless the
argument \fB\-autoPath\fR is supplied to specify a different value.
.PP
With "Sync Mode" off, if a non-empty value of \fB\-accessPath\fR is supplied, the
safe interpreter's ::auto_path will be set to {} (by
\fB::safe::interpCreate\fR, \fB::safe::interpInit\fR) or left unchanged
(by \fB::safe::interpConfigure\fR).  If the same command specifies a new
value for \fB\-autoPath\fR, it will be applied after the \fB\-accessPath\fR
argument has been processed.
.PP
Examples of use with "Sync Mode" off: any of these commands will set the
::auto_path to a tokenized form of its value in the parent interpreter:
.RS
.PP
.CS
safe::interpCreate foo
safe::interpCreate foo -accessPath {}
safe::interpInit bar
safe::interpInit bar -accessPath {}
safe::interpConfigure foo -accessPath {}
.CE
.RE
.PP
Example of use with "Sync Mode" off: when initializing a safe interpreter
with a non-empty access path, the ::auto_path will be set to {} unless its
own value is also specified:
.RS
.PP
.CS
safe::interpCreate foo -accessPath {
    /usr/local/TclHome/lib/tcl9.0
    /usr/local/TclHome/lib/tcl9.0/http1.0
    /usr/local/TclHome/lib/tcl9.0/opt0.4
    /usr/local/TclHome/lib/tcl9.0/msgs
    /usr/local/TclHome/lib/tcl9.0/encoding
    /usr/local/TclHome/lib
}

# The child's ::auto_path must be given a suitable value:

safe::interpConfigure foo -autoPath {
    /usr/local/TclHome/lib/tcl9.0
    /usr/local/TclHome/lib
}

# The two commands can be combined:

safe::interpCreate foo -accessPath {
    /usr/local/TclHome/lib/tcl9.0
    /usr/local/TclHome/lib/tcl9.0/http1.0
    /usr/local/TclHome/lib/tcl9.0/opt0.4
    /usr/local/TclHome/lib/tcl9.0/msgs
    /usr/local/TclHome/lib/tcl9.0/encoding
    /usr/local/TclHome/lib
} -autoPath {
    /usr/local/TclHome/lib/tcl9.0
    /usr/local/TclHome/lib
}
.CE
.RE
.PP
Example of use with "Sync Mode" off: the command
\fBsafe::interpAddToAccessPath\fR does not change the safe interpreter's
::auto_path, and so any necessary change must be made by the script:
.RS
.PP
.CS
safe::interpAddToAccessPath foo /usr/local/TclHome/lib/extras/Img1.4.11

lassign [safe::interpConfigure foo -autoPath] DUM childAutoPath
lappend childAutoPath /usr/local/TclHome/lib/extras/Img1.4.11
safe::interpConfigure foo -autoPath $childAutoPath
.CE
.RE
.SH "SEE ALSO"
interp(n), library(n), load(n), package(n), pkg_mkIndex(n), source(n),
tm(n), unknown(n)
.SH KEYWORDS
alias, auto-loading, auto_mkindex, load, parent interpreter, safe
interpreter, child interpreter, source
'\" Local Variables:
'\" mode: nroff
'\" End:
