<?php
/**
 * TelegrafsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * TelegrafsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TelegrafsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteTelegrafsID
     *
     * Delete a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTelegrafsID($telegraf_id, $zap_trace_span = null)
    {
        $this->deleteTelegrafsIDWithHttpInfo($telegraf_id, $zap_trace_span);
    }

    /**
     * Operation deleteTelegrafsIDWithHttpInfo
     *
     * Delete a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTelegrafsIDWithHttpInfo($telegraf_id, $zap_trace_span = null)
    {
        $request = $this->deleteTelegrafsIDRequest($telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTelegrafsID'
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTelegrafsIDRequest($telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling deleteTelegrafsID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTelegrafsIDLabelsID
     *
     * Delete a label from a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTelegrafsIDLabelsID($telegraf_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteTelegrafsIDLabelsIDWithHttpInfo($telegraf_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteTelegrafsIDLabelsIDWithHttpInfo
     *
     * Delete a label from a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTelegrafsIDLabelsIDWithHttpInfo($telegraf_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteTelegrafsIDLabelsIDRequest($telegraf_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTelegrafsIDLabelsID'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $label_id The label ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTelegrafsIDLabelsIDRequest($telegraf_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling deleteTelegrafsIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteTelegrafsIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTelegrafsIDMembersID
     *
     * Remove a member from a Telegraf config
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTelegrafsIDMembersID($user_id, $telegraf_id, $zap_trace_span = null)
    {
        $this->deleteTelegrafsIDMembersIDWithHttpInfo($user_id, $telegraf_id, $zap_trace_span);
    }

    /**
     * Operation deleteTelegrafsIDMembersIDWithHttpInfo
     *
     * Remove a member from a Telegraf config
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTelegrafsIDMembersIDWithHttpInfo($user_id, $telegraf_id, $zap_trace_span = null)
    {
        $request = $this->deleteTelegrafsIDMembersIDRequest($user_id, $telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTelegrafsIDMembersID'
     *
     * @param  string $user_id The ID of the member to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTelegrafsIDMembersIDRequest($user_id, $telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteTelegrafsIDMembersID'
            );
        }
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling deleteTelegrafsIDMembersID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/members/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteTelegrafsIDOwnersID
     *
     * Remove an owner from a Telegraf config
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteTelegrafsIDOwnersID($user_id, $telegraf_id, $zap_trace_span = null)
    {
        $this->deleteTelegrafsIDOwnersIDWithHttpInfo($user_id, $telegraf_id, $zap_trace_span);
    }

    /**
     * Operation deleteTelegrafsIDOwnersIDWithHttpInfo
     *
     * Remove an owner from a Telegraf config
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTelegrafsIDOwnersIDWithHttpInfo($user_id, $telegraf_id, $zap_trace_span = null)
    {
        $request = $this->deleteTelegrafsIDOwnersIDRequest($user_id, $telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteTelegrafsIDOwnersID'
     *
     * @param  string $user_id The ID of the owner to remove. (required)
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteTelegrafsIDOwnersIDRequest($user_id, $telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteTelegrafsIDOwnersID'
            );
        }
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling deleteTelegrafsIDOwnersID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/owners/{userID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'userID' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }
        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTelegrafs
     *
     * List all Telegraf configurations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id The organization ID the Telegraf config belongs to. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Telegrafs|\InfluxDB2\Model\Error
     */
    public function getTelegrafs($zap_trace_span = null, $org_id = null)
    {
        list($response) = $this->getTelegrafsWithHttpInfo($zap_trace_span, $org_id);
        return $response;
    }

    /**
     * Operation getTelegrafsWithHttpInfo
     *
     * List all Telegraf configurations
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id The organization ID the Telegraf config belongs to. (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Telegrafs|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTelegrafsWithHttpInfo($zap_trace_span = null, $org_id = null)
    {
        $request = $this->getTelegrafsRequest($zap_trace_span, $org_id);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Telegrafs';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTelegrafs'
     *
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $org_id The organization ID the Telegraf config belongs to. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTelegrafsRequest($zap_trace_span = null, $org_id = null)
    {

        $resourcePath = '/api/v2/telegrafs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTelegrafsID
     *
     * Retrieve a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept accept (optional, default to 'application/toml')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|\InfluxDB2\Model\Error
     */
    public function getTelegrafsID($telegraf_id, $zap_trace_span = null, $accept = 'application/toml')
    {
        list($response) = $this->getTelegrafsIDWithHttpInfo($telegraf_id, $zap_trace_span, $accept);
        return $response;
    }

    /**
     * Operation getTelegrafsIDWithHttpInfo
     *
     * Retrieve a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept (optional, default to 'application/toml')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTelegrafsIDWithHttpInfo($telegraf_id, $zap_trace_span = null, $accept = 'application/toml')
    {
        $request = $this->getTelegrafsIDRequest($telegraf_id, $zap_trace_span, $accept);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTelegrafsID'
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $accept (optional, default to 'application/toml')
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTelegrafsIDRequest($telegraf_id, $zap_trace_span = null, $accept = 'application/toml')
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling getTelegrafsID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($accept !== null) {
            $headerParams['Accept'] = ObjectSerializer::toHeaderValue($accept);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/toml', 'application/json', 'application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/toml', 'application/json', 'application/octet-stream'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTelegrafsIDLabels
     *
     * List all labels for a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getTelegrafsIDLabels($telegraf_id, $zap_trace_span = null)
    {
        list($response) = $this->getTelegrafsIDLabelsWithHttpInfo($telegraf_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTelegrafsIDLabelsWithHttpInfo
     *
     * List all labels for a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTelegrafsIDLabelsWithHttpInfo($telegraf_id, $zap_trace_span = null)
    {
        $request = $this->getTelegrafsIDLabelsRequest($telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTelegrafsIDLabels'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTelegrafsIDLabelsRequest($telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling getTelegrafsIDLabels'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTelegrafsIDMembers
     *
     * List all users with member privileges for a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error
     */
    public function getTelegrafsIDMembers($telegraf_id, $zap_trace_span = null)
    {
        list($response) = $this->getTelegrafsIDMembersWithHttpInfo($telegraf_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTelegrafsIDMembersWithHttpInfo
     *
     * List all users with member privileges for a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMembers|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTelegrafsIDMembersWithHttpInfo($telegraf_id, $zap_trace_span = null)
    {
        $request = $this->getTelegrafsIDMembersRequest($telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMembers';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTelegrafsIDMembers'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTelegrafsIDMembersRequest($telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling getTelegrafsIDMembers'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getTelegrafsIDOwners
     *
     * List all owners of a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error
     */
    public function getTelegrafsIDOwners($telegraf_id, $zap_trace_span = null)
    {
        list($response) = $this->getTelegrafsIDOwnersWithHttpInfo($telegraf_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getTelegrafsIDOwnersWithHttpInfo
     *
     * List all owners of a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwners|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTelegrafsIDOwnersWithHttpInfo($telegraf_id, $zap_trace_span = null)
    {
        $request = $this->getTelegrafsIDOwnersRequest($telegraf_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwners';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getTelegrafsIDOwners'
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getTelegrafsIDOwnersRequest($telegraf_id, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling getTelegrafsIDOwners'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTelegrafs
     *
     * Create a Telegraf configuration
     *
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Telegraf|\InfluxDB2\Model\Error
     */
    public function postTelegrafs($telegraf_plugin_request, $zap_trace_span = null)
    {
        list($response) = $this->postTelegrafsWithHttpInfo($telegraf_plugin_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTelegrafsWithHttpInfo
     *
     * Create a Telegraf configuration
     *
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Telegraf|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTelegrafsWithHttpInfo($telegraf_plugin_request, $zap_trace_span = null)
    {
        $request = $this->postTelegrafsRequest($telegraf_plugin_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Telegraf';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTelegrafs'
     *
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration to create (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTelegrafsRequest($telegraf_plugin_request, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_plugin_request' is set
        if ($telegraf_plugin_request === null || (is_array($telegraf_plugin_request) && count($telegraf_plugin_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_plugin_request when calling postTelegrafs'
            );
        }

        $resourcePath = '/api/v2/telegrafs';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($telegraf_plugin_request)) {
            $_tempBody = $telegraf_plugin_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTelegrafsIDLabels
     *
     * Add a label to a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postTelegrafsIDLabels($telegraf_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postTelegrafsIDLabelsWithHttpInfo($telegraf_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTelegrafsIDLabelsWithHttpInfo
     *
     * Add a label to a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTelegrafsIDLabelsWithHttpInfo($telegraf_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postTelegrafsIDLabelsRequest($telegraf_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTelegrafsIDLabels'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTelegrafsIDLabelsRequest($telegraf_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling postTelegrafsIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postTelegrafsIDLabels'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTelegrafsIDMembers
     *
     * Add a member to a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error
     */
    public function postTelegrafsIDMembers($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postTelegrafsIDMembersWithHttpInfo($telegraf_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTelegrafsIDMembersWithHttpInfo
     *
     * Add a member to a Telegraf config
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceMember|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTelegrafsIDMembersWithHttpInfo($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postTelegrafsIDMembersRequest($telegraf_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceMember';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTelegrafsIDMembers'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as member (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTelegrafsIDMembersRequest($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling postTelegrafsIDMembers'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postTelegrafsIDMembers'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/members';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postTelegrafsIDOwners
     *
     * Add an owner to a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error
     */
    public function postTelegrafsIDOwners($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        list($response) = $this->postTelegrafsIDOwnersWithHttpInfo($telegraf_id, $add_resource_member_request_body, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postTelegrafsIDOwnersWithHttpInfo
     *
     * Add an owner to a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\ResourceOwner|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postTelegrafsIDOwnersWithHttpInfo($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        $request = $this->postTelegrafsIDOwnersRequest($telegraf_id, $add_resource_member_request_body, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\ResourceOwner';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postTelegrafsIDOwners'
     *
     * @param  string $telegraf_id The Telegraf configuration ID. (required)
     * @param  \InfluxDB2\Model\AddResourceMemberRequestBody $add_resource_member_request_body User to add as owner (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postTelegrafsIDOwnersRequest($telegraf_id, $add_resource_member_request_body, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling postTelegrafsIDOwners'
            );
        }
        // verify the required parameter 'add_resource_member_request_body' is set
        if ($add_resource_member_request_body === null || (is_array($add_resource_member_request_body) && count($add_resource_member_request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_resource_member_request_body when calling postTelegrafsIDOwners'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}/owners';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($add_resource_member_request_body)) {
            $_tempBody = $add_resource_member_request_body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putTelegrafsID
     *
     * Update a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Telegraf|\InfluxDB2\Model\Error
     */
    public function putTelegrafsID($telegraf_id, $telegraf_plugin_request, $zap_trace_span = null)
    {
        list($response) = $this->putTelegrafsIDWithHttpInfo($telegraf_id, $telegraf_plugin_request, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putTelegrafsIDWithHttpInfo
     *
     * Update a Telegraf configuration
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Telegraf|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putTelegrafsIDWithHttpInfo($telegraf_id, $telegraf_plugin_request, $zap_trace_span = null)
    {
        $request = $this->putTelegrafsIDRequest($telegraf_id, $telegraf_plugin_request, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Telegraf';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putTelegrafsID'
     *
     * @param  string $telegraf_id The Telegraf config ID. (required)
     * @param  \InfluxDB2\Model\TelegrafPluginRequest $telegraf_plugin_request Telegraf configuration update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putTelegrafsIDRequest($telegraf_id, $telegraf_plugin_request, $zap_trace_span = null)
    {
        // verify the required parameter 'telegraf_id' is set
        if ($telegraf_id === null || (is_array($telegraf_id) && count($telegraf_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_id when calling putTelegrafsID'
            );
        }
        // verify the required parameter 'telegraf_plugin_request' is set
        if ($telegraf_plugin_request === null || (is_array($telegraf_plugin_request) && count($telegraf_plugin_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $telegraf_plugin_request when calling putTelegrafsID'
            );
        }

        $resourcePath = '/api/v2/telegrafs/{telegrafID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($telegraf_id !== null) {
            $resourcePath = str_replace(
                '{' . 'telegrafID' . '}',
                ObjectSerializer::toPathValue($telegraf_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($telegraf_plugin_request)) {
            $_tempBody = $telegraf_plugin_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
