/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class DoubleCache {
    private static final double[] EMPTY_DOUBLES = new double[0];
    private static final int[] EMPTY_INTS = new int[0];
    private double[] keyTable = EMPTY_DOUBLES;
    private int[] valueTable = EMPTY_INTS;
    private int elementSize = 0;

    public void clear() {
        this.elementSize = 0;
        this.keyTable = EMPTY_DOUBLES;
        this.valueTable = EMPTY_INTS;
    }

    public boolean containsKey(double key) {
        if (key == 0.0) {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == 0.0) {
                    long value1 = Double.doubleToLongBits(key);
                    long value2 = Double.doubleToLongBits(this.keyTable[i]);
                    if (value1 == Long.MIN_VALUE && value2 == Long.MIN_VALUE) {
                        return true;
                    }
                    if (value1 == 0L && value2 == 0L) {
                        return true;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == key) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int putIfAbsent(double key, int value) {
        if (key == 0.0) {
            long value1 = Double.doubleToLongBits(key);
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                long value2;
                if (this.keyTable[i] == 0.0 && value1 == (value2 = Double.doubleToLongBits(this.keyTable[i]))) {
                    return this.valueTable[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            int max = this.elementSize;
            while (i < max) {
                if (this.keyTable[i] == key) {
                    return this.valueTable[i];
                }
                ++i;
            }
        }
        if (this.elementSize == this.keyTable.length) {
            int newSize = Math.max(13, this.elementSize * 2);
            this.keyTable = new double[newSize];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[newSize];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = key;
        this.valueTable[this.elementSize] = value;
        ++this.elementSize;
        return -value;
    }

    public String toString() {
        int max = this.elementSize;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int i = 0;
        while (i < max) {
            if (this.keyTable[i] != 0.0 || this.keyTable[i] == 0.0 && this.valueTable[i] != 0) {
                buf.append(this.keyTable[i]).append("->").append(this.valueTable[i]);
            }
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

