/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / -1.3333333333333333lf) => dvec4(1.2375lf, -0.9975lf, -1.4475lf, -0.5700000000000001lf)
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / 0.85lf) => dvec4(-1.9411764705882353lf, 1.5647058823529414lf, 2.2705882352941176lf, 0.8941176470588236lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / -1.3333333333333333lf) => dvec4(-0.6000000000000001lf, 0.1125lf, 0.3825lf, -0.0lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / 0.85lf) => dvec4(0.9411764705882354lf, -0.17647058823529413lf, -0.6lf, 0.0lf)
 */
#version 400

void main()
{
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / -1.3333333333333333lf), dvec4(1.2375lf, -0.9975lf, -1.4475lf, -0.5700000000000001lf)) <= 2.2240882963587578e-05lf ? 1 : -1] array0;
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) / 0.85lf), dvec4(-1.9411764705882353lf, 1.5647058823529414lf, 2.2705882352941176lf, 0.8941176470588236lf)) <= 3.4887659550725605e-05lf ? 1 : -1] array1;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / -1.3333333333333333lf), dvec4(-0.6000000000000001lf, 0.1125lf, 0.3825lf, -0.0lf)) <= 7.203905190936373e-06lf ? 1 : -1] array2;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) / 0.85lf), dvec4(0.9411764705882354lf, -0.17647058823529413lf, -0.6lf, 0.0lf)) <= 1.1300243436762937e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
