/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 & (~ abs(ivec3(-36, 32, -88)))) => ivec3(8, 12, 4)
 * (12 & (~ abs(ivec3(36, 32, 88)))) => ivec3(8, 12, 4)
 * (12 & (~ abs(ivec3(59, 77, 68)))) => ivec3(4, 0, 8)
 * (-6 & (~ abs(ivec3(-36, 32, -88)))) => ivec3(-38, -38, -94)
 * (-6 & (~ abs(ivec3(36, 32, 88)))) => ivec3(-38, -38, -94)
 * (-6 & (~ abs(ivec3(59, 77, 68)))) => ivec3(-64, -78, -70)
 * (76 & (~ abs(ivec3(-36, 32, -88)))) => ivec3(72, 76, 4)
 * (76 & (~ abs(ivec3(36, 32, 88)))) => ivec3(72, 76, 4)
 * (76 & (~ abs(ivec3(59, 77, 68)))) => ivec3(68, 0, 8)
 * (-32 & (~ abs(ivec3(-36, 32, -88)))) => ivec3(-64, -64, -96)
 * (-32 & (~ abs(ivec3(36, 32, 88)))) => ivec3(-64, -64, -96)
 * (-32 & (~ abs(ivec3(59, 77, 68)))) => ivec3(-64, -96, -96)
 * (0 & (~ abs(ivec3(-36, 32, -88)))) => ivec3(0, 0, 0)
 * (0 & (~ abs(ivec3(36, 32, 88)))) => ivec3(0, 0, 0)
 * (0 & (~ abs(ivec3(59, 77, 68)))) => ivec3(0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((12 & (~ abs(ivec3(-36, 32, -88)))), ivec3(8, 12, 4))) ? 1 : -1] array0;
  float[all(equal((12 & (~ abs(ivec3(36, 32, 88)))), ivec3(8, 12, 4))) ? 1 : -1] array1;
  float[all(equal((12 & (~ abs(ivec3(59, 77, 68)))), ivec3(4, 0, 8))) ? 1 : -1] array2;
  float[all(equal((-6 & (~ abs(ivec3(-36, 32, -88)))), ivec3(-38, -38, -94))) ? 1 : -1] array3;
  float[all(equal((-6 & (~ abs(ivec3(36, 32, 88)))), ivec3(-38, -38, -94))) ? 1 : -1] array4;
  float[all(equal((-6 & (~ abs(ivec3(59, 77, 68)))), ivec3(-64, -78, -70))) ? 1 : -1] array5;
  float[all(equal((76 & (~ abs(ivec3(-36, 32, -88)))), ivec3(72, 76, 4))) ? 1 : -1] array6;
  float[all(equal((76 & (~ abs(ivec3(36, 32, 88)))), ivec3(72, 76, 4))) ? 1 : -1] array7;
  float[all(equal((76 & (~ abs(ivec3(59, 77, 68)))), ivec3(68, 0, 8))) ? 1 : -1] array8;
  float[all(equal((-32 & (~ abs(ivec3(-36, 32, -88)))), ivec3(-64, -64, -96))) ? 1 : -1] array9;
  float[all(equal((-32 & (~ abs(ivec3(36, 32, 88)))), ivec3(-64, -64, -96))) ? 1 : -1] array10;
  float[all(equal((-32 & (~ abs(ivec3(59, 77, 68)))), ivec3(-64, -96, -96))) ? 1 : -1] array11;
  float[all(equal((0 & (~ abs(ivec3(-36, 32, -88)))), ivec3(0, 0, 0))) ? 1 : -1] array12;
  float[all(equal((0 & (~ abs(ivec3(36, 32, 88)))), ivec3(0, 0, 0))) ? 1 : -1] array13;
  float[all(equal((0 & (~ abs(ivec3(59, 77, 68)))), ivec3(0, 0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
