/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(-5) => -1
 * sign(-2) => -1
 * sign(-1) => -1
 * sign(0) => 0
 * sign(1) => 1
 * sign(2) => 1
 * sign(5) => 1
 */
#version 130

void main()
{
  float[sign(-5) == -1 ? 1 : -1] array0;
  float[sign(-2) == -1 ? 1 : -1] array1;
  float[sign(-1) == -1 ? 1 : -1] array2;
  float[sign(0) == 0 ? 1 : -1] array3;
  float[sign(1) == 1 ? 1 : -1] array4;
  float[sign(2) == 1 ? 1 : -1] array5;
  float[sign(5) == 1 ? 1 : -1] array6;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
