/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> uvec3(22u, 23u, 4u)) => i64vec3(-317891438803l, 0l, 5l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> uvec3(19u, 1u, 13u)) => i64vec3(-2543131510417l, 42l, 0l)
 * (i64vec3(167l, 66l, 187l) >> uvec3(22u, 23u, 4u)) => i64vec3(0l, 0l, 11l)
 * (i64vec3(167l, 66l, 187l) >> uvec3(19u, 1u, 13u)) => i64vec3(0l, 33l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> uvec3(22u, 23u, 4u)), i64vec3(-317891438803l, 0l, 5l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> uvec3(19u, 1u, 13u)), i64vec3(-2543131510417l, 42l, 0l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(167l, 66l, 187l) >> uvec3(22u, 23u, 4u)), i64vec3(0l, 0l, 11l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(167l, 66l, 187l) >> uvec3(19u, 1u, 13u)), i64vec3(0l, 33l, 0l))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
