/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tomcat.util.res.StringManager;

public class ToStringUtil {
    private static final StringManager sm = StringManager.getManager(ToStringUtil.class);
    private static final String INDENT = "    ";

    private ToStringUtil() {
    }

    public static String classPathForCNFE(ClassLoader classLoader) {
        StringBuilder result = new StringBuilder(4096);
        result.append(sm.getString("toStringUtil.classpath.header"));
        result.append("\n");
        while (classLoader != null) {
            ToStringUtil.classPathForCNFE(classLoader, result);
            classLoader = classLoader.getParent();
        }
        return result.toString();
    }

    private static void classPathForCNFE(ClassLoader classLoader, StringBuilder result) {
        result.append(INDENT);
        result.append(sm.getString("toStringUtil.classpath.classloader", classLoader));
        result.append("\n");
        if (classLoader instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)classLoader).getURLs()) {
                result.append(INDENT);
                result.append(INDENT);
                result.append(url);
                result.append("\n");
            }
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            String cp = System.getProperty("java.class.path");
            if (cp != null && cp.length() > 0) {
                String[] paths;
                for (String path : paths = cp.split(File.pathSeparator)) {
                    result.append(INDENT);
                    result.append(INDENT);
                    result.append(path);
                    result.append("\n");
                }
            }
        } else if (classLoader == ClassLoader.getSystemClassLoader().getParent()) {
            result.append(INDENT);
            result.append(INDENT);
            result.append(sm.getString("toStringUtil.classpath.platform"));
            result.append("\n");
        } else {
            result.append(INDENT);
            result.append(INDENT);
            result.append(sm.getString("toStringUtil.classpath.unknown"));
            result.append("\n");
        }
    }
}

