/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.observe.ObserveRelation;

public class ObservingEndpoint {
    private final InetSocketAddress address;
    private final List<ObserveRelation> relations;

    public ObservingEndpoint(InetSocketAddress address) {
        this.address = address;
        this.relations = new CopyOnWriteArrayList<ObserveRelation>();
    }

    public void addObserveRelation(ObserveRelation relation) {
        this.relations.add(relation);
    }

    public void removeObserveRelation(ObserveRelation relation) {
        this.relations.remove(relation);
    }

    public void cancelAll() {
        for (ObserveRelation relation : this.relations) {
            relation.cancel();
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ObserveRelation getObserveRelation(Token token) {
        if (token != null) {
            for (ObserveRelation relation : this.relations) {
                if (!token.equals((Object)relation.getExchange().getRequest().getToken())) continue;
                return relation;
            }
        }
        return null;
    }
}

