/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.TabularData;
import org.apache.karaf.instance.core.Instance;
import org.apache.karaf.instance.core.InstanceService;
import org.apache.karaf.instance.core.InstanceSettings;
import org.apache.karaf.instance.core.InstancesMBean;
import org.apache.karaf.instance.core.internal.InstanceToTableMapper;

public class InstancesMBeanImpl
extends StandardMBean
implements InstancesMBean {
    static final String DEBUG_OPTS = " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005";
    static final String DEFAULT_OPTS = "-server -Xmx512m";
    private InstanceService instanceService;

    public InstancesMBeanImpl(InstanceService instanceService) throws NotCompliantMBeanException {
        super(InstancesMBean.class);
        this.instanceService = instanceService;
    }

    @Override
    public int createInstance(String name, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, String features, String featuresURLs) throws MBeanException {
        return this.createInstance(name, sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, features, featuresURLs, "localhost");
    }

    @Override
    public int createInstance(String name, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts, String features, String featureURLs, String address) throws MBeanException {
        try {
            InstanceSettings settings;
            Instance inst;
            if ("".equals(location)) {
                location = null;
            }
            if ("".equals(javaOpts)) {
                javaOpts = null;
            }
            if ((inst = this.instanceService.createInstance(name, settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, this.parseStringList(featureURLs), this.parseStringList(features), address), false)) != null) {
                return inst.getPid();
            }
            return -1;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void packageInstance(String name, String destination) throws MBeanException {
        try {
            this.getExistingInstance(name).packageInZip(destination);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void changeSshPort(String name, int port) throws MBeanException {
        try {
            this.getExistingInstance(name).changeSshPort(port);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void changeSshHost(String name, String host) throws MBeanException {
        try {
            this.getExistingInstance(name).changeSshHost(host);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void changeRmiRegistryPort(String name, int port) throws MBeanException {
        try {
            this.getExistingInstance(name).changeRmiRegistryPort(port);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void changeRmiServerPort(String name, int port) throws MBeanException {
        try {
            this.getExistingInstance(name).changeRmiServerPort(port);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void changeJavaOpts(String name, String javaOpts) throws MBeanException {
        try {
            this.getExistingInstance(name).changeJavaOpts(javaOpts);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void destroyInstance(String name) throws MBeanException {
        try {
            this.getExistingInstance(name).destroy();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void startInstance(String name) throws MBeanException {
        try {
            this.getExistingInstance(name).start(null);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void startInstance(String name, String opts) throws MBeanException {
        try {
            this.getExistingInstance(name).start(opts);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void startInstance(String name, String opts, boolean wait, boolean debug) throws MBeanException {
        try {
            Instance child = this.getExistingInstance(name);
            String options = opts;
            if (options == null) {
                options = child.getJavaOpts();
            }
            if (options == null) {
                options = DEFAULT_OPTS;
            }
            if (debug) {
                options = options + DEBUG_OPTS;
            }
            if (wait) {
                String state = child.getState();
                if ("Stopped".equals(state)) {
                    child.start(opts);
                }
                if (!"Started".equals(state)) {
                    do {
                        Thread.sleep(500L);
                    } while ("Starting".equals(state = child.getState()));
                }
            } else {
                child.start(opts);
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void stopInstance(String name) throws MBeanException {
        try {
            this.getExistingInstance(name).stop();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void renameInstance(String originalName, String newName) throws MBeanException {
        try {
            this.instanceService.renameInstance(originalName, newName, false);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void renameInstance(String originalName, String newName, boolean verbose) throws MBeanException {
        try {
            this.instanceService.renameInstance(originalName, newName, verbose);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void cloneInstance(String name, String cloneName, int sshPort, int rmiRegistryPort, int rmiServerPort, String location, String javaOpts) throws MBeanException {
        try {
            if ("".equals(location)) {
                location = null;
            }
            if ("".equals(javaOpts)) {
                javaOpts = null;
            }
            InstanceSettings settings = new InstanceSettings(sshPort, rmiRegistryPort, rmiServerPort, location, javaOpts, null, null);
            this.instanceService.cloneInstance(name, cloneName, settings, false);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public TabularData getInstances() throws MBeanException {
        List<Instance> instances = Arrays.asList(this.instanceService.getInstances());
        TabularData table = InstanceToTableMapper.tableFrom(instances);
        return table;
    }

    private Instance getExistingInstance(String name) {
        Instance i = this.instanceService.getInstance(name);
        if (i == null) {
            throw new IllegalArgumentException("Instance '" + name + "' does not exist");
        }
        return i;
    }

    private List<String> parseStringList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (String el : value.split(",")) {
                String trimmed = el.trim();
                if (trimmed.length() == 0) continue;
                list.add(trimmed);
            }
        }
        return list;
    }
}

