/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.model.EncryptedDataKey;

public class EncryptionMaterials {
    private final AlgorithmSuiteInfo algorithmSuite;
    private final Map<String, String> encryptionContext;
    private final List<EncryptedDataKey> encryptedDataKeys;
    private final List<String> requiredEncryptionContextKeys;
    private final ByteBuffer plaintextDataKey;
    private final ByteBuffer signingKey;
    private final List<ByteBuffer> symmetricSigningKeys;

    protected EncryptionMaterials(BuilderImpl builder) {
        this.algorithmSuite = builder.algorithmSuite();
        this.encryptionContext = builder.encryptionContext();
        this.encryptedDataKeys = builder.encryptedDataKeys();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
        this.plaintextDataKey = builder.plaintextDataKey();
        this.signingKey = builder.signingKey();
        this.symmetricSigningKeys = builder.symmetricSigningKeys();
    }

    public AlgorithmSuiteInfo algorithmSuite() {
        return this.algorithmSuite;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<EncryptedDataKey> encryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public ByteBuffer plaintextDataKey() {
        return this.plaintextDataKey;
    }

    public ByteBuffer signingKey() {
        return this.signingKey;
    }

    public List<ByteBuffer> symmetricSigningKeys() {
        return this.symmetricSigningKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteInfo algorithmSuite;
        protected Map<String, String> encryptionContext;
        protected List<EncryptedDataKey> encryptedDataKeys;
        protected List<String> requiredEncryptionContextKeys;
        protected ByteBuffer plaintextDataKey;
        protected ByteBuffer signingKey;
        protected List<ByteBuffer> symmetricSigningKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(EncryptionMaterials model) {
            this.algorithmSuite = model.algorithmSuite();
            this.encryptionContext = model.encryptionContext();
            this.encryptedDataKeys = model.encryptedDataKeys();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
            this.plaintextDataKey = model.plaintextDataKey();
            this.signingKey = model.signingKey();
            this.symmetricSigningKeys = model.symmetricSigningKeys();
        }

        @Override
        public Builder algorithmSuite(AlgorithmSuiteInfo algorithmSuite) {
            this.algorithmSuite = algorithmSuite;
            return this;
        }

        @Override
        public AlgorithmSuiteInfo algorithmSuite() {
            return this.algorithmSuite;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder encryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
            this.encryptedDataKeys = encryptedDataKeys;
            return this;
        }

        @Override
        public List<EncryptedDataKey> encryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public Builder plaintextDataKey(ByteBuffer plaintextDataKey) {
            this.plaintextDataKey = plaintextDataKey;
            return this;
        }

        @Override
        public ByteBuffer plaintextDataKey() {
            return this.plaintextDataKey;
        }

        @Override
        public Builder signingKey(ByteBuffer signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        @Override
        public ByteBuffer signingKey() {
            return this.signingKey;
        }

        @Override
        public Builder symmetricSigningKeys(List<ByteBuffer> symmetricSigningKeys) {
            this.symmetricSigningKeys = symmetricSigningKeys;
            return this;
        }

        @Override
        public List<ByteBuffer> symmetricSigningKeys() {
            return this.symmetricSigningKeys;
        }

        @Override
        public EncryptionMaterials build() {
            if (Objects.isNull(this.algorithmSuite())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuite`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.encryptedDataKeys())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedDataKeys`");
            }
            if (Objects.isNull(this.requiredEncryptionContextKeys())) {
                throw new IllegalArgumentException("Missing value for required field `requiredEncryptionContextKeys`");
            }
            return new EncryptionMaterials(this);
        }
    }

    public static interface Builder {
        public Builder algorithmSuite(AlgorithmSuiteInfo var1);

        public AlgorithmSuiteInfo algorithmSuite();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder encryptedDataKeys(List<EncryptedDataKey> var1);

        public List<EncryptedDataKey> encryptedDataKeys();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public Builder plaintextDataKey(ByteBuffer var1);

        public ByteBuffer plaintextDataKey();

        public Builder signingKey(ByteBuffer var1);

        public ByteBuffer signingKey();

        public Builder symmetricSigningKeys(List<ByteBuffer> var1);

        public List<ByteBuffer> symmetricSigningKeys();

        public EncryptionMaterials build();
    }
}

