/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.ExperimentVariant;

public class ExperimentVariantDao {
    @Generated
    private static final Logger log = LogManager.getLogger(ExperimentVariantDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    public ExperimentVariantDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.EXPERIMENT_VARIANT, stepListener);
    }

    public void putExperimentVariant(ExperimentVariant experimentVariant, ActionListener listener) {
        if (Objects.isNull(experimentVariant)) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(experimentVariant.getId(), experimentVariant.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment variant", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void putExperimentVariantEfficient(ExperimentVariant experimentVariant, ActionListener listener) {
        if (Objects.isNull(experimentVariant)) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDocEfficient(experimentVariant.getId(), experimentVariant.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment variant", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateExperimentVariant(ExperimentVariant experimentVariant, ActionListener listener) {
        if (experimentVariant == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment variant cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDoc(experimentVariant.getId(), experimentVariant.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment variant", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateExperimentVariantEfficient(ExperimentVariant experimentVariant, ActionListener listener) {
        if (experimentVariant == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Experiment variant cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDocEfficient(experimentVariant.getId(), experimentVariant.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store experiment variant", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteExperimentVariant(String experimentVariantId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(experimentVariantId, SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
    }

    public void deleteExperimentVariantByExperimentId(String experimentId, ActionListener<BulkByScrollResponse> listener) {
        this.searchRelevanceIndicesManager.deleteByQuery(experimentId, "experimentId", SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
    }

    public SearchResponse getExperiment(String experimentVariantId, ActionListener<SearchResponse> listener) {
        if (experimentVariantId == null || experimentVariantId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("experimentVariantId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(experimentVariantId, SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
    }

    public SearchResponse listExperimentVariant(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.EXPERIMENT_VARIANT, listener);
    }
}

