/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    @Deprecated
    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.keyData.getKeyFingerprint(), this.keyData.getKeyID());
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 3) {
            byte[] plain = dataDecryptorFactory.recoverSessionData(this.keyData, this.encData);
            return plain[0];
        }
        if (this.keyData.getVersion() == 6) {
            return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + this.keyData.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        int algorithm;
        byte[] sessionInfo = dataDecryptorFactory.recoverSessionData(this.keyData, this.encData);
        if (this.containsChecksum(this.keyData.getAlgorithm())) {
            if (!this.confirmCheckSum(sessionInfo)) {
                throw new PGPException("Key checksum failed.");
            }
            sessionInfo = Arrays.copyOf((byte[])sessionInfo, (int)(sessionInfo.length - 2));
        }
        byte[] sessionKey = Arrays.copyOfRange((byte[])sessionInfo, (int)1, (int)sessionInfo.length);
        if (this.encData instanceof AEADEncDataPacket) {
            algorithm = ((AEADEncDataPacket)this.encData).getAlgorithm();
            return new PGPSessionKey(algorithm & 0xFF, sessionKey);
        } else if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)this.encData;
            if (seipd.getVersion() == 1) {
                algorithm = sessionInfo[0];
                return new PGPSessionKey(algorithm & 0xFF, sessionKey);
            } else {
                if (seipd.getVersion() != 2) throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + seipd.getVersion());
                algorithm = seipd.getCipherAlgorithm();
            }
            return new PGPSessionKey(algorithm & 0xFF, sessionKey);
        } else {
            algorithm = sessionInfo[0];
        }
        return new PGPSessionKey(algorithm & 0xFF, sessionKey);
    }

    private boolean containsChecksum(int algorithm) {
        return algorithm != 25 && algorithm != 26;
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, this.getSessionKey(dataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (sessionKey.getAlgorithm() != 0) {
            try {
                if (this.encData instanceof AEADEncDataPacket) {
                    AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
                    if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                        throw new PGPException("session key and AEAD algorithm mismatch");
                    }
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData, sessionKey);
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                } else if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)this.encData;
                    if (seipd.getVersion() == 1) {
                        PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(true, sessionKey.getAlgorithm(), sessionKey.getKey());
                        BCPGInputStream encIn = this.encData.getInputStream();
                        this.processSymmetricEncIntegrityPacketDataStream(true, dataDecryptor, encIn);
                    } else {
                        PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(seipd, sessionKey);
                        BCPGInputStream encIn = this.encData.getInputStream();
                        this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                    }
                } else {
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(false, sessionKey.getAlgorithm(), sessionKey.getKey());
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.processSymmetricEncIntegrityPacketDataStream(false, dataDecryptor, encIn);
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }
}

