/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.Mergeable;

public class SuggestConfigParamResponse
extends ActionResponse
implements ToXContentObject,
Mergeable {
    public static final String INTERVAL_FIELD = "interval";
    public static final String HORIZON_FIELD = "horizon";
    public static final String HISTORY_FIELD = "history";
    public static final String WINDOW_DELAY_FIELD = "windowDelay";
    private IntervalTimeConfiguration interval;
    private Integer horizon;
    private Integer history;
    private IntervalTimeConfiguration windowDelay;

    public IntervalTimeConfiguration getInterval() {
        return this.interval;
    }

    public Integer getHorizon() {
        return this.horizon;
    }

    public Integer getHistory() {
        return this.history;
    }

    public IntervalTimeConfiguration getWindowDelay() {
        return this.windowDelay;
    }

    public SuggestConfigParamResponse(IntervalTimeConfiguration interval, Integer horizon, Integer history, IntervalTimeConfiguration windowDelay) {
        this.interval = interval;
        this.horizon = horizon;
        this.history = history;
        this.windowDelay = windowDelay;
    }

    public SuggestConfigParamResponse(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readBoolean() ? IntervalTimeConfiguration.readFrom(in) : null;
        this.horizon = in.readOptionalInt();
        this.history = in.readOptionalInt();
        this.windowDelay = in.readBoolean() ? IntervalTimeConfiguration.readFrom(in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.interval != null) {
            out.writeBoolean(true);
            this.interval.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.horizon);
        out.writeOptionalInt(this.history);
        if (this.windowDelay != null) {
            out.writeBoolean(true);
            this.windowDelay.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.interval != null) {
            xContentBuilder.field(INTERVAL_FIELD, (ToXContent)this.interval);
        }
        if (this.horizon != null) {
            xContentBuilder.field(HORIZON_FIELD, this.horizon);
        }
        if (this.history != null) {
            xContentBuilder.field(HISTORY_FIELD, this.history);
        }
        if (this.windowDelay != null) {
            xContentBuilder.field(WINDOW_DELAY_FIELD, (ToXContent)this.windowDelay);
        }
        return xContentBuilder.endObject();
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        SuggestConfigParamResponse otherProfile = (SuggestConfigParamResponse)other;
        if (otherProfile.getInterval() != null) {
            this.interval = otherProfile.getInterval();
        }
        if (otherProfile.getHorizon() != null) {
            this.horizon = otherProfile.getHorizon();
        }
        if (otherProfile.getHistory() != null) {
            this.history = otherProfile.getHistory();
        }
        if (otherProfile.getWindowDelay() != null) {
            this.windowDelay = otherProfile.getWindowDelay();
        }
    }

    /*
     * Exception decompiling
     */
    public static SuggestConfigParamResponse fromActionResponse(ActionResponse actionResponse, NamedWriteableRegistry namedWriteableRegistry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Builder {
        protected IntervalTimeConfiguration interval = null;
        protected Integer horizon = null;
        protected Integer history = null;
        protected IntervalTimeConfiguration windowDelay = null;

        public Builder interval(IntervalTimeConfiguration interval) {
            this.interval = interval;
            return this;
        }

        public Builder horizon(Integer horizon) {
            this.horizon = horizon;
            return this;
        }

        public Builder history(Integer history) {
            this.history = history;
            return this;
        }

        public Builder windowDelay(IntervalTimeConfiguration windowDelay) {
            this.windowDelay = windowDelay;
            return this;
        }

        public SuggestConfigParamResponse build() {
            return new SuggestConfigParamResponse(this.interval, this.horizon, this.history, this.windowDelay);
        }
    }
}

