/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.knn.index.codec.derivedsource.AbstractPerFieldDerivedVectorTransformer;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceReaders;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesFactory;

public class RootPerFieldDerivedVectorTransformer
extends AbstractPerFieldDerivedVectorTransformer {
    private final FieldInfo fieldInfo;
    private final CheckedSupplier<KNNVectorValues<?>, IOException> vectorValuesSupplier;
    private KNNVectorValues<?> vectorValues;

    public RootPerFieldDerivedVectorTransformer(FieldInfo fieldInfo, DerivedSourceReaders derivedSourceReaders) {
        this.fieldInfo = fieldInfo;
        this.vectorValuesSupplier = () -> KNNVectorValuesFactory.getVectorValues(fieldInfo, derivedSourceReaders.getDocValuesProducer(), derivedSourceReaders.getKnnVectorsReader());
    }

    @Override
    public void setCurrentDoc(int offset, int docId) throws IOException {
        this.vectorValues = (KNNVectorValues)this.vectorValuesSupplier.get();
        this.vectorValues.advance(docId);
    }

    @Override
    public Object apply(Object object) {
        if (object == null) {
            return object;
        }
        try {
            return this.formatVector(this.fieldInfo, (CheckedSupplier<Object, IOException>)((CheckedSupplier)this.vectorValues::getVector), (CheckedSupplier<Object, IOException>)((CheckedSupplier)this.vectorValues::conditionalCloneVector));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

