/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering;

import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.util.MutableLong;
import java.util.HashMap;
import java.util.Map;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputFactory;
import org.tribuo.clustering.ClusterID;
import org.tribuo.clustering.ImmutableClusteringInfo;
import org.tribuo.clustering.MutableClusteringInfo;
import org.tribuo.clustering.evaluation.ClusteringEvaluation;
import org.tribuo.clustering.evaluation.ClusteringEvaluator;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.provenance.OutputFactoryProvenance;

public final class ClusteringFactory
implements OutputFactory<ClusterID> {
    private static final long serialVersionUID = 1L;
    public static final ClusterID UNASSIGNED_CLUSTER_ID = new ClusterID(-1);
    private static final ClusteringFactoryProvenance provenance = new ClusteringFactoryProvenance();
    private static final ClusteringEvaluator evaluator = new ClusteringEvaluator();

    public <V> ClusterID generateOutput(V label) {
        return new ClusterID(Integer.parseInt(label.toString()));
    }

    public ClusterID getUnknownOutput() {
        return UNASSIGNED_CLUSTER_ID;
    }

    public MutableOutputInfo<ClusterID> generateInfo() {
        return new MutableClusteringInfo();
    }

    public ImmutableOutputInfo<ClusterID> constructInfoForExternalModel(Map<ClusterID, Integer> mapping) {
        OutputFactory.validateMapping(mapping);
        HashMap<Integer, MutableLong> countsMap = new HashMap<Integer, MutableLong>();
        for (Map.Entry<ClusterID, Integer> e : mapping.entrySet()) {
            countsMap.put(e.getValue(), new MutableLong(1L));
        }
        return new ImmutableClusteringInfo(countsMap);
    }

    public Evaluator<ClusterID, ClusteringEvaluation> getEvaluator() {
        return evaluator;
    }

    public int hashCode() {
        return "ClusteringFactory".hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ClusteringFactory;
    }

    public OutputFactoryProvenance getProvenance() {
        return provenance;
    }

    public static final class ClusteringFactoryProvenance
    implements OutputFactoryProvenance {
        private static final long serialVersionUID = 1L;

        ClusteringFactoryProvenance() {
        }

        public ClusteringFactoryProvenance(Map<String, Provenance> map) {
        }

        public String getClassName() {
            return ClusteringFactory.class.getName();
        }

        public String toString() {
            return this.generateString("OutputFactory");
        }

        public boolean equals(Object other) {
            return other instanceof ClusteringFactoryProvenance;
        }

        public int hashCode() {
            return 31;
        }
    }
}

