/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.spi.utils;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.Strings;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u001c\u0010\f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a&\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0003\u00a8\u0006\u0015"}, d2={"validateUrl", "", "urlString", "", "validateEmail", "email", "isValidUrl", "", "getResolvedIps", "", "Linet/ipaddr/IPAddressString;", "host", "isHostInDenylist", "hostDenyList", "isIpInDenylist", "ip", "Linet/ipaddr/IPAddress;", "denyNetworks", "isValidEmail", "validateMethod", "method", "opensearch-notifications-core-spi"})
@SourceDebugExtension(value={"SMAP\nValidationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/notifications/spi/utils/ValidationHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1#2:202\n11561#3:203\n11896#3,3:204\n1563#4:207\n1634#4,3:208\n1563#4:211\n1634#4,3:212\n*S KotlinDebug\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/notifications/spi/utils/ValidationHelpersKt\n*L\n57#1:203\n57#1:204,3\n72#1:207\n72#1:208,3\n73#1:211\n73#1:212,3\n*E\n"})
public final class ValidationHelpersKt {
    public static final void validateUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!(!Strings.isNullOrEmpty((String)urlString))) {
            boolean $i$a$-require-ValidationHelpersKt$validateUrl$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateUrl$32 = "url is null or empty";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateUrl$32.toString());
        }
        if (!ValidationHelpersKt.isValidUrl(urlString)) {
            boolean bl = false;
            String string = "Invalid URL or unsupported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (!(!Strings.isNullOrEmpty((String)email))) {
            boolean $i$a$-require-ValidationHelpersKt$validateEmail$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateEmail$32 = "FromAddress and recipient should be provided";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateEmail$32.toString());
        }
        if (!ValidationHelpersKt.isValidEmail(email)) {
            boolean bl = false;
            String string = "Invalid email address";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final boolean isValidUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        int index = StringsKt.indexOf$default((CharSequence)urlString, (String)"//", (int)0, (boolean)false, (int)6, null) + 2;
        String string = urlString.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String subString = string;
        Regex regex = new Regex("^(?!.*?_.*?)(?!(?:\\w+?\\.)?-[\\w.\\-]*?)(?!\\w+?-\\.[\\w.\\-]+?)(?=\\w)(?=[\\w.\\-]*?\\.+[\\w.\\-]*?)(?![\\w.\\-]{254})(?!(?:\\.?[\\w\\-.]*?[\\w\\-]{64,}\\.)+?)[\\w.\\-]+?(?<![\\w\\-.]?\\.\\d?)(?<=[\\w\\-]{2,})(?<![\\w\\-]{25})$");
        boolean isFQDN = regex.matches((CharSequence)subString);
        if (isFQDN && !DomainValidator.getInstance().isValid(subString)) {
            return false;
        }
        return Intrinsics.areEqual((Object)subString, (Object)url.getHost()) ? (Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol())) && isFQDN : (Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol())) && !isFQDN;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IPAddressString> getResolvedIps(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        try {
            void $this$mapTo$iv$iv;
            InetAddress[] resolvedIps = InetAddress.getAllByName(host);
            Intrinsics.checkNotNull((Object)resolvedIps);
            InetAddress[] $this$map$iv = resolvedIps;
            boolean $i$f$map = false;
            InetAddress[] inetAddressArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void inetAddress;
                void item$iv$iv;
                void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IPAddressString(inetAddress.getHostAddress()));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LogManager.getLogger().error("Unable to resolve host ips");
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isHostInDenylist(@NotNull String urlString, @NotNull List<String> hostDenyList) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(hostDenyList, (String)"hostDenyList");
        URL url = new URL(urlString);
        if (url.getHost() != null) {
            IPAddress hostAddr;
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            IPAddressString hostIpAddress = new IPAddressString(url.getHost());
            HostName hostStr = new HostName(url.getHost());
            Iterable $this$map$iv = hostDenyList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IPAddressString((String)it));
            }
            List denyNetworks = (List)destination$iv$iv;
            Iterable $this$map$iv2 = hostDenyList;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new HostName((String)it));
            }
            List denyHostnames = (List)destination$iv$iv2;
            for (HostName denyHostStr : denyHostnames) {
                if (!denyHostStr.equals(hostStr)) continue;
                LogManager.getLogger().error(url + ".host is denied (hostname in denylist)");
                return true;
            }
            if (hostIpAddress.isValid() && (hostAddr = hostIpAddress.getAddress()) != null) {
                String string = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
                if (ValidationHelpersKt.isIpInDenylist(hostAddr, denyNetworks, string)) {
                    return true;
                }
            }
            String string = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            List<IPAddressString> resolvedIpStrings = ValidationHelpersKt.getResolvedIps(string);
            for (IPAddressString ipStr : resolvedIpStrings) {
                IPAddress resolvedAddr = ipStr.getAddress();
                if (resolvedAddr == null) continue;
                String string2 = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
                if (!ValidationHelpersKt.isIpInDenylist(resolvedAddr, denyNetworks, string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean isIpInDenylist(IPAddress ip, List<? extends IPAddressString> denyNetworks, String host) {
        IPAddress[] iPAddressArray = new IPAddress[]{ip};
        List candidates = CollectionsKt.mutableListOf((Object[])iPAddressArray);
        if (ip.isIPv4()) {
            try {
                IPAddress ipv6Mapped = new IPAddressString("::ffff:" + ip.toNormalizedString()).getAddress();
                if (ipv6Mapped != null) {
                    candidates.add(ipv6Mapped);
                }
            }
            catch (Exception e) {
                LogManager.getLogger().debug("Failed to create IPv6-mapped address for " + ip);
            }
        }
        if (ip.isIPv6()) {
            try {
                IPv4Address ipv4;
                IPv6Address ipv6Address = ip.toIPv6();
                if (ipv6Address.isIPv4Mapped() && (ipv4 = ipv6Address.getEmbeddedIPv4Address()) != null) {
                    candidates.add(ipv4);
                }
                if (ipv6Address.isIPv4Compatible() && (ipv4 = ipv6Address.getEmbeddedIPv4Address()) != null) {
                    candidates.add(ipv4);
                }
            }
            catch (Exception e) {
                LogManager.getLogger().debug("Failed to extract IPv4 from IPv6 address " + ip);
            }
        }
        for (IPAddress candidate : candidates) {
            for (IPAddressString iPAddressString : denyNetworks) {
                IPAddress denyAddr = iPAddressString.getAddress();
                if (denyAddr == null || (!candidate.isZero() || !denyAddr.isZero()) && !denyAddr.contains(candidate)) continue;
                LogManager.getLogger().error(host + " is denied by rule " + iPAddressString.toNormalizedString() + " (matched " + candidate.toNormalizedString() + ")");
                return true;
            }
        }
        return false;
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final void validateMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!(!Strings.isNullOrEmpty((String)method))) {
            boolean bl = false;
            String string = "Method is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"POST", "PUT", "PATCH"};
        List validMethods = CollectionsKt.listOf((Object[])objectArray);
        if (!(StringsKt.findAnyOf$default((CharSequence)method, (Collection)validMethods, (int)0, (boolean)false, (int)6, null) != null)) {
            boolean bl = false;
            String string = "Invalid method supplied. Only POST, PUT and PATCH are allowed";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

