/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.spark.asyncquery.AsyncQueryJobMetadataStorageService;
import org.opensearch.sql.spark.asyncquery.exceptions.AsyncQueryNotFoundException;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.asyncquery.model.QueryState;
import org.opensearch.sql.spark.execution.statestore.OpenSearchStateStoreUtil;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.execution.xcontent.AsyncQueryJobMetadataXContentSerializer;
import org.opensearch.sql.spark.utils.IDUtils;

public class OpenSearchAsyncQueryJobMetadataStorageService
implements AsyncQueryJobMetadataStorageService {
    private final StateStore stateStore;
    private final AsyncQueryJobMetadataXContentSerializer asyncQueryJobMetadataXContentSerializer;
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchAsyncQueryJobMetadataStorageService.class);

    @Override
    public void storeJobMetadata(AsyncQueryJobMetadata asyncQueryJobMetadata, AsyncQueryRequestContext asyncQueryRequestContext) {
        this.stateStore.create(this.mapIdToDocumentId(asyncQueryJobMetadata.getId()), asyncQueryJobMetadata, AsyncQueryJobMetadata::copy, OpenSearchStateStoreUtil.getIndexName(asyncQueryJobMetadata.getDatasourceName()));
    }

    @Override
    public void updateState(AsyncQueryJobMetadata asyncQueryJobMetadata, QueryState newState, AsyncQueryRequestContext asyncQueryRequestContext) {
    }

    private String mapIdToDocumentId(String id) {
        return "qid" + id;
    }

    @Override
    public Optional<AsyncQueryJobMetadata> getJobMetadata(String queryId) {
        try {
            return this.stateStore.get(this.mapIdToDocumentId(queryId), this.asyncQueryJobMetadataXContentSerializer::fromXContent, OpenSearchStateStoreUtil.getIndexName(IDUtils.decode(queryId)));
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching the job metadata.", (Throwable)e);
            throw new AsyncQueryNotFoundException(String.format("Invalid QueryId: %s", queryId));
        }
    }

    @Generated
    public OpenSearchAsyncQueryJobMetadataStorageService(StateStore stateStore, AsyncQueryJobMetadataXContentSerializer asyncQueryJobMetadataXContentSerializer) {
        this.stateStore = stateStore;
        this.asyncQueryJobMetadataXContentSerializer = asyncQueryJobMetadataXContentSerializer;
    }
}

