/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

public class QueryStringUtils {
    private static final String INTERNAL_TIMESTAMP = "@timestamp";
    public static final String MASK_LITERAL = "***";
    public static final String MASK_COLUMN = "identifier";
    public static final String MASK_TIMESTAMP_COLUMN = "time_identifier";
    public static final String MASK_METADATA_COLUMN = "meta_identifier";
    public static final String LUCENE_SPECIAL_CHARS = "+-&|!(){}[]^\"~:/";

    public static String maskField(String fieldName) {
        if (fieldName.equals(INTERNAL_TIMESTAMP)) {
            return MASK_TIMESTAMP_COLUMN;
        }
        if (fieldName.startsWith("_")) {
            return MASK_METADATA_COLUMN;
        }
        return MASK_COLUMN;
    }

    public static String escapeFieldName(String fieldName) {
        return fieldName.replace(" ", "\\ ");
    }

    public static String escapeLuceneSpecialCharacters(String text) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (LUCENE_SPECIAL_CHARS.indexOf(c) >= 0) {
                if ((c == '&' || c == '|') && i + 1 < text.length() && text.charAt(i + 1) == c) {
                    escaped.append('\\').append(c).append('\\').append(c);
                    ++i;
                    continue;
                }
                escaped.append('\\').append(c);
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

