/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.search.RescoreDocIds;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.query.QuerySearchResult;

@PublicApi(since="1.0.0")
public abstract class SearchPhaseResult
extends TransportResponse {
    private SearchShardTarget searchShardTarget;
    private int shardIndex = -1;
    protected ShardSearchContextId contextId;
    private ShardSearchRequest shardSearchRequest;
    private RescoreDocIds rescoreDocIds = RescoreDocIds.EMPTY;

    protected SearchPhaseResult() {
    }

    protected SearchPhaseResult(StreamInput in) throws IOException {
        super(in);
    }

    @Nullable
    public ShardSearchContextId getContextId() {
        return this.contextId;
    }

    public int getShardIndex() {
        assert (this.shardIndex != -1) : "shardIndex is not set";
        return this.shardIndex;
    }

    public SearchShardTarget getSearchShardTarget() {
        return this.searchShardTarget;
    }

    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        this.searchShardTarget = shardTarget;
    }

    public void setShardIndex(int shardIndex) {
        assert (shardIndex >= 0) : "shardIndex must be >= 0 but was: " + shardIndex;
        this.shardIndex = shardIndex;
    }

    public QuerySearchResult queryResult() {
        return null;
    }

    public FetchSearchResult fetchResult() {
        return null;
    }

    @Nullable
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    public void setShardSearchRequest(ShardSearchRequest shardSearchRequest) {
        this.shardSearchRequest = shardSearchRequest;
    }

    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    public void setRescoreDocIds(RescoreDocIds rescoreDocIds) {
        this.rescoreDocIds = rescoreDocIds;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }
}

