/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class ShardIngestionState
implements Writeable,
ToXContentFragment {
    private static final String SHARD = "shard";
    private static final String POLLER_STATE = "poller_state";
    private static final String ERROR_POLICY = "error_policy";
    private static final String POLLER_PAUSED = "poller_paused";
    private static final String WRITE_BLOCK_ENABLED = "write_block_enabled";
    private static final String BATCH_START_POINTER = "batch_start_pointer";
    private static final String IS_PRIMARY = "is_primary";
    private static final String NODE_NAME = "node";
    private String index;
    private int shardId;
    private String pollerState;
    private String errorPolicy;
    private boolean isPollerPaused;
    boolean isWriteBlockEnabled;
    private String batchStartPointer;
    private boolean isPrimary;
    private String nodeName;

    public ShardIngestionState() {
        this("", -1, "", "", false, false, "", true, "");
    }

    public ShardIngestionState(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.pollerState = in.readOptionalString();
        this.errorPolicy = in.readOptionalString();
        this.isPollerPaused = in.readBoolean();
        this.isWriteBlockEnabled = in.readBoolean();
        this.batchStartPointer = in.readString();
        if (in.getVersion().onOrAfter(Version.V_3_3_0)) {
            this.isPrimary = in.readBoolean();
            this.nodeName = in.readString();
        } else {
            this.isPrimary = true;
            this.nodeName = "";
        }
    }

    public ShardIngestionState(String index, int shardId, @Nullable String pollerState, @Nullable String errorPolicy, boolean isPollerPaused, boolean isWriteBlockEnabled, String batchStartPointer) {
        this(index, shardId, pollerState, errorPolicy, isPollerPaused, isWriteBlockEnabled, batchStartPointer, true, "");
    }

    public ShardIngestionState(String index, int shardId, @Nullable String pollerState, @Nullable String errorPolicy, boolean isPollerPaused, boolean isWriteBlockEnabled, String batchStartPointer, boolean isPrimary, String nodeName) {
        this.index = index;
        this.shardId = shardId;
        this.pollerState = pollerState;
        this.errorPolicy = errorPolicy;
        this.isPollerPaused = isPollerPaused;
        this.isWriteBlockEnabled = isWriteBlockEnabled;
        this.batchStartPointer = batchStartPointer;
        this.isPrimary = isPrimary;
        this.nodeName = nodeName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeOptionalString(this.pollerState);
        out.writeOptionalString(this.errorPolicy);
        out.writeBoolean(this.isPollerPaused);
        out.writeBoolean(this.isWriteBlockEnabled);
        out.writeString(this.batchStartPointer);
        if (out.getVersion().onOrAfter(Version.V_3_3_0)) {
            out.writeBoolean(this.isPrimary);
            out.writeString(this.nodeName);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD, this.shardId);
        builder.field(POLLER_STATE, this.pollerState);
        builder.field(ERROR_POLICY, this.errorPolicy);
        builder.field(POLLER_PAUSED, this.isPollerPaused);
        builder.field(WRITE_BLOCK_ENABLED, this.isWriteBlockEnabled);
        builder.field(BATCH_START_POINTER, this.batchStartPointer);
        builder.field(IS_PRIMARY, this.isPrimary);
        builder.field(NODE_NAME, this.nodeName);
        builder.endObject();
        return builder;
    }

    public static Map<String, List<ShardIngestionState>> groupShardStateByIndex(ShardIngestionState[] shardIngestionStates) {
        HashMap<String, List<ShardIngestionState>> shardIngestionStatesByIndex = new HashMap<String, List<ShardIngestionState>>();
        for (ShardIngestionState state : shardIngestionStates) {
            shardIngestionStatesByIndex.computeIfAbsent(state.getIndex(), index -> new ArrayList());
            ((List)shardIngestionStatesByIndex.get(state.getIndex())).add(state);
        }
        return shardIngestionStatesByIndex;
    }

    public String getIndex() {
        return this.index;
    }

    public int getShardId() {
        return this.shardId;
    }

    public String getPollerState() {
        return this.pollerState;
    }

    public String getErrorPolicy() {
        return this.errorPolicy;
    }

    public boolean isPollerPaused() {
        return this.isPollerPaused;
    }

    public boolean isWriteBlockEnabled() {
        return this.isWriteBlockEnabled;
    }

    public String getBatchStartPointer() {
        return this.batchStartPointer;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setPrimary(boolean primary) {
        this.isPrimary = primary;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}

