/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal;

import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptDependencyTracker;
import org.openhab.core.automation.module.script.ScriptEngineContainer;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.automation.module.script.internal.ScriptExtensionManager;
import org.openhab.core.automation.module.script.internal.ScriptExtensionManagerWrapperImpl;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={ScriptEngineManager.class})
public class ScriptEngineManagerImpl
implements ScriptEngineManager {
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private final Logger logger = LoggerFactory.getLogger(ScriptEngineManagerImpl.class);
    private final Map<String, ScriptEngineContainer> loadedScriptEngineInstances = new HashMap<String, ScriptEngineContainer>();
    private final Map<String, ScriptEngineFactory> factories = new HashMap<String, ScriptEngineFactory>();
    private final ScriptExtensionManager scriptExtensionManager;
    private final Set<ScriptEngineManager.FactoryChangeListener> listeners = new HashSet<ScriptEngineManager.FactoryChangeListener>();

    @Activate
    public ScriptEngineManagerImpl(@Reference ScriptExtensionManager scriptExtensionManager) {
        this.scriptExtensionManager = scriptExtensionManager;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addScriptEngineFactory(ScriptEngineFactory engineFactory) {
        List<String> scriptTypes = engineFactory.getScriptTypes();
        this.logger.trace("{}.getScriptTypes(): {}", (Object)engineFactory.getClass().getSimpleName(), scriptTypes);
        for (String scriptType : scriptTypes) {
            this.factories.put(scriptType, engineFactory);
            this.listeners.forEach(listener -> listener.factoryAdded(scriptType));
        }
        if (this.logger.isDebugEnabled()) {
            if (!scriptTypes.isEmpty()) {
                ScriptEngine scriptEngine = engineFactory.createScriptEngine(scriptTypes.get(0));
                if (scriptEngine != null) {
                    javax.script.ScriptEngineFactory factory = scriptEngine.getFactory();
                    this.logger.debug("Initialized a ScriptEngineFactory for {} ({}): supports {} ({}) with file extensions {}, names {}, and mimetypes {}", new Object[]{factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion(), factory.getExtensions(), factory.getNames(), factory.getMimeTypes()});
                } else {
                    this.logger.trace("addScriptEngineFactory: engine was null");
                }
            } else {
                this.logger.trace("addScriptEngineFactory: scriptTypes was empty");
            }
        }
    }

    public void removeScriptEngineFactory(ScriptEngineFactory engineFactory) {
        List<String> scriptTypes = engineFactory.getScriptTypes();
        this.logger.trace("{}.getScriptTypes(): {}", (Object)engineFactory.getClass().getSimpleName(), scriptTypes);
        for (String scriptType : scriptTypes) {
            this.factories.remove(scriptType, engineFactory);
            this.listeners.forEach(listener -> listener.factoryRemoved(scriptType));
        }
        this.logger.debug("Removed {}", (Object)engineFactory.getClass().getSimpleName());
    }

    @Override
    public @Nullable ScriptEngineContainer createScriptEngine(String scriptType, String engineIdentifier) {
        ScriptEngineContainer result = null;
        ScriptEngineFactory engineFactory = this.findEngineFactory(scriptType);
        if (this.loadedScriptEngineInstances.containsKey(engineIdentifier)) {
            this.removeEngine(engineIdentifier);
        }
        if (engineFactory == null) {
            this.logger.error("ScriptEngine for language '{}' could not be found for identifier: {}", (Object)scriptType, (Object)engineIdentifier);
        } else {
            try {
                ScriptEngine engine = engineFactory.createScriptEngine(scriptType);
                if (engine != null) {
                    HashMap<String, Object> scriptExManager = new HashMap<String, Object>();
                    result = new ScriptEngineContainer(engine, engineFactory, engineIdentifier);
                    ScriptExtensionManagerWrapperImpl wrapper = new ScriptExtensionManagerWrapperImpl(this.scriptExtensionManager, result);
                    scriptExManager.put("scriptExtension", wrapper);
                    scriptExManager.put("se", wrapper);
                    engineFactory.scopeValues(engine, scriptExManager);
                    this.scriptExtensionManager.importDefaultPresets(engineFactory, engine, engineIdentifier);
                    this.loadedScriptEngineInstances.put(engineIdentifier, result);
                    this.logger.debug("Added ScriptEngine for language '{}' with identifier: {}", (Object)scriptType, (Object)engineIdentifier);
                    this.addAttributeToScriptContext(engine, "oh.engine-identifier", engineIdentifier);
                    this.addAttributeToScriptContext(engine, "oh.extension-accessor", this.scriptExtensionManager);
                    ScriptDependencyTracker tracker = engineFactory.getDependencyTracker();
                    if (tracker != null) {
                        this.addAttributeToScriptContext(engine, "oh.dependency-listener", tracker.getTracker(engineIdentifier));
                    }
                } else {
                    this.logger.error("ScriptEngine for language '{}' could not be created for identifier: {}", (Object)scriptType, (Object)engineIdentifier);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error while creating ScriptEngine", (Throwable)ex);
                this.removeScriptExtensions(engineIdentifier);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean loadScript(String engineIdentifier, InputStreamReader scriptData) {
        block8: {
            ScriptEngineContainer container = this.loadedScriptEngineInstances.get(engineIdentifier);
            if (container == null) {
                this.logger.error("Could not load script, as no ScriptEngine has been created");
            } else {
                ScriptEngine engine = container.getScriptEngine();
                try {
                    engine.eval(scriptData);
                    ScriptEngine scriptEngine = engine;
                    if (scriptEngine instanceof Invocable) {
                        Invocable invocable = (Invocable)((Object)scriptEngine);
                        Invocable cfr_ignored_0 = (Invocable)((Object)scriptEngine);
                        try {
                            void inv;
                            inv.invokeFunction("scriptLoaded", engineIdentifier);
                        }
                        catch (NoSuchMethodException e) {
                            this.logger.trace("scriptLoaded() is not defined in the script: {}", (Object)engineIdentifier);
                        }
                    } else {
                        this.logger.trace("ScriptEngine does not support Invocable interface");
                    }
                    return true;
                }
                catch (Exception ex) {
                    this.logger.error("Error during evaluation of script '{}': {}", (Object)engineIdentifier, (Object)ex.getMessage());
                    if (!this.logger.isDebugEnabled()) break block8;
                    this.logger.debug("", (Throwable)ex);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeEngine(String engineIdentifier) {
        ScriptEngineContainer container = this.loadedScriptEngineInstances.remove(engineIdentifier);
        if (container != null) {
            ScriptEngine scriptEngine;
            ScriptEngine scriptEngine2;
            ScriptDependencyTracker tracker = container.getFactory().getDependencyTracker();
            if (tracker != null) {
                tracker.removeTracking(engineIdentifier);
            }
            if ((scriptEngine2 = (scriptEngine = container.getScriptEngine())) instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)scriptEngine2);
                Invocable cfr_ignored_0 = (Invocable)((Object)scriptEngine2);
                try {
                    void inv;
                    inv.invokeFunction("scriptUnloaded", new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    this.logger.trace("scriptUnloaded() is not defined in the script");
                }
                catch (ScriptException ex) {
                    this.logger.error("Error while executing script", (Throwable)ex);
                }
            } else {
                this.logger.trace("ScriptEngine does not support Invocable interface");
            }
            ScriptEngine scriptEngine3 = scriptEngine;
            if (scriptEngine3 instanceof AutoCloseable) {
                void closeable;
                AutoCloseable ex = (AutoCloseable)((Object)scriptEngine3);
                AutoCloseable cfr_ignored_1 = (AutoCloseable)((Object)scriptEngine3);
                this.scheduler.schedule(() -> this.lambda$2((AutoCloseable)closeable), 0L, TimeUnit.SECONDS);
            } else {
                this.logger.trace("ScriptEngine does not support AutoCloseable interface");
            }
            this.removeScriptExtensions(engineIdentifier);
        }
    }

    private void removeScriptExtensions(String pathIdentifier) {
        try {
            this.scriptExtensionManager.dispose(pathIdentifier);
        }
        catch (Exception ex) {
            this.logger.error("Error removing ScriptEngine", (Throwable)ex);
        }
    }

    private @Nullable ScriptEngineFactory findEngineFactory(String scriptType) {
        return this.factories.get(scriptType);
    }

    @Override
    public boolean isSupported(String scriptType) {
        return this.findEngineFactory(scriptType) != null;
    }

    private void addAttributeToScriptContext(ScriptEngine engine, String name, Object value) {
        ScriptContext scriptContext = engine.getContext();
        if (scriptContext == null) {
            scriptContext = new SimpleScriptContext();
            engine.setContext(scriptContext);
        }
        scriptContext.setAttribute(name, value, 100);
    }

    @Override
    public void addFactoryChangeListener(ScriptEngineManager.FactoryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFactoryChangeListener(ScriptEngineManager.FactoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    private /* synthetic */ void lambda$2(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            this.logger.error("Error while closing script engine", (Throwable)e);
        }
    }
}

