/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.netty;

import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.docs.MeterDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NettyMeters implements MeterDocumentation
{
    ALLOCATOR_MEMORY_USED{

        public String getName() {
            return "netty.allocator.memory.used";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getBaseUnit() {
            return "bytes";
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values()});
        }
    }
    ,
    ALLOCATOR_MEMORY_PINNED{

        public String getName() {
            return "netty.allocator.memory.pinned";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getBaseUnit() {
            return "bytes";
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values()});
        }
    }
    ,
    ALLOCATOR_POOLED_ARENAS{

        public String getName() {
            return "netty.allocator.pooled.arenas";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{AllocatorKeyNames.values(), AllocatorMemoryKeyNames.values()});
        }
    }
    ,
    ALLOCATOR_POOLED_CACHE_SIZE{

        public String getName() {
            return "netty.allocator.pooled.cache.size";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getBaseUnit() {
            return "bytes";
        }

        public KeyName[] getKeyNames() {
            return KeyName.merge((KeyName[][])new KeyName[][]{AllocatorKeyNames.values(), AllocatorPooledCacheKeyNames.values()});
        }
    }
    ,
    ALLOCATOR_POOLED_THREADLOCAL_CACHES{

        public String getName() {
            return "netty.allocator.pooled.threadlocal.caches";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return AllocatorKeyNames.values();
        }
    }
    ,
    ALLOCATOR_POOLED_CHUNK_SIZE{

        public String getName() {
            return "netty.allocator.pooled.chunk.size";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public String getBaseUnit() {
            return "bytes";
        }

        public KeyName[] getKeyNames() {
            return AllocatorKeyNames.values();
        }
    }
    ,
    EVENT_EXECUTOR_TASKS_PENDING{

        public String getName() {
            return "netty.eventexecutor.tasks.pending";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getKeyNames() {
            return EventExecutorTasksPendingKeyNames.values();
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum EventExecutorTasksPendingKeyNames implements KeyName
    {
        NAME{

            public String asString() {
                return "name";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum AllocatorPooledCacheKeyNames implements KeyName
    {
        CACHE_TYPE{

            public String asString() {
                return "cache.type";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum AllocatorMemoryKeyNames implements KeyName
    {
        MEMORY_TYPE{

            public String asString() {
                return "memory.type";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum AllocatorKeyNames implements KeyName
    {
        NAME{

            public String asString() {
                return "name";
            }
        }
        ,
        ALLOCATOR_TYPE{

            public String asString() {
                return "allocator.type";
            }
        };

    }
}

