/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldContainer;
import org.infinispan.protostream.descriptors.FieldDescriptor;

public final class OneOfDescriptor {
    private final String name;
    private final String documentation;
    private final List<FieldDescriptor> fields;
    private Descriptor containingMessage;

    private OneOfDescriptor(String name, String documentation, List<FieldDescriptor> fields) {
        this.name = name;
        this.documentation = documentation;
        this.fields = List.copyOf(fields);
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public Descriptor getContainingMessage() {
        return this.containingMessage;
    }

    void setContainingMessage(Descriptor containingMessage) {
        this.containingMessage = containingMessage;
    }

    public String toString() {
        return "OneOfDescriptor{name='" + this.name + "}";
    }

    public static final class Builder
    implements FieldContainer<Builder> {
        private String name;
        private String documentation;
        private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder withFields(List<FieldDescriptor> fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public Builder addField(FieldDescriptor.Builder field) {
            this.fields.add(field.build());
            return this;
        }

        public OneOfDescriptor build() {
            return new OneOfDescriptor(this.name, this.documentation, this.fields);
        }
    }
}

