/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateJavaType
extends AbstractTemporalJavaType<LocalDate> {
    public static final LocalDateJavaType INSTANCE = new LocalDateJavaType();

    public LocalDateJavaType() {
        super(LocalDate.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof LocalDate;
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.DATE;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        if (context.isPreferJavaTimeJdbcTypesEnabled()) {
            return context.getJdbcType(3010);
        }
        return context.getJdbcType(91);
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(LocalDate value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
    }

    @Override
    public LocalDate fromString(CharSequence string) {
        return LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(string));
    }

    @Override
    public <X> X unwrap(LocalDate value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.valueOf(value);
        }
        LocalDateTime localDateTime = value.atStartOfDay();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(localDateTime);
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (java.util.Date.class.equals(type)) {
            return (X)java.util.Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalDate wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return localDate;
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp.toLocalDateTime().toLocalDate();
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            Instant instant = Instant.ofEpochMilli(longValue);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalDate();
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            if (value instanceof Date) {
                Date sqlDate = (Date)value;
                return sqlDate.toLocalDate();
            }
            return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return switch (javaType.getTypeName()) {
            case "java.sql.Date" -> true;
            default -> false;
        };
    }
}

