/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.muc;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/jicofo/xmpp/muc/AutoOwnerRoleManager;", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomRoleManager;", "chatRoom", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoom;", "(Lorg/jitsi/jicofo/xmpp/muc/ChatRoom;)V", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "owner", "Lorg/jitsi/jicofo/xmpp/muc/ChatRoomMember;", "electNewOwner", "", "grantOwnership", "localRoleChanged", "newRole", "Lorg/jitsi/jicofo/xmpp/muc/MemberRole;", "memberJoined", "member", "memberLeftOrKicked", "jicofo"})
@SourceDebugExtension(value={"SMAP\nChatRoomRoleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatRoomRoleManager.kt\norg/jitsi/jicofo/xmpp/muc/AutoOwnerRoleManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class AutoOwnerRoleManager
extends ChatRoomRoleManager {
    @Nullable
    private ChatRoomMember owner;

    public AutoOwnerRoleManager(@NotNull ChatRoom chatRoom) {
        Intrinsics.checkNotNullParameter(chatRoom, "chatRoom");
        super(chatRoom, null);
    }

    @Override
    public void grantOwnership() {
        this.getQueue().add(() -> AutoOwnerRoleManager.grantOwnership$lambda$0(this));
    }

    @Override
    public void memberJoined(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (this.owner == null) {
            this.electNewOwner();
        }
    }

    @Override
    protected void memberLeftOrKicked(@NotNull ChatRoomMember member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (Intrinsics.areEqual(member, this.owner)) {
            this.getLogger().debug("The owner left the room, electing a new one.");
            this.owner = null;
            this.electNewOwner();
        }
    }

    @Override
    public void localRoleChanged(@NotNull MemberRole newRole) {
        Intrinsics.checkNotNullParameter((Object)newRole, "newRole");
        if (!MemberRoleKt.hasOwnerRights(newRole)) {
            this.getLogger().error("Local role has no owner rights, can not manage roles.");
            return;
        }
        this.electNewOwner();
    }

    private final void electNewOwner() {
        this.getQueue().add(() -> AutoOwnerRoleManager.electNewOwner$lambda$3(this));
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u244 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
        $this$_get_debugState__u24lambda_u244.put("class", string);
        Object object = this.owner;
        if (object == null || (object = object.getJid()) == null || (object = object.toString()) == null) {
            object = "null";
        }
        $this$_get_debugState__u24lambda_u244.put("owner", object);
        return orderedJsonObject;
    }

    private static final void grantOwnership$lambda$0(AutoOwnerRoleManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.electNewOwner();
    }

    private static final void electNewOwner$lambda$3(AutoOwnerRoleManager this$0) {
        Object v1;
        block6: {
            Object v0;
            Object object2;
            block5: {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                if (this$0.owner != null) {
                    return;
                }
                Iterable iterable = this$0.getChatRoom().getMembers();
                AutoOwnerRoleManager autoOwnerRoleManager = this$0;
                Iterable iterable2 = iterable;
                for (Object object2 : iterable2) {
                    ChatRoomMember it = (ChatRoomMember)object2;
                    boolean bl = false;
                    if (!(!it.isRobot() && MemberRoleKt.hasOwnerRights(it.getRole()))) continue;
                    v0 = object2;
                    break block5;
                }
                v0 = null;
            }
            autoOwnerRoleManager.owner = v0;
            if (this$0.owner != null) {
                return;
            }
            Iterable iterable = this$0.getChatRoom().getMembers();
            object2 = iterable.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                ChatRoomMember it = (ChatRoomMember)e;
                boolean bl = false;
                if (!(!it.isRobot() && it.getRole() != MemberRole.VISITOR)) continue;
                v1 = e;
                break block6;
            }
            v1 = null;
        }
        ChatRoomMember newOwner = v1;
        if (newOwner != null) {
            this$0.getLogger().info("Electing new owner: " + newOwner);
            this$0.getChatRoom().grantOwnership(newOwner);
            this$0.owner = newOwner;
        }
    }
}

