/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.debugger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.codeWithMe.model.BreakpointModelBase;
import com.jetbrains.codeWithMe.model.BreakpointSuspendPolicy;
import com.jetbrains.codeWithMe.model.BreakpointsModel;
import com.jetbrains.codeWithMe.model.LineBreakpointModel;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.platform.codeWithMe.debugger.CommonBreakpointHost;
import com.jetbrains.rd.platform.codeWithMe.util.ProtocolUtilsKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 32\u00020\u0001:\u00013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0016H&J\u0014\u0010\u001b\u001a\u00020\u00142\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000eH&J\u0014\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000eH&J>\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\f\b\u0000\u0010!*\u0006\u0012\u0002\b\u00030\"*\b\u0012\u0004\u0012\u0002H!0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020&H\u0016J\u001a\u0010'\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u000fJ\b\u0010*\u001a\u00020\u0014H\u0002J\u001c\u0010+\u001a\u00020\u00142\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u00020\u00142\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u0010/\u001a\u0004\u0018\u00010&2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0014\u00100\u001a\u00020\u00142\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0004J\b\u00101\u001a\u00020\u0014H\u0002J@\u00102\u001a\n\u0012\u0004\u0012\u0002H!\u0018\u00010 \"\f\b\u0000\u0010!*\u0006\u0012\u0002\b\u00030\"*\b\u0012\u0004\u0012\u0002H!0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\b\u0012\u00060\u000fj\u0002`\u00100\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/codeWithMe/model/BreakpointsModel;", "getModel", "()Lcom/jetbrains/codeWithMe/model/BreakpointsModel;", "breakpointMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "", "Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointId;", "getBreakpointMap", "()Lcom/intellij/util/containers/BidirectionalMap;", "bindWithModel", "", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "findFileId", "file", "beforeBreakpointAdd", "breakpoint", "doIgnoreBreakpoint", "", "addLineBreakpointImpl", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "P", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "breakpointManager", "Lcom/intellij/xdebugger/breakpoints/XBreakpointManager;", "Lcom/jetbrains/codeWithMe/model/LineBreakpointModel;", "getBreakpointId", "getBreakpointById", "breakpointId", "syncBreakpointsFromModel", "setBreakpointProperties", "breakpointModel", "Lcom/jetbrains/codeWithMe/model/BreakpointModelBase;", "adviseOnBreakpointProperties", "createLineBreakpointModel", "addBreakpointToModel", "syncBreakpointsToModel", "addLineBreakpoint", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nCommonBreakpointHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBreakpointHost.kt\ncom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,254:1\n1#2:255\n13#3:256\n14#4:257\n*S KotlinDebug\n*F\n+ 1 CommonBreakpointHost.kt\ncom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost\n*L\n247#1:256\n247#1:257\n*E\n"})
public abstract class CommonBreakpointHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BidirectionalMap<XBreakpoint<?>, String> breakpointMap;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Companion.id.1 id;

    public CommonBreakpointHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.breakpointMap = new BidirectionalMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected abstract BreakpointsModel getModel();

    @NotNull
    protected final BidirectionalMap<XBreakpoint<?>, String> getBreakpointMap() {
        return this.breakpointMap;
    }

    protected void bindWithModel() {
        this.syncBreakpointsFromModel();
        this.syncBreakpointsToModel();
    }

    @Nullable
    public abstract VirtualFile findFile(@NotNull RdFileId var1);

    @Nullable
    public abstract RdFileId findFileId(@NotNull VirtualFile var1);

    public abstract void beforeBreakpointAdd(@NotNull XBreakpoint<?> var1);

    public abstract boolean doIgnoreBreakpoint(@NotNull XBreakpoint<?> var1);

    @NotNull
    public <P extends XBreakpointProperties<?>> XLineBreakpoint<P> addLineBreakpointImpl(@NotNull XLineBreakpointType<P> $this$addLineBreakpointImpl, @NotNull XBreakpointManager breakpointManager, @NotNull VirtualFile file, @NotNull LineBreakpointModel model) {
        Intrinsics.checkNotNullParameter($this$addLineBreakpointImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)breakpointManager, (String)"breakpointManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        XLineBreakpoint xLineBreakpoint = breakpointManager.addLineBreakpoint($this$addLineBreakpointImpl, file.getUrl(), model.getLine(), $this$addLineBreakpointImpl.createBreakpointProperties(file, model.getLine()), false);
        Intrinsics.checkNotNullExpressionValue((Object)xLineBreakpoint, (String)"addLineBreakpoint(...)");
        return xLineBreakpoint;
    }

    @Nullable
    public final String getBreakpointId(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return (String)this.breakpointMap.get(breakpoint);
    }

    @Nullable
    public final XBreakpoint<?> getBreakpointById(@NotNull String breakpointId) {
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        List keys = this.breakpointMap.getKeysByValue((Object)breakpointId);
        Collection collection = keys;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (keys.size() == 1) {
            return (XBreakpoint)CollectionsKt.single((List)keys);
        }
        logger.error("Multiple breakpoints have the same id = " + breakpointId + ", breakpoints are " + CollectionsKt.joinToString$default((Iterable)keys, null, null, null, (int)0, null, null, (int)63, null));
        throw new IllegalStateException("Multiple breakpoints with the same id");
    }

    private final void syncBreakpointsFromModel() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        this.getModel().getBreakpoints().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> CommonBreakpointHost.syncBreakpointsFromModel$lambda$6(this, breakpointManager, arg_0, arg_1, arg_2));
    }

    private final void setBreakpointProperties(XBreakpoint<?> breakpoint, BreakpointModelBase breakpointModel) {
        ThreadingAssertions.assertEventDispatchThread();
        breakpointModel.isEnabled().set((Object)breakpoint.isEnabled());
        IOptProperty iOptProperty = breakpointModel.getSuspendPolicy();
        SuspendPolicy suspendPolicy = breakpoint.getSuspendPolicy();
        Intrinsics.checkNotNullExpressionValue((Object)suspendPolicy, (String)"getSuspendPolicy(...)");
        iOptProperty.set((Object)ProtocolUtilsKt.toModel(suspendPolicy));
        XExpression xExpression = breakpoint.getConditionExpression();
        breakpointModel.getCondition().set((Object)(xExpression != null ? xExpression.getExpression() : null));
    }

    private final void adviseOnBreakpointProperties(XBreakpoint<?> breakpoint, BreakpointModelBase breakpointModel) {
        ThreadingAssertions.assertEventDispatchThread();
        breakpointModel.isEnabled().advise(this.getServiceLifetime(), arg_0 -> CommonBreakpointHost.adviseOnBreakpointProperties$lambda$7(breakpoint, arg_0));
        breakpointModel.getSuspendPolicy().advise(this.getServiceLifetime(), arg_0 -> CommonBreakpointHost.adviseOnBreakpointProperties$lambda$8(breakpoint, arg_0));
        breakpointModel.getCondition().advise(this.getServiceLifetime(), arg_0 -> CommonBreakpointHost.adviseOnBreakpointProperties$lambda$10(breakpoint, arg_0));
    }

    private final LineBreakpointModel createLineBreakpointModel(XLineBreakpoint<?> breakpoint, String breakpointId) {
        LineBreakpointModel lineBreakpointModel;
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(breakpoint.getFileUrl());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        RdFileId rdFileId = this.findFileId(file);
        if (rdFileId == null) {
            return null;
        }
        RdFileId fileId = rdFileId;
        int n = breakpoint.getLine();
        String string = breakpoint.getType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        LineBreakpointModel $this$createLineBreakpointModel_u24lambda_u2411 = lineBreakpointModel = new LineBreakpointModel(fileId, n, breakpointId, string);
        boolean bl = false;
        this.setBreakpointProperties((XBreakpoint)breakpoint, (BreakpointModelBase)$this$createLineBreakpointModel_u24lambda_u2411);
        this.adviseOnBreakpointProperties((XBreakpoint)breakpoint, (BreakpointModelBase)$this$createLineBreakpointModel_u24lambda_u2411);
        return lineBreakpointModel;
    }

    protected final void addBreakpointToModel(@NotNull XBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (((Map)this.breakpointMap).containsKey(breakpoint)) {
            return;
        }
        String breakpointId = ClientId.Companion.getLocalId().getValue() + id.nextId();
        ((Map)this.breakpointMap).put(breakpoint, breakpointId);
        this.beforeBreakpointAdd(breakpoint);
        if (breakpoint instanceof XLineBreakpoint) {
            LineBreakpointModel lineBreakpointModel = this.createLineBreakpointModel((XLineBreakpoint)breakpoint, breakpointId);
            if (lineBreakpointModel == null) {
                CommonBreakpointHost $this$addBreakpointToModel_u24lambda_u2412 = this;
                boolean bl = false;
                logger.warn("Failed to create breakpoint model for " + breakpoint);
                return;
            }
            LineBreakpointModel breakpointModel = lineBreakpointModel;
            ((Map)this.getModel().getBreakpoints()).put(breakpointId, breakpointModel);
        }
    }

    private final void syncBreakpointsToModel() {
        MessageBusConnection connection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null));
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        Topic topic = XBreakpointListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new XBreakpointListener<XBreakpoint<?>>(this, clientId){
            final /* synthetic */ CommonBreakpointHost this$0;
            final /* synthetic */ ClientId $clientId;
            {
                this.this$0 = $receiver;
                this.$clientId = $clientId;
            }

            public void breakpointAdded(XBreakpoint<?> breakpoint) {
                Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
                if (this.this$0.doIgnoreBreakpoint(breakpoint)) {
                    return;
                }
                ApplicationKt.getApplication().invokeLater(() -> syncBreakpointsToModel.1.breakpointAdded$lambda$1(this.this$0, this.$clientId, breakpoint));
            }

            public void breakpointRemoved(XBreakpoint<?> breakpoint) {
                Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
                if (this.this$0.doIgnoreBreakpoint(breakpoint)) {
                    return;
                }
                ApplicationKt.getApplication().invokeLater(() -> syncBreakpointsToModel.1.breakpointRemoved$lambda$3(this.this$0, breakpoint, this));
            }

            public void breakpointChanged(XBreakpoint<?> breakpoint) {
                Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
                if (this.this$0.doIgnoreBreakpoint(breakpoint)) {
                    return;
                }
                ApplicationKt.getApplication().invokeLater(() -> syncBreakpointsToModel.1.breakpointChanged$lambda$6(this.this$0, breakpoint, this));
            }

            private static final Unit breakpointAdded$lambda$1$lambda$0(CommonBreakpointHost this$0, XBreakpoint $breakpoint) {
                this$0.addBreakpointToModel($breakpoint);
                return Unit.INSTANCE;
            }

            private static final void breakpointAdded$lambda$1(CommonBreakpointHost this$0, ClientId $clientId, XBreakpoint $breakpoint) {
                if (RLifetimeKt.isNotAlive((Lifetime)CommonBreakpointHost.access$getServiceLifetime(this$0))) {
                    return;
                }
                ClientId.Companion.withClientId($clientId, () -> syncBreakpointsToModel.1.breakpointAdded$lambda$1$lambda$0(this$0, $breakpoint));
            }

            private static final void breakpointRemoved$lambda$3(CommonBreakpointHost this$0, XBreakpoint $breakpoint, syncBreakpointsToModel.1 this$1) {
                if (RLifetimeKt.isNotAlive((Lifetime)CommonBreakpointHost.access$getServiceLifetime(this$0))) {
                    return;
                }
                String string = (String)this$0.getBreakpointMap().remove((Object)$breakpoint);
                if (string == null) {
                    syncBreakpointsToModel.1 $this$breakpointRemoved_u24lambda_u243_u24lambda_u242 = this$1;
                    boolean bl = false;
                    CommonBreakpointHost.access$getLogger$cp().error("Breakpoint " + $breakpoint + " was not found, can't remove it from model");
                    return;
                }
                String breakpointId = string;
                this$0.getModel().getBreakpoints().remove((Object)breakpointId);
            }

            private static final void breakpointChanged$lambda$6(CommonBreakpointHost this$0, XBreakpoint $breakpoint, syncBreakpointsToModel.1 this$1) {
                if (RLifetimeKt.isNotAlive((Lifetime)CommonBreakpointHost.access$getServiceLifetime(this$0))) {
                    return;
                }
                String string = (String)this$0.getBreakpointMap().get((Object)$breakpoint);
                if (string == null) {
                    syncBreakpointsToModel.1 $this$breakpointChanged_u24lambda_u246_u24lambda_u244 = this$1;
                    boolean bl = false;
                    CommonBreakpointHost.access$getLogger$cp().error("Breakpoint " + $breakpoint + " was not found, can't remove it from model");
                    return;
                }
                String breakpointId = string;
                BreakpointModelBase breakpointModelBase = (BreakpointModelBase)this$0.getModel().getBreakpoints().get((Object)breakpointId);
                if (breakpointModelBase == null) {
                    syncBreakpointsToModel.1 $this$breakpointChanged_u24lambda_u246_u24lambda_u245 = this$1;
                    boolean bl = false;
                    CommonBreakpointHost.access$getLogger$cp().error("Can't find breakpoint model for id='" + breakpointId + "'");
                    return;
                }
                BreakpointModelBase breakpointModel = breakpointModelBase;
                CommonBreakpointHost.access$setBreakpointProperties(this$0, $breakpoint, breakpointModel);
            }
        });
    }

    private final <P extends XBreakpointProperties<?>> XLineBreakpoint<P> addLineBreakpoint(XLineBreakpointType<P> $this$addLineBreakpoint, XBreakpointManager breakpointManager, VirtualFile file, LineBreakpointModel model) {
        XLineBreakpoint existingBreakpoint = breakpointManager.findBreakpointAtLine($this$addLineBreakpoint, file, model.getLine());
        if (existingBreakpoint != null) {
            return null;
        }
        return this.addLineBreakpointImpl($this$addLineBreakpoint, breakpointManager, file, model);
    }

    private static final void syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$2$lambda$1(CommonBreakpointHost this$0, XBreakpointType $breakpointType, XBreakpointManager $breakpointManager, VirtualFile $file, BreakpointModelBase $breakpointModel, String $breakpointId) {
        XLineBreakpoint breakpoint = this$0.addLineBreakpoint((XLineBreakpointType)$breakpointType, $breakpointManager, $file, (LineBreakpointModel)$breakpointModel);
        if (breakpoint != null) {
            ((Map)this$0.breakpointMap).put(breakpoint, $breakpointId);
            this$0.adviseOnBreakpointProperties((XBreakpoint)breakpoint, $breakpointModel);
        }
    }

    private static final Unit syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$2(CommonBreakpointHost this$0, String $breakpointId, XBreakpointType $breakpointType, XBreakpointManager $breakpointManager, VirtualFile $file, BreakpointModelBase $breakpointModel) {
        if (this$0.breakpointMap.containsValue((Object)$breakpointId)) {
            return Unit.INSTANCE;
        }
        ApplicationKt.getApplication().runWriteAction(() -> CommonBreakpointHost.syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$2$lambda$1(this$0, $breakpointType, $breakpointManager, $file, $breakpointModel, $breakpointId));
        return Unit.INSTANCE;
    }

    private static final void syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$5$lambda$4(XBreakpointManager $breakpointManager, XBreakpointType $breakpointType, VirtualFile $file, BreakpointModelBase $breakpointModel, CommonBreakpointHost this$0) {
        XLineBreakpoint xLineBreakpoint = $breakpointManager.findBreakpointAtLine((XLineBreakpointType)$breakpointType, $file, ((LineBreakpointModel)$breakpointModel).getLine());
        if (xLineBreakpoint == null) {
            CommonBreakpointHost $this$syncBreakpointsFromModel_u24lambda_u246_u24registerLineBreakpoint_u24lambda_u245_u24lambda_u244_u24lambda_u243 = this$0;
            boolean bl = false;
            logger.warn("Not found a breakpoint to delete: type = " + $breakpointType + ", file = " + $file + ", line = " + ((LineBreakpointModel)$breakpointModel).getLine());
            return;
        }
        XLineBreakpoint breakpoint = xLineBreakpoint;
        $breakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
    }

    private static final Unit syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$5(CommonBreakpointHost this$0, XBreakpointManager $breakpointManager, XBreakpointType $breakpointType, VirtualFile $file, BreakpointModelBase $breakpointModel) {
        if (RLifetimeKt.isNotAlive((Lifetime)this$0.getServiceLifetime())) {
            return Unit.INSTANCE;
        }
        ApplicationKt.getApplication().runWriteAction(() -> CommonBreakpointHost.syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$5$lambda$4($breakpointManager, $breakpointType, $file, $breakpointModel, this$0));
        return Unit.INSTANCE;
    }

    private static final void syncBreakpointsFromModel$lambda$6$registerLineBreakpoint(Lifetime $breakpointLifetime, CommonBreakpointHost this$0, String $breakpointId, XBreakpointType breakpointType, XBreakpointManager breakpointManager, BreakpointModelBase $breakpointModel, VirtualFile file) {
        $breakpointLifetime.bracketIfAlive(() -> CommonBreakpointHost.syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$2(this$0, $breakpointId, breakpointType, breakpointManager, file, $breakpointModel), () -> CommonBreakpointHost.syncBreakpointsFromModel$lambda$6$registerLineBreakpoint$lambda$5(this$0, breakpointManager, breakpointType, file, $breakpointModel));
    }

    private static final Unit syncBreakpointsFromModel$lambda$6(CommonBreakpointHost this$0, XBreakpointManager $breakpointManager, Lifetime breakpointLifetime, String breakpointId, BreakpointModelBase breakpointModel) {
        Intrinsics.checkNotNullParameter((Object)breakpointLifetime, (String)"breakpointLifetime");
        Intrinsics.checkNotNullParameter((Object)breakpointId, (String)"breakpointId");
        Intrinsics.checkNotNullParameter((Object)breakpointModel, (String)"breakpointModel");
        if (breakpointModel instanceof LineBreakpointModel) {
            Object v0;
            block5: {
                Iterable iterable = XBreakpointType.EXTENSION_POINT_NAME.getExtensionList();
                for (Object t : iterable) {
                    XBreakpointType it = (XBreakpointType)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)breakpointModel.getBreakpointTypeId())) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            XBreakpointType breakpointType = v0;
            if (breakpointType == null) {
                logger.error("Can't find breakpointType with id = " + breakpointModel.getBreakpointTypeId());
                return Unit.INSTANCE;
            }
            if (!(breakpointType instanceof XLineBreakpointType)) {
                logger.error("Found breakpointType with id = " + breakpointModel.getBreakpointTypeId() + ", but it doesn't implement XLineBreakpointType");
                return Unit.INSTANCE;
            }
            VirtualFile file = this$0.findFile(((LineBreakpointModel)breakpointModel).getFileId());
            if (file == null) {
                logger.warn("File " + ((LineBreakpointModel)breakpointModel).getFileId() + " was not found");
                return Unit.INSTANCE;
            }
            CommonBreakpointHost.syncBreakpointsFromModel$lambda$6$registerLineBreakpoint(breakpointLifetime, this$0, breakpointId, breakpointType, $breakpointManager, breakpointModel, file);
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnBreakpointProperties$lambda$7(XBreakpoint $breakpoint, boolean it) {
        $breakpoint.setEnabled(it);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnBreakpointProperties$lambda$8(XBreakpoint $breakpoint, BreakpointSuspendPolicy it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $breakpoint.setSuspendPolicy(ProtocolUtilsKt.fromModel(it));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit adviseOnBreakpointProperties$lambda$10(XBreakpoint $breakpoint, String it) {
        XExpressionImpl xExpressionImpl;
        XBreakpoint xBreakpoint = $breakpoint;
        String string = it;
        if (string != null) {
            void text;
            String string2 = string;
            XBreakpoint xBreakpoint2 = xBreakpoint;
            boolean bl = false;
            xExpressionImpl = XExpressionImpl.fromText((String)text);
            xBreakpoint = xBreakpoint2;
        } else {
            xExpressionImpl = null;
        }
        xBreakpoint.setConditionExpression((XExpression)xExpressionImpl);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Lifetime access$getServiceLifetime(CommonBreakpointHost $this) {
        return $this.getServiceLifetime();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$setBreakpointProperties(CommonBreakpointHost $this, XBreakpoint breakpoint, BreakpointModelBase breakpointModel) {
        $this.setBreakpointProperties(breakpoint, breakpointModel);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommonBreakpointHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CommonBreakpointHost.logger = logger;
        id = new Object(){
            private int nextId;

            public final int nextId() {
                int n = this.nextId;
                this.nextId = n + 1;
                return n;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "id", "com/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost$Companion$id$1", "Lcom/jetbrains/rd/platform/codeWithMe/debugger/CommonBreakpointHost$Companion$id$1;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

