/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentBlock
extends AbstractJavaBlock {
    public DocCommentBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            DocCommentBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment, indent, settings, javaSettings, formattingMode);
    }

    protected List<Block> buildChildren() {
        ASTNode child;
        ArrayList<Block> result = new ArrayList<Block>();
        boolean isMarkdown = PsiUtil.isInMarkdownDocComment(child.getPsi());
        for (child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JavaDocTokenType.DOC_COMMENT_START || type == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS && isMarkdown) {
                result.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, AlignmentStrategy.getNullStrategy(), this.getFormattingMode()));
                continue;
            }
            if (FormatterUtil.containsWhiteSpacesOnly((ASTNode)child) || child.getText().trim().isEmpty()) continue;
            result.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getSpaceIndent((int)1), null, AlignmentStrategy.getNullStrategy(), this.getFormattingMode()));
        }
        return result;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(Indent.getSpaceIndent((int)1), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingMode", "com/intellij/psi/formatter/java/DocCommentBlock", "<init>"));
    }
}

